/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeHierarchyResolver
extends Pass {
    private Map<String, RecordDeclaration> recordMap = new HashMap<String, RecordDeclaration>();
    private List<EnumDeclaration> enums = new ArrayList<EnumDeclaration>();

    @Override
    public LanguageFrontend getLang() {
        return null;
    }

    @Override
    public void setLang(LanguageFrontend lang) {
    }

    @Override
    public void accept(TranslationResult translationResult) {
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.findRecordsAndEnums(tu);
        }
        for (RecordDeclaration record : this.recordMap.values()) {
            Set<RecordDeclaration> supertypeRecords = this.findSupertypeRecords(record);
            List<MethodDeclaration> allMethodsFromSupertypes = this.getAllMethodsFromSupertypes(supertypeRecords);
            this.analyzeOverridingMethods(record, allMethodsFromSupertypes);
        }
        for (EnumDeclaration enumDecl : this.enums) {
            Set directSupertypeRecords = enumDecl.getSuperTypes().stream().map(s2 -> this.recordMap.getOrDefault(s2.toString(), null)).filter(Objects::nonNull).collect(Collectors.toSet());
            Set<RecordDeclaration> allSupertypes = directSupertypeRecords.stream().map(this::findSupertypeRecords).flatMap(Collection::stream).collect(Collectors.toSet());
            enumDecl.setSuperTypeDeclarations(allSupertypes);
        }
        translationResult.getTranslationUnits().forEach(this::refreshType);
    }

    private void findRecordsAndEnums(Node node) {
        if (node instanceof RecordDeclaration) {
            this.recordMap.putIfAbsent(node.getName(), (RecordDeclaration)node);
        } else if (node instanceof EnumDeclaration) {
            this.enums.add((EnumDeclaration)node);
        }
        for (Node child : SubgraphWalker.getAstChildren(node)) {
            this.findRecordsAndEnums(child);
        }
    }

    private void refreshType(Node node) {
        for (Node child : SubgraphWalker.getAstChildren(node)) {
            this.refreshType(child);
        }
        if (node instanceof HasType) {
            ((HasType)((Object)node)).refreshType();
        }
    }

    private List<MethodDeclaration> getAllMethodsFromSupertypes(Set<RecordDeclaration> supertypeRecords) {
        return supertypeRecords.stream().map(RecordDeclaration::getMethods).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Set<RecordDeclaration> findSupertypeRecords(RecordDeclaration record) {
        Set<RecordDeclaration> superTypeDeclarations = record.getSuperTypes().stream().map(Type::getTypeName).map(this.recordMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
        record.setSuperTypeDeclarations(superTypeDeclarations);
        return superTypeDeclarations;
    }

    private void analyzeOverridingMethods(RecordDeclaration declaration, List<MethodDeclaration> allMethodsFromSupertypes) {
        for (MethodDeclaration superMethod : allMethodsFromSupertypes) {
            List<MethodDeclaration> overrideCandidates = declaration.getMethods().stream().filter(superMethod::isOverrideCandidate).collect(Collectors.toList());
            superMethod.getOverriddenBy().addAll(overrideCandidates);
            overrideCandidates.forEach(o -> o.getOverrides().add(superMethod));
        }
    }

    @Override
    public void cleanup() {
    }
}

