/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FilenameMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorAny;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class ClasspathResource {
    public final File classpathEltFile;
    public final String pathRelativeToClasspathElt;
    public final String pathRelativeToClasspathPrefix;
    public long inputStreamLength;

    protected ClasspathResource(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix) {
        this.classpathEltFile = classpathEltFile;
        this.pathRelativeToClasspathElt = pathRelativeToClasspathElt;
        this.pathRelativeToClasspathPrefix = pathRelativeToClasspathPrefix;
    }

    public String toString() {
        return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.pathRelativeToClasspathElt).toString();
    }

    public abstract InputStream open() throws IOException;

    public long getInputStreamLength() {
        return this.inputStreamLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processFileMatch(FileMatchProcessorAny fileMatchProcessor, LogNode log) throws IOException {
        if (fileMatchProcessor instanceof FilenameMatchProcessor) {
            ((FilenameMatchProcessor)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix);
            return;
        }
        if (fileMatchProcessor instanceof FileMatchProcessor) {
            try {
                InputStream inputStream;
                block24: {
                    inputStream = null;
                    try {
                        inputStream = this.open();
                    }
                    catch (IOException e) {
                        if (log == null) break block24;
                        log.log("Exception while opening file " + this + ": " + e);
                    }
                }
                if (inputStream == null) return;
                ((FileMatchProcessor)fileMatchProcessor).processMatch(this.pathRelativeToClasspathPrefix, inputStream, this.inputStreamLength);
                return;
            }
            finally {
                this.close();
            }
        }
        if (fileMatchProcessor instanceof FileMatchProcessorWithContext) {
            try {
                InputStream inputStream;
                block25: {
                    inputStream = null;
                    try {
                        inputStream = this.open();
                    }
                    catch (IOException e) {
                        if (log == null) break block25;
                        log.log("Exception while opening file " + this + ": " + e);
                    }
                }
                if (inputStream == null) return;
                ((FileMatchProcessorWithContext)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix, inputStream, this.inputStreamLength);
                return;
            }
            finally {
                this.close();
            }
        }
        if (fileMatchProcessor instanceof FileMatchContentsProcessor) {
            try {
                byte[] fileContent;
                block26: {
                    fileContent = null;
                    try {
                        fileContent = FileUtils.readAllBytes(this.open(), this.inputStreamLength, log);
                    }
                    catch (IOException e) {
                        if (log == null) break block26;
                        log.log("Exception while opening file " + this + ": " + e);
                    }
                }
                if (fileContent == null) return;
                ((FileMatchContentsProcessor)fileMatchProcessor).processMatch(this.pathRelativeToClasspathPrefix, fileContent);
                return;
            }
            finally {
                this.close();
            }
        }
        if (!(fileMatchProcessor instanceof FileMatchContentsProcessorWithContext)) throw new RuntimeException("Unknown FileMatchProcessor type " + fileMatchProcessor.getClass().getName());
        try {
            byte[] fileContent;
            block27: {
                fileContent = null;
                try {
                    fileContent = FileUtils.readAllBytes(this.open(), this.inputStreamLength, log);
                }
                catch (IOException e) {
                    if (log == null) break block27;
                    log.log("Exception while opening file " + this + ": " + e);
                }
            }
            if (fileContent == null) return;
            ((FileMatchContentsProcessorWithContext)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix, fileContent);
            return;
        }
        finally {
            this.close();
        }
    }

    public abstract void close();
}

