/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

public class CBuilder
extends IncrementalProjectBuilder {
    private static final String ID = "org.eclipse.cdt.core.cBuilder";

    public static void setupBuilder(ICommand command) {
        command.setBuilderName(ID);
        command.setBuilding(9, false);
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        ICBuildConfiguration config;
        IConsole console;
        block3: {
            try {
                IProject project = this.getProject();
                console = CCorePlugin.getDefault().getConsole();
                console.start(project);
                config = (ICBuildConfiguration)this.getBuildConfig().getAdapter(ICBuildConfiguration.class);
                if (config != null) break block3;
                console.getErrorStream().write(Messages.CBuilder_NotConfiguredCorrectly);
                return null;
            }
            catch (IOException e) {
                throw new CoreException(new Status(4, "org.eclipse.cdt.core", Messages.CBuilder_ExceptionWhileBuilding, (Throwable)e));
            }
        }
        return config.build(kind, args, console, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = this.getProject();
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(project);
            ICBuildConfiguration config = (ICBuildConfiguration)this.getBuildConfig().getAdapter(ICBuildConfiguration.class);
            if (config == null) {
                console.getErrorStream().write(Messages.CBuilder_NotConfiguredCorrectly2);
                return;
            }
            config.clean(console, monitor);
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", Messages.CBuilder_ExceptionWhileBuilding2, (Throwable)e));
        }
    }
}

