/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.options;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.core.options.OptionMetadata;
import org.eclipse.cdt.core.options.OptionStorage;
import org.eclipse.cdt.internal.core.options.OptionMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

public final class OsgiPreferenceStorage
implements OptionStorage {
    private final Preferences preferences;
    private final Set<Class<?>> classes;

    public OsgiPreferenceStorage(Preferences preferences) {
        Objects.requireNonNull(preferences, OptionMessages.OsgiPreferenceStorage_e_null_preference_node);
        this.preferences = preferences;
        this.classes = new HashSet();
        this.classes.add(String.class);
        this.classes.add(Boolean.class);
        this.classes.add(byte[].class);
        this.classes.add(Double.class);
        this.classes.add(Float.class);
        this.classes.add(Integer.class);
        this.classes.add(Long.class);
    }

    @Override
    public <V> boolean consumable(Class<V> valueType) {
        return this.classes.contains(valueType);
    }

    @Override
    public <V> V load(OptionMetadata<V> option) {
        Class<V> valueClass = option.valueClass();
        String identifer = option.identifer();
        V defaultValue = option.defaultValue();
        if (String.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.get(identifer, (String)String.class.cast(defaultValue)));
        }
        if (Boolean.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getBoolean(identifer, (Boolean)Boolean.class.cast(defaultValue)));
        }
        if (byte[].class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getByteArray(identifer, (byte[])byte[].class.cast(defaultValue)));
        }
        if (Double.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getDouble(identifer, (Double)Double.class.cast(defaultValue)));
        }
        if (Float.class.equals(valueClass)) {
            return valueClass.cast(Float.valueOf(this.preferences.getFloat(identifer, ((Float)Float.class.cast(defaultValue)).floatValue())));
        }
        if (Integer.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getInt(identifer, (Integer)Integer.class.cast(defaultValue)));
        }
        if (Long.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getLong(identifer, (Long)Long.class.cast(defaultValue)));
        }
        String message = OptionMessages.PreferenceStorage_e_load_unsupported;
        throw new UnsupportedOperationException(NLS.bind(message, option, valueClass));
    }

    @Override
    public <V> void save(V value, OptionMetadata<V> option) {
        Class<V> valueClass = option.valueClass();
        String identifer = option.identifer();
        if (String.class.equals(valueClass)) {
            this.preferences.put(identifer, (String)String.class.cast(value));
        } else if (Boolean.class.equals(valueClass)) {
            this.preferences.putBoolean(identifer, (Boolean)Boolean.class.cast(value));
        } else if (byte[].class.equals(valueClass)) {
            this.preferences.putByteArray(identifer, (byte[])byte[].class.cast(value));
        } else if (Double.class.equals(valueClass)) {
            this.preferences.putDouble(identifer, (Double)Double.class.cast(value));
        } else if (Float.class.equals(valueClass)) {
            this.preferences.putFloat(identifer, ((Float)Float.class.cast(value)).floatValue());
        } else if (Integer.class.equals(valueClass)) {
            this.preferences.putInt(identifer, (Integer)Integer.class.cast(value));
        } else if (Long.class.equals(valueClass)) {
            this.preferences.putLong(identifer, (Long)Long.class.cast(value));
        } else {
            String message = OptionMessages.PreferenceStorage_e_save_unsupported;
            throw new UnsupportedOperationException(NLS.bind(message, option, valueClass));
        }
    }
}

