/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParserUtil {
    private static IParserLogService parserLogService = new ParserLogService(DebugLogConstants.PARSER);
    private static IParserLogService scannerLogService = new ParserLogService(DebugLogConstants.SCANNER);

    public static IParserLogService getParserLogService() {
        return parserLogService;
    }

    public static IParserLogService getScannerLogService() {
        return scannerLogService;
    }

    public static char[] findWorkingCopyBuffer(String path, Iterator<IWorkingCopy> workingCopies) {
        IResource resultingResource = ParserUtil.getResourceForFilename(path);
        if (resultingResource != null && resultingResource.getType() == 1 && workingCopies.hasNext()) {
            return ParserUtil.findWorkingCopy(resultingResource, workingCopies);
        }
        return null;
    }

    @Deprecated
    public static CodeReader createReader(String path, Iterator<IWorkingCopy> workingCopies) {
        try {
            IResource file = ParserUtil.getResourceForFilename(path);
            if (file instanceof IFile) {
                char[] buffer;
                if (workingCopies != null && workingCopies.hasNext() && (buffer = ParserUtil.findWorkingCopy(file, workingCopies)) != null) {
                    return new CodeReader(InternalParserUtil.normalizePath(path, (IFile)file), buffer);
                }
                return InternalParserUtil.createWorkspaceFileReader(path, (IFile)file, null);
            }
            return InternalParserUtil.createExternalFileReader(path, null);
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public static IResource getResourceForFilename(String finalPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        IPath path = new Path(finalPath);
        Path initialPath = new Path(finalPath);
        IWorkspaceRoot root = workspace.getRoot();
        if (root.getLocation().isPrefixOf(path)) {
            path = path.removeFirstSegments(root.getLocation().segmentCount());
        }
        try {
            IFile file = root.getFile(path);
            if (file != null && file.exists()) {
                return file;
            }
            file = root.getFileForLocation(path);
            if (file != null && file.exists()) {
                return file;
            }
            file = ResourceLookup.selectFileForLocation(initialPath, null);
            if (file != null && file.exists()) {
                return file;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static char[] findWorkingCopy(IResource resultingResource, Iterator<IWorkingCopy> workingCopies) {
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Attempting to find the working copy for " + resultingResource.getName());
        }
        while (workingCopies.hasNext()) {
            IWorkingCopy copy = workingCopies.next();
            if (!resultingResource.equals((Object)copy.getResource())) continue;
            if (parserLogService.isTracing()) {
                parserLogService.traceLog("Working copy found!!");
            }
            return copy.getContents();
        }
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Working copy not found.");
        }
        return null;
    }
}

