/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.List;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.core.settings.model.util.UtilMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class CDataSerializer {
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected static final String DESCRIPTION = "description";
    protected static final String SOURCE_ENTRIES = "sourceEntries";
    protected static final String PATH = "path";
    protected static final String LANGUAGE_ID = "languageId";
    protected static final String CONTENT_TYPE_IDS = "contentTypeIds";
    protected static final String EXTENSIONS = "extensions";
    protected static final String DELIMITER = ";";
    protected static final String FOLDER_DATA = "folderData";
    protected static final String FILE_DATA = "fileData";
    protected static final String BUILD_DATA = "buildData";
    protected static final String TARGET_PLATFORM_DATA = "targetPlatformData";
    protected static final String LANGUAGE_DATA = "languageData";
    protected static final String OUTPUT_ENTRIES = "outputEntries";
    protected static final String ERROR_PARSERS = "errorParsers";
    protected static final String BINARY_PARSERS = "binaryParsers";
    protected static final String CWD = "cwd";
    protected static final String SETTING_ENTRIES = "settingEntries";
    protected static final String SUPPORTED_ENTRY_KINDS = "supportedEntryKinds";
    private static CDataSerializer fInstance;

    public static CDataSerializer getDefault() {
        if (fInstance == null) {
            fInstance = new CDataSerializer();
        }
        return fInstance;
    }

    public CConfigurationData loadConfigurationData(CDataFactory factory, ICStorageElement el) throws CoreException {
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.20")));
        }
        String name = el.getAttribute(NAME);
        CConfigurationData data = factory.createConfigurationdata(id, name, null, false);
        if (data == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.21")));
        }
        String tmp = el.getAttribute(DESCRIPTION);
        if (tmp != null) {
            data.setDescription(tmp);
        }
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String childName = child.getName();
            if (FOLDER_DATA.equals(childName)) {
                CFolderData foData = this.loadFolderData(data, factory, child);
                if (foData != null) {
                    factory.link(data, foData);
                }
            } else if (FILE_DATA.equals(childName)) {
                CFileData fiData = this.loadFileData(data, factory, child);
                if (fiData != null) {
                    factory.link(data, fiData);
                }
            } else if (BUILD_DATA.equals(childName)) {
                CBuildData bData = this.loadBuildData(data, factory, child);
                if (bData != null) {
                    factory.link(data, bData);
                }
            } else if (TARGET_PLATFORM_DATA.equals(childName)) {
                CTargetPlatformData tpData = this.loadTargetPlatformData(data, factory, child);
                if (tpData != null) {
                    factory.link(data, tpData);
                }
            } else if (SOURCE_ENTRIES.equals(childName)) {
                List<ICSettingEntry> list = LanguageSettingEntriesSerializer.loadEntriesList(child, 128);
                ICSourceEntry[] entries = list.toArray(new ICSourceEntry[list.size()]);
                data.setSourceEntries(entries);
            }
            ++i;
        }
        return data;
    }

    public CFolderData loadFolderData(CConfigurationData data, CDataFactory factory, ICStorageElement el) throws CoreException {
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.22")));
        }
        String tmp = el.getAttribute(PATH);
        Path path = null;
        if (tmp != null) {
            path = new Path(tmp);
        }
        if (path == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.23")));
        }
        CFolderData foData = factory.createFolderData(data, null, id, false, path);
        if (foData == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.24")));
        }
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            CLanguageData lData;
            ICStorageElement child = children[i];
            String childName = child.getName();
            if (LANGUAGE_DATA.equals(childName) && (lData = this.loadLanguageData(data, foData, factory, child)) != null) {
                factory.link(foData, lData);
            }
            ++i;
        }
        return foData;
    }

    public CFileData loadFileData(CConfigurationData data, CDataFactory factory, ICStorageElement el) throws CoreException {
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.25")));
        }
        String tmp = el.getAttribute(PATH);
        Path path = null;
        if (tmp != null) {
            path = new Path(tmp);
        }
        if (path == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.26")));
        }
        CFileData fiData = factory.createFileData(data, null, null, id, false, path);
        if (fiData == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.27")));
        }
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            CLanguageData lData;
            ICStorageElement child = children[i];
            String childName = child.getName();
            if (LANGUAGE_DATA.equals(childName) && (lData = this.loadLanguageData(data, fiData, factory, child)) != null) {
                factory.link(fiData, lData);
            }
            ++i;
        }
        return fiData;
    }

    public CBuildData loadBuildData(CConfigurationData data, CDataFactory factory, ICStorageElement el) throws CoreException {
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.28")));
        }
        String name = el.getAttribute(NAME);
        CBuildData bData = factory.createBuildData(data, null, id, name, false);
        if (bData == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.29")));
        }
        String tmp = el.getAttribute(ERROR_PARSERS);
        if (tmp != null) {
            String[] ids = CDataUtil.stringToArray(tmp, DELIMITER);
            bData.setErrorParserIDs(ids);
        }
        if ((tmp = el.getAttribute(CWD)) != null) {
            Path cwd = new Path(tmp);
            bData.setBuilderCWD(cwd);
        }
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String childName = child.getName();
            if (OUTPUT_ENTRIES.equals(childName)) {
                List<ICSettingEntry> list = LanguageSettingEntriesSerializer.loadEntriesList(child);
                int k = 0;
                while (k < list.size()) {
                    ICSettingEntry e = list.get(i);
                    if (e.getKind() != 64) {
                        list.remove(i);
                    }
                    ++k;
                }
                bData.setOutputDirectories(list.toArray(new ICOutputEntry[list.size()]));
            }
            ++i;
        }
        return bData;
    }

    public CTargetPlatformData loadTargetPlatformData(CConfigurationData data, CDataFactory factory, ICStorageElement el) throws CoreException {
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.30")));
        }
        String name = el.getAttribute(NAME);
        CTargetPlatformData tpData = factory.createTargetPlatformData(data, null, id, name, false);
        if (tpData == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.31")));
        }
        String tmp = el.getAttribute(BINARY_PARSERS);
        if (tmp != null) {
            String[] ids = CDataUtil.stringToArray(tmp, DELIMITER);
            tpData.setBinaryParserIds(ids);
        }
        return tpData;
    }

    public CLanguageData loadLanguageData(CConfigurationData data, CResourceData rcData, CDataFactory factory, ICStorageElement el) throws CoreException {
        CLanguageData lData;
        String id = el.getAttribute(ID);
        if (id == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.32")));
        }
        String name = el.getAttribute(NAME);
        String langId = el.getAttribute(LANGUAGE_ID);
        boolean cTypes = true;
        String typesStr = el.getAttribute(CONTENT_TYPE_IDS);
        if (typesStr == null) {
            cTypes = false;
            typesStr = el.getAttribute(EXTENSIONS);
        }
        String[] ids = typesStr != null ? CDataUtil.stringToArray(typesStr, DELIMITER) : CDefaultLanguageData.EMPTY_STRING_ARRAY;
        String tmp = el.getAttribute(SUPPORTED_ENTRY_KINDS);
        int supportedKinds = 0;
        if (tmp != null) {
            String[] strKinds = CDataUtil.stringToArray(tmp, DELIMITER);
            int i = 0;
            while (i < strKinds.length) {
                supportedKinds |= LanguageSettingEntriesSerializer.stringToKind(strKinds[i]);
                ++i;
            }
        }
        if ((lData = factory.createLanguageData(data, rcData, id, name, langId, supportedKinds, ids, cTypes)) == null) {
            throw new CoreException(new Status(4, "org.eclipse.cdt.core", UtilMessages.getString("CDataSerializer.33")));
        }
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String childName = child.getName();
            if (SETTING_ENTRIES.equals(childName)) {
                this.loadEntries(lData, child);
            }
            ++i;
        }
        return lData;
    }

    public void loadEntries(CLanguageData lData, ICStorageElement el) {
        List<ICSettingEntry> entries = LanguageSettingEntriesSerializer.loadEntriesList(el);
        EntryStore store = new EntryStore();
        store.addEntries(entries.toArray(new ICLanguageSettingEntry[entries.size()]));
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            if (store.containsEntriesList(kind)) {
                ICLanguageSettingEntry[] sortedEntries = store.getEntries(kind);
                lData.setEntries(kind, sortedEntries);
            }
            ++i;
        }
    }

    private void setAttribute(ICStorageElement el, String name, String value) {
        if (value != null) {
            el.setAttribute(name, value);
        }
    }

    public void store(CConfigurationData data, ICStorageElement el) throws CoreException {
        CTargetPlatformData tpData;
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        this.setAttribute(el, DESCRIPTION, data.getDescription());
        ICSettingEntry[] entries = data.getSourceEntries();
        ICStorageElement child = el.createChild(SOURCE_ENTRIES);
        LanguageSettingEntriesSerializer.serializeEntries(entries, child);
        CResourceData[] rcDatas = data.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            if (rcData.getType() == 8) {
                child = el.createChild(FILE_DATA);
                this.store((CFileData)rcData, child);
            } else {
                child = el.createChild(FOLDER_DATA);
                this.store((CFolderData)rcData, child);
            }
            ++i;
        }
        CBuildData bData = data.getBuildData();
        if (bData != null) {
            child = el.createChild(BUILD_DATA);
            this.store(bData, child);
        }
        if ((tpData = data.getTargetPlatformData()) != null) {
            child = el.createChild(TARGET_PLATFORM_DATA);
            this.store(tpData, child);
        }
    }

    public void store(CFolderData data, ICStorageElement el) {
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        IPath path = data.getPath();
        if (path != null) {
            this.setAttribute(el, PATH, path.toString());
        }
        CLanguageData[] lDatas = data.getLanguageDatas();
        int i = 0;
        while (i < lDatas.length) {
            ICStorageElement child = el.createChild(LANGUAGE_DATA);
            this.store(lDatas[i], child);
            ++i;
        }
    }

    public void store(CFileData data, ICStorageElement el) {
        CLanguageData lData;
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        IPath path = data.getPath();
        if (path != null) {
            this.setAttribute(el, PATH, path.toString());
        }
        if ((lData = data.getLanguageData()) != null) {
            ICStorageElement child = el.createChild(LANGUAGE_DATA);
            this.store(lData, child);
        }
    }

    public void store(CBuildData data, ICStorageElement el) {
        ICSettingEntry[] outEntries;
        IPath cwd;
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        String[] errParserIds = data.getErrorParserIDs();
        if (errParserIds != null && errParserIds.length != 0) {
            this.setAttribute(el, ERROR_PARSERS, CDataUtil.arrayToString(errParserIds, DELIMITER));
        }
        if ((cwd = data.getBuilderCWD()) != null) {
            this.setAttribute(el, CWD, cwd.toString());
        }
        if ((outEntries = data.getOutputDirectories()) != null && outEntries.length != 0) {
            ICStorageElement child = el.createChild(OUTPUT_ENTRIES);
            LanguageSettingEntriesSerializer.serializeEntries(outEntries, child);
        }
    }

    public void store(CTargetPlatformData data, ICStorageElement el) {
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        String[] binParserIds = data.getBinaryParserIds();
        if (binParserIds != null && binParserIds.length != 0) {
            this.setAttribute(el, BINARY_PARSERS, CDataUtil.arrayToString(binParserIds, DELIMITER));
        }
    }

    public void store(CLanguageData data, ICStorageElement el) {
        this.setAttribute(el, ID, data.getId());
        this.setAttribute(el, NAME, data.getName());
        this.setAttribute(el, LANGUAGE_ID, data.getLanguageId());
        String[] tmp = data.getSourceContentTypeIds();
        if (tmp != null && tmp.length != 0) {
            this.setAttribute(el, CONTENT_TYPE_IDS, CDataUtil.arrayToString(tmp, DELIMITER));
        }
        if ((tmp = data.getSourceExtensions()) != null && tmp.length != 0) {
            this.setAttribute(el, EXTENSIONS, CDataUtil.arrayToString(tmp, DELIMITER));
        }
        int kinds = data.getSupportedEntryKinds();
        int[] allKinds = KindBasedStore.getLanguageEntryKinds();
        StringBuilder buf = new StringBuilder();
        boolean found = false;
        int i = 0;
        while (i < allKinds.length) {
            if ((allKinds[i] & kinds) != 0) {
                if (found) {
                    buf.append(DELIMITER);
                }
                found = true;
                buf.append(LanguageSettingEntriesSerializer.kindToString(allKinds[i]));
            }
            ++i;
        }
        if (found) {
            el.setAttribute(SUPPORTED_ENTRY_KINDS, buf.toString());
        }
        ICStorageElement child = el.createChild(SETTING_ENTRIES);
        this.storeEntries(data, child);
    }

    public void storeEntries(CLanguageData lData, ICStorageElement el) {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            ICSettingEntry[] sortedEntries = lData.getEntries(kind);
            if (sortedEntries != null && sortedEntries.length != 0) {
                LanguageSettingEntriesSerializer.serializeEntries(sortedEntries, el);
            }
            ++i;
        }
    }
}

