/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CExtensionUtil;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.SynchronizedStorageElement;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorageElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CConfigBasedDescriptor
implements ICDescriptor {
    private static final String CEXTENSION_NAME = "cextension";
    private ICConfigurationDescription fCfgDes;
    private COwner fOwner;
    private final Map<String, SynchronizedStorageElement> fStorageDataElMap = new HashMap<String, SynchronizedStorageElement>();
    private volatile boolean fIsDirty;
    private CDescriptorEvent fOpEvent;
    private volatile boolean fIsOpStarted;
    final ILock fLock = Job.getJobManager().newLock();
    SerializingJob serializingJob = new SerializingJob("CConfigBasedDescriptor Serializing Job");

    public CConfigBasedDescriptor(ICConfigurationDescription des) throws CoreException {
        this(des, true);
    }

    public CConfigBasedDescriptor(ICConfigurationDescription des, boolean write) throws CoreException {
        this.updateConfiguration(des, write);
    }

    /*
     * Unable to fully structure code
     */
    void apply(boolean force) throws CoreException {
        block11: {
            this.fIsDirty |= force;
            if (!this.fIsDirty) {
                return;
            }
            if (CProjectDescriptionManager.getInstance().isCurrentThreadSetProjectDescription()) {
                this.serializingJob.schedule();
                return;
            }
            lockDepth = this.fLock.getDepth();
            i = 0;
            while (i < lockDepth) {
                this.fLock.release();
                ++i;
            }
            try {
                Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), new NullProgressMonitor());
                try {
                    this.fLock.acquire();
                    this.serializingJob.serialize();
                }
                finally {
                    if (lockDepth == 0) {
                        this.fLock.release();
                        break block11;
                    }
                    i = 0;
                    if (true) ** GOTO lbl28
                }
                do {
                    this.fLock.acquire();
                    ++i;
lbl28:
                    // 2 sources

                } while (i < lockDepth - 1);
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
        }
    }

    private void checkApply() throws CoreException {
        this.apply(false);
    }

    void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    @Override
    public ICExtensionReference create(String extensionPoint, String id) throws CoreException {
        try {
            ICConfigurationDescription[] cfgs;
            this.fLock.acquire();
            ICConfigExtensionReference ref = this.fCfgDes.create(extensionPoint, id);
            ICProjectDescription des = this.fCfgDes.getProjectDescription();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                if (cfg != this.fCfgDes) {
                    try {
                        cfg.create(extensionPoint, id);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            CConfigBaseDescriptorExtensionReference r = new CConfigBaseDescriptorExtensionReference(ref);
            this.fIsDirty = true;
            this.checkApply();
            if (this.isOperationStarted()) {
                this.setOpEvent(new CDescriptorEvent(this, 1, 32));
            }
            CConfigBaseDescriptorExtensionReference cConfigBaseDescriptorExtensionReference = r;
            return cConfigBaseDescriptorExtensionReference;
        }
        finally {
            this.fLock.release();
        }
    }

    public void updateConfiguration(ICConfigurationDescription des) throws CoreException {
        this.updateConfiguration(des, true);
    }

    public void updateConfiguration(ICConfigurationDescription des, boolean write) throws CoreException {
        try {
            this.fLock.acquire();
            if (write && des instanceof CConfigurationDescriptionCache) {
                throw new IllegalArgumentException();
            }
            this.fCfgDes = des;
            CConfigurationSpecSettings settings = ((IInternalCCfgInfo)((Object)this.fCfgDes)).getSpecSettings();
            this.fOwner = settings.getCOwner();
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICExtensionReference[] get(String extensionPoint) {
        try {
            this.fLock.acquire();
            LinkedHashSet<CConfigBaseDescriptorExtensionReference> extRefs = new LinkedHashSet<CConfigBaseDescriptorExtensionReference>();
            Object[] objectArray = this.fCfgDes.get(extensionPoint);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigExtensionReference cfgRes = objectArray[n2];
                extRefs.add(new CConfigBaseDescriptorExtensionReference(cfgRes));
                ++n2;
            }
            objectArray = this.fCfgDes.getProjectDescription().getConfigurations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object cfg = objectArray[n2];
                if (!cfg.equals(this.fCfgDes)) {
                    ICConfigExtensionReference[] iCConfigExtensionReferenceArray = this.fCfgDes.get(extensionPoint);
                    int n3 = iCConfigExtensionReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigExtensionReference cfgRes = iCConfigExtensionReferenceArray[n4];
                        extRefs.add(new CConfigBaseDescriptorExtensionReference(cfgRes));
                        ++n4;
                    }
                }
                ++n2;
            }
            ICExtensionReference[] iCExtensionReferenceArray = extRefs.toArray(new ICExtensionReference[extRefs.size()]);
            return iCExtensionReferenceArray;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICExtensionReference[] get(String extensionPoint, boolean update) throws CoreException {
        try {
            this.fLock.acquire();
            ICExtensionReference[] refs = this.get(extensionPoint);
            if (refs.length == 0 && update) {
                this.fOwner.update(this.getProject(), this, extensionPoint);
                this.checkApply();
                refs = this.get(extensionPoint);
            }
            ICExtensionReference[] iCExtensionReferenceArray = refs;
            return iCExtensionReferenceArray;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public String getPlatform() {
        try {
            this.fLock.acquire();
            String string = this.fOwner.getPlatform();
            return string;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public IProject getProject() {
        try {
            this.fLock.acquire();
            IProject iProject = this.fCfgDes.getProjectDescription().getProject();
            return iProject;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICStorageElement getProjectStorageElement(String id) throws CoreException {
        try {
            this.fLock.acquire();
            SynchronizedStorageElement storageEl = this.fStorageDataElMap.get(id);
            if (storageEl == null) {
                ICStorageElement el = this.fCfgDes.getProjectDescription().getStorage(id, false);
                if (el == null) {
                    el = this.fCfgDes.getStorage(id, true);
                }
                try {
                    el = el.createCopy();
                }
                catch (UnsupportedOperationException e) {
                    throw ExceptionFactory.createCoreException(e);
                }
                storageEl = SynchronizedStorageElement.synchronizedElement(el);
                this.fStorageDataElMap.put(id, storageEl);
            }
            SynchronizedStorageElement synchronizedStorageElement = storageEl;
            return synchronizedStorageElement;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public Element getProjectData(String id) throws CoreException {
        try {
            ICStorageElement el;
            this.fLock.acquire();
            SynchronizedStorageElement storageEl = this.fStorageDataElMap.get(id);
            if (storageEl == null) {
                el = this.fCfgDes.getProjectDescription().getStorage(id, false);
                if (el == null) {
                    el = this.fCfgDes.getStorage(id, true);
                }
                try {
                    el = el.createCopy();
                }
                catch (UnsupportedOperationException e) {
                    throw ExceptionFactory.createCoreException(e);
                }
                if (!(el instanceof XmlStorageElement)) {
                    throw ExceptionFactory.createCoreException("Internal Error: getProjectData(...) currently only supports XmlStorageElement types.", new Exception());
                }
                final Element xmlEl = ((XmlStorageElement)el).fElement;
                el = new XmlStorageElement((Element)Proxy.newProxyInstance(Element.class.getClassLoader(), new Class[]{Element.class}, new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Method realMethod = xmlEl.getClass().getMethod(method.getName(), method.getParameterTypes());
                        Element element = xmlEl;
                        synchronized (element) {
                            if (method.getName().equals("getParentNode")) {
                                final Node parent = (Node)realMethod.invoke((Object)xmlEl, args);
                                Node parentProxy = (Node)Proxy.newProxyInstance(Node.class.getClassLoader(), new Class[]{Node.class}, new InvocationHandler(){

                                    /*
                                     * Exception decompiling
                                     */
                                    @Override
                                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                        /*
                                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                         * 
                                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                         */
                                        throw new IllegalStateException("Decompilation failed");
                                    }
                                });
                                return parentProxy;
                            }
                            return realMethod.invoke((Object)xmlEl, args);
                        }
                    }

                    static /* synthetic */ CConfigBasedDescriptor access$0(1 var0) {
                        return var0.CConfigBasedDescriptor.this;
                    }
                }));
                storageEl = SynchronizedStorageElement.synchronizedElement(el, xmlEl);
                this.fStorageDataElMap.put(id, storageEl);
            } else {
                el = storageEl.getOriginalElement();
                if (!(el instanceof XmlStorageElement)) {
                    throw ExceptionFactory.createCoreException("Internal Error: getProjectData(...) currently only supports XmlStorageElement types.", new Exception());
                }
            }
            Element element = ((XmlStorageElement)el).fElement;
            return element;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICStorageElement removeProjectStorageElement(String id) throws CoreException {
        try {
            this.fLock.acquire();
            ICStorageElement iCStorageElement = this.fStorageDataElMap.put(id, null);
            return iCStorageElement;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICOwnerInfo getProjectOwner() {
        try {
            this.fLock.acquire();
            COwner cOwner = this.fOwner;
            return cOwner;
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public void remove(ICExtensionReference extension) throws CoreException {
        try {
            this.fLock.acquire();
            ICConfigExtensionReference ref = ((CConfigBaseDescriptorExtensionReference)extension).fCfgExtRef;
            this.fCfgDes.remove(ref);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.fCfgDes.getProjectDescription().getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                if (cfg != this.fCfgDes) {
                    try {
                        ICConfigExtensionReference[] rs;
                        ICConfigExtensionReference[] iCConfigExtensionReferenceArray = rs = cfg.get(ref.getExtensionPoint());
                        int n3 = rs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICConfigExtensionReference element = iCConfigExtensionReferenceArray[n4];
                            if (ref.getID().equals(element.getID())) {
                                cfg.remove(element);
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            this.fIsDirty = true;
            this.checkApply();
            if (this.isOperationStarted()) {
                this.setOpEvent(new CDescriptorEvent(this, 1, 32));
            }
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public void remove(String extensionPoint) throws CoreException {
        try {
            this.fLock.acquire();
            this.fCfgDes.remove(extensionPoint);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.fCfgDes.getProjectDescription().getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                if (cfg != this.fCfgDes) {
                    try {
                        cfg.remove(extensionPoint);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            this.fIsDirty = true;
            this.checkApply();
            if (this.isOperationStarted()) {
                this.setOpEvent(new CDescriptorEvent(this, 1, 32));
            }
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public void saveProjectData() throws CoreException {
        try {
            this.fLock.acquire();
            if (CConfigBasedDescriptor.reconcile(this, this.fCfgDes.getProjectDescription())) {
                this.fIsDirty = true;
                this.apply(true);
                if (this.isOperationStarted()) {
                    this.setOpEvent(new CDescriptorEvent(this, 1, 0));
                }
            }
        }
        finally {
            this.fLock.release();
        }
    }

    @Override
    public ICConfigurationDescription getConfigurationDescription() {
        try {
            this.fLock.acquire();
            ICConfigurationDescription iCConfigurationDescription = this.fCfgDes;
            return iCConfigurationDescription;
        }
        finally {
            this.fLock.release();
        }
    }

    void setOpEvent(CDescriptorEvent event) {
        try {
            this.fLock.acquire();
            if (!this.isOperationStarted()) {
                return;
            }
            if (event.getType() == 2) {
                this.fOpEvent = event;
            } else if (event.getType() == 3) {
                this.fOpEvent = event;
            } else if (this.fOpEvent == null) {
                this.fOpEvent = event;
            } else if ((this.fOpEvent.getFlags() & event.getFlags()) != event.getFlags()) {
                this.fOpEvent = new CDescriptorEvent(event.getDescriptor(), event.getType(), this.fOpEvent.getFlags() | event.getFlags());
            }
        }
        finally {
            this.fLock.release();
        }
    }

    boolean isOperationStarted() {
        return this.fIsOpStarted;
    }

    void operationStart() {
        this.fIsOpStarted = true;
    }

    CDescriptorEvent operationStop() {
        try {
            this.fLock.acquire();
            this.fIsOpStarted = false;
            CDescriptorEvent e = this.fOpEvent;
            this.fOpEvent = null;
            CDescriptorEvent cDescriptorEvent = e;
            return cDescriptorEvent;
        }
        finally {
            this.fLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconcile(CConfigBasedDescriptor descriptor, ICProjectDescription des) throws CoreException {
        try {
            descriptor.fLock.acquire();
            Map<String, SynchronizedStorageElement> map = descriptor.fStorageDataElMap;
            boolean reconciled = false;
            if (!map.isEmpty()) {
                for (Map.Entry<String, SynchronizedStorageElement> entry : map.entrySet()) {
                    String id = entry.getKey();
                    SynchronizedStorageElement synchStor = entry.getValue();
                    if (synchStor != null) {
                        Object object = synchStor.lock();
                        synchronized (object) {
                            if (CConfigBasedDescriptor.reconcile(id, synchStor.getOriginalElement(), des)) {
                                reconciled = true;
                            }
                            continue;
                        }
                    }
                    if (!CConfigBasedDescriptor.reconcile(id, null, des)) continue;
                    reconciled = true;
                }
            }
            boolean bl = reconciled;
            return bl;
        }
        finally {
            descriptor.fLock.release();
        }
    }

    private static boolean reconcile(String id, ICStorageElement newStorEl, ICProjectDescription des) throws CoreException {
        ICStorageElement storEl = des.getStorage(id, false);
        boolean modified = false;
        if (storEl != null) {
            if (newStorEl == null) {
                des.removeStorage(id);
                modified = true;
            } else if (!newStorEl.equals(storEl)) {
                des.importStorage(id, newStorEl);
                modified = true;
            }
        } else if (newStorEl != null) {
            des.importStorage(id, newStorEl);
            modified = true;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDes = iCConfigurationDescriptionArray[n2];
            ICStorageElement el = cfgDes.getStorage(id, false);
            if (el != null) {
                cfgDes.removeStorage(id);
            }
            ++n2;
        }
        return modified;
    }

    final class CConfigBaseDescriptorExtensionReference
    implements ICExtensionReference {
        private final ICConfigExtensionReference fCfgExtRef;

        CConfigBaseDescriptorExtensionReference(ICConfigExtensionReference cfgRef) {
            this.fCfgExtRef = cfgRef;
        }

        @Override
        public ICExtension createExtension() throws CoreException {
            AbstractCExtension cExtension = null;
            IConfigurationElement el = CExtensionUtil.getFirstConfigurationElement(this.fCfgExtRef, CConfigBasedDescriptor.CEXTENSION_NAME, false);
            cExtension = (AbstractCExtension)el.createExecutableExtension("run");
            cExtension.setExtensionReference(this.fCfgExtRef);
            cExtension.setProject(CConfigBasedDescriptor.this.getProject());
            return cExtension;
        }

        @Override
        public ICDescriptor getCDescriptor() {
            return CConfigBasedDescriptor.this;
        }

        @Override
        public String getExtension() {
            return this.fCfgExtRef.getExtensionPoint();
        }

        @Override
        public String getExtensionData(String key) {
            return this.fCfgExtRef.getExtensionData(key);
        }

        @Override
        public IConfigurationElement[] getExtensionElements() throws CoreException {
            IConfigurationElement el = CExtensionUtil.getFirstConfigurationElement(this.fCfgExtRef, CConfigBasedDescriptor.CEXTENSION_NAME, false);
            if (el != null) {
                return el.getChildren();
            }
            return new IConfigurationElement[0];
        }

        @Override
        public String getID() {
            return this.fCfgExtRef.getID();
        }

        @Override
        public void setExtensionData(String key, String value) throws CoreException {
            if (!CDataUtil.objectsEqual(this.fCfgExtRef.getExtensionData(key), value)) {
                CConfigBasedDescriptor.this.fIsDirty = true;
                this.fCfgExtRef.setExtensionData(key, value);
                CConfigBasedDescriptor.this.checkApply();
                if (CConfigBasedDescriptor.this.isOperationStarted()) {
                    CConfigBasedDescriptor.this.setOpEvent(new CDescriptorEvent(CConfigBasedDescriptor.this, 1, 0));
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CConfigBaseDescriptorExtensionReference) {
                return this.fCfgExtRef.equals(((CConfigBaseDescriptorExtensionReference)obj).fCfgExtRef);
            }
            return this.fCfgExtRef.equals(obj);
        }

        public int hashCode() {
            return this.fCfgExtRef.hashCode();
        }
    }

    class SerializingJob
    extends Job {
        public SerializingJob(String name) {
            super(name);
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            try {
                CConfigBasedDescriptor.this.fLock.acquire();
                if (!CConfigBasedDescriptor.this.getProject().isAccessible()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    this.serialize();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            finally {
                CConfigBasedDescriptor.this.fLock.release();
            }
            return Status.OK_STATUS;
        }

        public void serialize() throws CoreException {
            if (!CConfigBasedDescriptor.this.getProject().isAccessible()) {
                throw ExceptionFactory.createCoreException(MessageFormat.format(CCorePlugin.getResourceString("ProjectDescription.ProjectNotAccessible"), CConfigBasedDescriptor.this.getProject().getName()));
            }
            if (CConfigBasedDescriptor.this.fIsDirty) {
                ICProjectDescription des = CConfigBasedDescriptor.this.fCfgDes.getProjectDescription();
                if (des.isCdtProjectCreating()) {
                    des.setCdtProjectCreated();
                }
                CProjectDescriptionManager.getInstance().setProjectDescription(CConfigBasedDescriptor.this.getProject(), des);
                CConfigBasedDescriptor.this.fIsDirty = false;
            }
        }
    }
}

