/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationMap;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ConstPlacement;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ChangeGeneratorMessages;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ChangeGeneratorWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.formatter.ChangeFormatter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeGenerator
extends ASTVisitor {
    private final Map<IASTNode, Map<ASTModification.ModificationKind, List<ASTModification>>> classifiedModifications = new HashMap<IASTNode, Map<ASTModification.ModificationKind, List<ASTModification>>>();
    private int processedOffset;
    private MultiTextEdit rootEdit;
    private CompositeChange change;
    private final ASTModificationStore modificationStore;
    private final NodeCommentMap commentMap;

    public ChangeGenerator(ASTModificationStore modificationStore, NodeCommentMap commentMap) {
        this.shouldVisitArrayModifiers = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitPointerOperators = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitTypeIds = true;
        this.modificationStore = modificationStore;
        this.commentMap = commentMap;
    }

    public void generateChange(IASTNode rootNode) throws ProblemRuntimeException {
        this.generateChange(rootNode, this);
    }

    private void generateChange(IASTNode rootNode, ASTVisitor pathProvider) throws ProblemRuntimeException {
        this.change = new CompositeChange(ChangeGeneratorMessages.ChangeGenerator_compositeChange);
        this.classifyModifications();
        rootNode.accept(pathProvider);
        if (this.rootEdit == null) {
            return;
        }
        IASTTranslationUnit ast = rootNode.getTranslationUnit();
        String source = ast.getRawSignature();
        ITranslationUnit tu = ast.getOriginatingTranslationUnit();
        this.rootEdit = ChangeFormatter.formatChangedCode(source, tu, this.rootEdit);
        TextFileChange subchange = ASTRewriteAnalyzer.createCTextFileChange((IFile)tu.getResource());
        subchange.setEdit((TextEdit)this.rootEdit);
        this.change.add((Change)subchange);
    }

    private void classifyModifications() {
        ASTModificationMap rootModifications = this.modificationStore.getRootModifications();
        if (rootModifications == null) {
            return;
        }
        for (IASTNode node : rootModifications.getModifiedNodes()) {
            List<ASTModification> modifications = rootModifications.getModificationsForNode(node);
            for (ASTModification modification : modifications) {
                ASTModification.ModificationKind kind;
                List<ASTModification> list;
                Map<ASTModification.ModificationKind, List<ASTModification>> map = this.classifiedModifications.get(node);
                if (map == null) {
                    map = new TreeMap<ASTModification.ModificationKind, List<ASTModification>>();
                    this.classifiedModifications.put(node, map);
                }
                if ((list = map.get((Object)(kind = modification.getKind()))) == null) {
                    list = new ArrayList<ASTModification>(2);
                    map.put(kind, list);
                }
                list.add(modification);
            }
        }
    }

    @Override
    public int visit(IASTTranslationUnit tu) {
        IASTFileLocation location = tu.getFileLocation();
        this.processedOffset = location.getNodeOffset();
        return super.visit(tu);
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        this.handleAppends(tu);
        return super.leave(tu);
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        this.handleInserts(declaration);
        if (this.requiresRewrite(declaration)) {
            this.handleReplace(declaration);
            return 1;
        }
        return super.visit(declaration);
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        this.handleInserts(declarator);
        if (this.requiresRewrite(declarator)) {
            this.handleReplace(declarator);
            return 1;
        }
        return super.visit(declarator);
    }

    @Override
    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
        this.handleInserts(baseSpecifier);
        if (this.requiresRewrite(baseSpecifier)) {
            this.handleReplace(baseSpecifier);
            return 1;
        }
        return super.visit(baseSpecifier);
    }

    @Override
    public int leave(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
        if (!this.requiresRewrite(baseSpecifier)) {
            this.handleAppends(baseSpecifier);
        }
        return super.leave(baseSpecifier);
    }

    @Override
    public int visit(IASTArrayModifier arrayModifier) {
        this.handleInserts(arrayModifier);
        if (this.requiresRewrite(arrayModifier)) {
            this.handleReplace(arrayModifier);
            return 1;
        }
        return super.visit(arrayModifier);
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.handleInserts(namespaceDefinition);
        if (this.requiresRewrite(namespaceDefinition)) {
            this.handleReplace(namespaceDefinition);
            return 1;
        }
        return super.visit(namespaceDefinition);
    }

    @Override
    public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
        if (!this.requiresRewrite(namespaceDefinition)) {
            this.handleAppends(namespaceDefinition);
        }
        return super.leave(namespaceDefinition);
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        this.handleInserts(declSpec);
        if (this.requiresRewrite(declSpec)) {
            this.handleReplace(declSpec);
            return 1;
        }
        return super.visit(declSpec);
    }

    @Override
    public int leave(IASTDeclSpecifier declSpec) {
        if (!this.requiresRewrite(declSpec)) {
            this.handleAppends(declSpec);
        }
        return super.leave(declSpec);
    }

    @Override
    public int visit(IASTExpression expression) {
        this.handleInserts(expression);
        if (this.requiresRewrite(expression)) {
            this.handleReplace(expression);
            return 1;
        }
        return super.visit(expression);
    }

    @Override
    public int visit(IASTInitializer initializer) {
        this.handleInserts(initializer);
        if (this.requiresRewrite(initializer)) {
            this.handleReplace(initializer);
            return 1;
        }
        return super.visit(initializer);
    }

    @Override
    public int visit(IASTName name) {
        this.handleInserts(name);
        if (this.requiresRewrite(name)) {
            this.handleReplace(name);
            return 1;
        }
        return super.visit(name);
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.handleInserts(parameterDeclaration);
        if (this.requiresRewrite(parameterDeclaration)) {
            this.handleReplace(parameterDeclaration);
            return 1;
        }
        return super.visit(parameterDeclaration);
    }

    @Override
    public int visit(IASTPointerOperator pointerOperator) {
        this.handleInserts(pointerOperator);
        if (this.requiresRewrite(pointerOperator)) {
            this.handleReplace(pointerOperator);
            return 1;
        }
        return super.visit(pointerOperator);
    }

    @Override
    public int visit(IASTTypeId typeId) {
        this.handleInserts(typeId);
        if (this.requiresRewrite(typeId)) {
            this.handleReplace(typeId);
            return 1;
        }
        return super.visit(typeId);
    }

    @Override
    public int visit(IASTStatement statement) {
        this.handleInserts(statement);
        if (this.requiresRewrite(statement)) {
            this.handleReplace(statement);
            return 1;
        }
        return super.visit(statement);
    }

    @Override
    public int leave(IASTStatement statement) {
        if (!this.requiresRewrite(statement)) {
            this.handleAppends(statement);
        }
        return super.leave(statement);
    }

    private void addChildEdit(TextEdit edit) {
        this.rootEdit.addChild(edit);
        this.processedOffset = edit.getExclusiveEnd();
    }

    private int endOffset(IASTFileLocation nodeLocation) {
        return nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
    }

    private int endOffset(IASTNode node) {
        return this.endOffset(node.getFileLocation());
    }

    private int offset(IASTNode node) {
        return node.getFileLocation().getNodeOffset();
    }

    private void handleInserts(IASTNode anchorNode) {
        List<ASTModification> modifications = this.getModifications(anchorNode, ASTModification.ModificationKind.INSERT_BEFORE);
        if (modifications.isEmpty()) {
            return;
        }
        ChangeGeneratorWriterVisitor writer = this.createChangeWriterForNode(anchorNode);
        IASTNode newNode = null;
        for (ASTModification modification : modifications) {
            boolean first = newNode == null;
            newNode = modification.getNewNode();
            if (first) {
                IASTNode prevNode = this.getPreviousSiblingOrPreprocessorNode(anchorNode);
                if (prevNode != null) {
                    if (ASTWriter.requireBlankLineInBetween(prevNode, newNode)) {
                        writer.newLine();
                    }
                } else if (anchorNode.getParent() instanceof ICPPASTNamespaceDefinition) {
                    writer.newLine();
                }
            }
            newNode.accept(writer);
            if (this.getContainingNodeList(anchorNode) == null) continue;
            writer.getScribe().print(", ");
        }
        if (ASTWriter.requireBlankLineInBetween(newNode, anchorNode)) {
            writer.newLine();
        }
        int insertPos = this.commentMap.getOffsetIncludingComments(anchorNode);
        int length = 0;
        if (writer.getScribe().isAtBeginningOfLine()) {
            String tuCode = anchorNode.getTranslationUnit().getRawSignature();
            length = insertPos = this.skipPrecedingWhitespace(tuCode, insertPos);
            insertPos = this.skipPrecedingBlankLines(tuCode, insertPos);
            length -= insertPos;
        }
        this.addToRootEdit(anchorNode);
        String code = writer.toString();
        if (!code.isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(insertPos, code));
        }
        if (length != 0) {
            this.addChildEdit((TextEdit)new DeleteEdit(insertPos, length));
        }
    }

    private void handleReplace(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.REPLACE);
        String source = node.getTranslationUnit().getRawSignature();
        ChangeGeneratorWriterVisitor writer = this.createChangeWriterForNode(node);
        IASTFileLocation fileLocation = node.getFileLocation();
        this.addToRootEdit(node);
        if (modifications.size() == 1 && modifications.get(0).getNewNode() == null) {
            int offset = this.commentMap.getOffsetIncludingComments(node);
            int endOffset = this.commentMap.getEndOffsetIncludingComments(node);
            offset = Math.max(this.skipPrecedingBlankLines(source, offset), this.processedOffset);
            endOffset = this.skipTrailingBlankLines(source, endOffset);
            IASTNode[] siblingsList = this.getContainingNodeList(node);
            if (siblingsList != null) {
                if (siblingsList.length > 1) {
                    if (node == siblingsList[0]) {
                        endOffset = this.skipToTrailingDelimiter(source, ',', endOffset);
                    } else {
                        offset = this.skipToPrecedingDelimiter(source, ',', offset);
                    }
                } else if (node.getPropertyInParent() == ICPPASTFunctionDefinition.MEMBER_INITIALIZER) {
                    offset = this.skipToPrecedingDelimiter(source, ':', offset);
                }
            }
            IASTNode prevNode = this.getPreviousSiblingOrPreprocessorNode(node);
            IASTNode nextNode = this.getNextSiblingOrPreprocessorNode(node);
            if (prevNode != null && nextNode != null) {
                if (ASTWriter.requireBlankLineInBetween(prevNode, nextNode)) {
                    writer.newLine();
                }
            } else if (node.getParent() instanceof ICPPASTNamespaceDefinition) {
                writer.newLine();
            }
            String code = writer.toString();
            if (endOffset > offset) {
                this.addChildEdit((TextEdit)new DeleteEdit(offset, endOffset - offset));
            }
            if (!code.isEmpty()) {
                this.addChildEdit((TextEdit)new InsertEdit(endOffset, code));
            }
        } else {
            int commentEnd;
            node.accept(writer);
            String code = writer.toString();
            int offset = fileLocation.getNodeOffset();
            int endOffset = offset + fileLocation.getNodeLength();
            String lineSeparator = writer.getScribe().getLineSeparator();
            if (code.endsWith(lineSeparator)) {
                code = code.substring(0, code.length() - lineSeparator.length());
            }
            this.addChildEdit((TextEdit)new ReplaceEdit(offset, endOffset - offset, code));
            if ((node instanceof IASTStatement || node instanceof IASTDeclaration) && (commentEnd = this.commentMap.getEndOffsetIncludingComments(node)) > endOffset) {
                this.addChildEdit((TextEdit)new DeleteEdit(endOffset, commentEnd - endOffset));
            }
        }
    }

    private void handleAppends(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD);
        if (modifications.isEmpty()) {
            return;
        }
        ChangeGeneratorWriterVisitor writer = this.createChangeWriterForNode(node);
        ReplaceEdit anchor = this.getAppendAnchor(node);
        Assert.isNotNull(anchor);
        IASTNode precedingNode = this.getLastNodeBeforeAppendPoint(node);
        for (ASTModification modification : modifications) {
            IASTNode newNode = modification.getNewNode();
            if (precedingNode != null) {
                if (ASTWriter.requireBlankLineInBetween(precedingNode, newNode)) {
                    writer.newLine();
                }
            } else if (node instanceof ICPPASTNamespaceDefinition) {
                writer.newLine();
            }
            precedingNode = null;
            newNode.accept(writer);
        }
        if (node instanceof ICPPASTNamespaceDefinition) {
            writer.newLine();
        }
        this.addToRootEdit(node);
        String code = writer.toString();
        if (!code.isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(anchor.getOffset(), code));
        }
        this.addChildEdit((TextEdit)new ReplaceEdit(anchor.getOffset(), anchor.getLength(), anchor.getText()));
        this.processedOffset = this.endOffset(node);
    }

    private void handleAppends(IASTTranslationUnit node) {
        String code;
        IASTNode nextNode;
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD);
        if (modifications.isEmpty()) {
            return;
        }
        IASTNode prevNode = null;
        IASTDeclaration[] declarations = node.getDeclarations();
        if (declarations.length != 0) {
            prevNode = declarations[declarations.length - 1];
        } else {
            IASTPreprocessorStatement[] preprocessorStatements = node.getAllPreprocessorStatements();
            if (preprocessorStatements.length != 0) {
                prevNode = preprocessorStatements[preprocessorStatements.length - 1];
            }
        }
        int offset = prevNode != null ? this.commentMap.getEndOffsetIncludingComments(prevNode) : 0;
        String source = node.getRawSignature();
        int endOffset = this.skipTrailingBlankLines(source, offset);
        this.addToRootEdit(node);
        ChangeGeneratorWriterVisitor writer = this.createChangeWriterForNode(node);
        IASTNode newNode = null;
        for (ASTModification modification : modifications) {
            boolean first = newNode == null;
            newNode = modification.getNewNode();
            if (first && prevNode != null) {
                writer.newLine();
                if (ASTWriter.requireBlankLineInBetween(prevNode, newNode)) {
                    writer.newLine();
                }
            }
            newNode.accept(writer);
            if (writer.toString().endsWith("\n")) continue;
            writer.newLine();
        }
        if (prevNode != null && (nextNode = this.getNextSiblingOrPreprocessorNode(prevNode)) != null && ASTWriter.requireBlankLineInBetween(newNode, nextNode)) {
            writer.newLine();
        }
        if (!(code = writer.toString()).isEmpty()) {
            this.addChildEdit((TextEdit)new InsertEdit(offset, code));
        }
        if (endOffset > offset) {
            this.addChildEdit((TextEdit)new DeleteEdit(offset, endOffset - offset));
        }
    }

    private ChangeGeneratorWriterVisitor createChangeWriterForNode(IASTNode node) {
        return new ChangeGeneratorWriterVisitor(this.modificationStore, this.commentMap, ConstPlacement.placeConstRight(node));
    }

    private IASTNode[] getContainingNodeList(IASTNode node) {
        if (node.getPropertyInParent() == IASTStandardFunctionDeclarator.FUNCTION_PARAMETER) {
            return ((IASTStandardFunctionDeclarator)node.getParent()).getParameters();
        }
        if (node.getPropertyInParent() == IASTExpressionList.NESTED_EXPRESSION) {
            return ((IASTExpressionList)node.getParent()).getExpressions();
        }
        if (node.getPropertyInParent() == ICPPASTFunctionDefinition.MEMBER_INITIALIZER) {
            return ((ICPPASTFunctionDefinition)node.getParent()).getMemberInitializers();
        }
        if (node.getPropertyInParent() == ICPPASTFunctionDeclarator.EXCEPTION_TYPEID) {
            return ((ICPPASTFunctionDeclarator)node.getParent()).getExceptionSpecification();
        }
        return null;
    }

    private IASTNode getLastNodeBeforeAppendPoint(IASTNode node) {
        IASTNode[] children = node instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)node).getDeclarations(true) : (node instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)node).getDeclarations(true) : node.getChildren());
        int i = children.length;
        while (--i >= 0) {
            IASTNode child = this.getReplacementNode(children[i]);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private IASTNode getReplacementNode(IASTNode node) {
        List<ASTModification> modifications = this.getModifications(node, ASTModification.ModificationKind.REPLACE);
        if (!modifications.isEmpty()) {
            node = modifications.get(modifications.size() - 1).getNewNode();
        }
        return node;
    }

    private IASTNode getPreviousSiblingNode(IASTNode node) {
        IASTNode parent = node.getParent();
        IASTNode[] siblings = parent instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)parent).getDeclarations(true) : (parent instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)parent).getDeclarations(true) : parent.getChildren());
        boolean beforeNode = false;
        int i = siblings.length;
        while (--i >= 0) {
            IASTNode sibling = siblings[i];
            if (sibling == node) {
                beforeNode = true;
                continue;
            }
            if (!beforeNode || this.getReplacementNode(sibling) == null) continue;
            return sibling;
        }
        return null;
    }

    private IASTNode getPreviousSiblingOrPreprocessorNode(IASTNode node) {
        IASTNode sibling;
        int offset = this.offset(node);
        IASTTranslationUnit ast = node.getTranslationUnit();
        IASTPreprocessorStatement[] preprocessorStatements = ast.getAllPreprocessorStatements();
        int low = 0;
        int high = preprocessorStatements.length;
        while (low < high) {
            int mid = low + high >>> 1;
            IASTPreprocessorStatement statement = preprocessorStatements[mid];
            if (statement.isPartOfTranslationUnitFile() && this.endOffset(statement) > offset) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        IASTPreprocessorStatement statement = --low >= 0 ? preprocessorStatements[low] : null;
        IASTNode originalSibling = this.getPreviousSiblingNode(node);
        IASTNode iASTNode = sibling = originalSibling == null ? null : this.getReplacementNode(originalSibling);
        if (statement == null || !statement.isPartOfTranslationUnitFile()) {
            return sibling;
        }
        if (sibling == null) {
            IASTNode parent = node.getParent();
            if (this.offset(parent) >= this.endOffset(statement)) {
                return null;
            }
            return statement;
        }
        return this.endOffset(originalSibling) >= this.endOffset(statement) ? sibling : statement;
    }

    private IASTNode getNextSiblingNode(IASTNode node) {
        IASTNode parent = node.getParent();
        IASTNode[] siblings = parent instanceof ICPPASTNamespaceDefinition ? ((ICPPASTNamespaceDefinition)parent).getDeclarations(true) : (parent instanceof IASTCompositeTypeSpecifier ? ((IASTCompositeTypeSpecifier)parent).getDeclarations(true) : parent.getChildren());
        boolean beforeNode = false;
        IASTNode[] iASTNodeArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode sibling = iASTNodeArray[n2];
            if (sibling == node) {
                beforeNode = true;
            } else if (beforeNode && this.getReplacementNode(sibling) != null) {
                return sibling;
            }
            ++n2;
        }
        return null;
    }

    private IASTNode getNextSiblingOrPreprocessorNode(IASTNode node) {
        IASTNode sibling;
        int endOffset = this.endOffset(node);
        IASTTranslationUnit ast = node.getTranslationUnit();
        IASTPreprocessorStatement[] preprocessorStatements = ast.getAllPreprocessorStatements();
        int low = 0;
        int high = preprocessorStatements.length;
        while (low < high) {
            int mid = (low + high) / 2;
            IASTPreprocessorStatement statement = preprocessorStatements[mid];
            if (statement.isPartOfTranslationUnitFile() && this.offset(statement) > endOffset) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        IASTPreprocessorStatement statement = high < preprocessorStatements.length ? preprocessorStatements[high] : null;
        IASTNode originalSibling = this.getNextSiblingNode(node);
        IASTNode iASTNode = sibling = originalSibling == null ? null : this.getReplacementNode(originalSibling);
        if (statement == null || !statement.isPartOfTranslationUnitFile()) {
            return sibling;
        }
        if (sibling == null) {
            IASTNode parent = node.getParent();
            if (this.endOffset(parent) <= this.offset(statement)) {
                return null;
            }
            return statement;
        }
        return this.offset(originalSibling) <= this.offset(statement) ? sibling : statement;
    }

    private ReplaceEdit getAppendAnchor(IASTNode node) {
        if (!(node instanceof IASTCompositeTypeSpecifier || node instanceof IASTCompoundStatement || node instanceof ICPPASTNamespaceDefinition)) {
            return null;
        }
        String code = node.getRawSignature();
        IASTFileLocation location = node.getFileLocation();
        int pos = location.getNodeOffset() + location.getNodeLength();
        int len = code.endsWith("}") ? 1 : 0;
        int insertPos = code.length() - len;
        int startOfLine = this.skipPrecedingBlankLines(code, insertPos);
        if (startOfLine == insertPos) {
            return new ReplaceEdit(pos - len, len, code.substring(insertPos));
        }
        return new ReplaceEdit(location.getNodeOffset() + startOfLine, insertPos - startOfLine, "");
    }

    private int skipPrecedingWhitespace(String text, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == '\n') {
                return pos + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return 0;
    }

    private int skipPrecedingBlankLines(String text, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == '\n') {
                startPos = pos + 1;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return 0;
    }

    private int skipTrailingBlankLines(String text, int startPos) {
        int pos = startPos;
        while (pos < text.length()) {
            char c = text.charAt(pos);
            if (c == '\n') {
                startPos = pos + 1;
            } else if (!Character.isWhitespace(c)) {
                return startPos;
            }
            ++pos;
        }
        return text.length();
    }

    private int skipToPrecedingDelimiter(String text, char delimiter, int startPos) {
        int pos = startPos;
        while (--pos >= 0) {
            char c = text.charAt(pos);
            if (c == delimiter) {
                return pos;
            }
            if (Character.isWhitespace(c)) continue;
            return startPos;
        }
        return startPos;
    }

    private int skipToTrailingDelimiter(String text, char delimiter, int startPos) {
        int pos = startPos;
        while (pos < text.length()) {
            char c = text.charAt(pos);
            if (c == delimiter) {
                return pos + 1;
            }
            if (!Character.isWhitespace(c)) {
                return startPos;
            }
            ++pos;
        }
        return startPos;
    }

    private void addToRootEdit(IASTNode modifiedNode) {
        if (this.rootEdit == null) {
            this.rootEdit = new MultiTextEdit();
        }
        TextEditGroup editGroup = new TextEditGroup(ChangeGeneratorMessages.ChangeGenerator_group);
        for (List<ASTModification> modifications : this.getModifications(modifiedNode).values()) {
            for (ASTModification modification : modifications) {
                if (modification.getAssociatedEditGroup() == null) continue;
                editGroup = modification.getAssociatedEditGroup();
                this.rootEdit.addChildren(editGroup.getTextEdits());
                return;
            }
        }
    }

    private Map<ASTModification.ModificationKind, List<ASTModification>> getModifications(IASTNode node) {
        Map<ASTModification.ModificationKind, List<ASTModification>> modifications = this.classifiedModifications.get(node);
        if (modifications == null) {
            return Collections.emptyMap();
        }
        return modifications;
    }

    private List<ASTModification> getModifications(IASTNode node, ASTModification.ModificationKind kind) {
        Map<ASTModification.ModificationKind, List<ASTModification>> allModifications = this.getModifications(node);
        List<ASTModification> modifications = allModifications.get((Object)kind);
        if (modifications == null) {
            return Collections.emptyList();
        }
        return modifications;
    }

    private boolean requiresRewrite(IASTNode node) {
        if (!this.getModifications(node, ASTModification.ModificationKind.REPLACE).isEmpty()) {
            return true;
        }
        for (ASTModification modification : this.getModifications(node, ASTModification.ModificationKind.APPEND_CHILD)) {
            if (this.isAppendable(modification)) continue;
            return true;
        }
        return false;
    }

    private boolean isAppendable(ASTModification modification) {
        if (modification.getKind() != ASTModification.ModificationKind.APPEND_CHILD) {
            return false;
        }
        IASTNode node = modification.getNewNode();
        if (node instanceof ContainerNode) {
            for (IASTNode containedNode : ((ContainerNode)node).getNodes()) {
                if (containedNode instanceof IASTDeclaration || containedNode instanceof IASTStatement) continue;
                return false;
            }
            return true;
        }
        return node instanceof IASTDeclaration || node instanceof IASTStatement;
    }

    public Change getChange() {
        return this.change;
    }
}

