/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.core.parser.scanner.ImageLocationInfo;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;

class ASTMacroReferenceName
extends ASTPreprocessorName {
    private ImageLocationInfo fImageLocationInfo;

    public ASTMacroReferenceName(IASTNode parent, ASTNodeProperty property, int offset, int endOffset, IMacroBinding macro, ImageLocationInfo imgLocationInfo) {
        super(parent, property, offset, endOffset, macro.getNameCharArray(), macro);
        this.fImageLocationInfo = imgLocationInfo;
    }

    @Override
    public int getRoleOfName(boolean allowResolution) {
        return 3;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public IASTImageLocation getImageLocation() {
        if (this.fImageLocationInfo != null) {
            LocationMap lr;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (tu != null && (lr = tu.getAdapter(LocationMap.class)) != null) {
                return this.fImageLocationInfo.createLocation(lr, this.fImageLocationInfo);
            }
            return null;
        }
        if (this.getParent() instanceof ASTMacroExpansion && ((ASTMacroExpansion)this.getParent()).getContext().getMacroReference() == this) {
            return super.getImageLocation();
        }
        return null;
    }
}

