/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.index.IndexerSetupParticipant;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public class WaitForRefreshJobs
extends IndexerSetupParticipant {
    private Set<ICProject> fProjects = new HashSet<ICProject>();
    private Set<Job> fRefreshJobs = Collections.synchronizedSet(new HashSet());
    private IJobChangeListener fJobListener = new IJobChangeListener(){

        @Override
        public void sleeping(IJobChangeEvent event) {
        }

        @Override
        public void scheduled(IJobChangeEvent event) {
        }

        @Override
        public void running(IJobChangeEvent event) {
        }

        @Override
        public void done(IJobChangeEvent event) {
            WaitForRefreshJobs.this.onJobDone(event.getJob());
        }

        @Override
        public void awake(IJobChangeEvent event) {
        }

        @Override
        public void aboutToRun(IJobChangeEvent event) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postponeIndexerSetup(ICProject project) {
        WaitForRefreshJobs waitForRefreshJobs = this;
        synchronized (waitForRefreshJobs) {
            block4: {
                if (!this.isRefreshing()) break block4;
                this.fProjects.add(project);
                return true;
            }
        }
        return false;
    }

    protected void onJobDone(Job job) {
        this.fRefreshJobs.remove(job);
        if (this.fRefreshJobs.isEmpty()) {
            this.checkNotifyIndexer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotifyIndexer() {
        Set<ICProject> projects;
        WaitForRefreshJobs waitForRefreshJobs = this;
        synchronized (waitForRefreshJobs) {
            if (this.isRefreshing()) {
                return;
            }
            projects = this.fProjects;
            this.fProjects = new HashSet<ICProject>();
        }
        for (ICProject project : projects) {
            this.notifyIndexerSetup(project);
        }
    }

    private boolean isRefreshing() {
        this.updateRefreshJobs(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        if (this.fRefreshJobs.size() != 0) {
            return true;
        }
        this.updateRefreshJobs(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
        return this.fRefreshJobs.size() != 0;
    }

    private void updateRefreshJobs(Object jobFamily) {
        IJobManager jobManager = Job.getJobManager();
        Job[] refreshJobs = jobManager.find(jobFamily);
        if (refreshJobs != null) {
            Job[] jobArray = refreshJobs;
            int n = refreshJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job j = jobArray[n2];
                if (this.fRefreshJobs.add(j)) {
                    j.addJobChangeListener(this.fJobListener);
                    if (j.getState() == 0) {
                        this.fRefreshJobs.remove(j);
                    }
                }
                ++n2;
            }
        }
    }
}

