/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPArgumentList {
    private static final int NODE_SIZE = 6;

    public static long putArguments(PDOMNode parent, ICPPTemplateArgument[] templateArguments) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(templateArguments.length, 682);
        long p = block = db.malloc(2 + 6 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            ICPPTemplateArgument arg = templateArguments[i];
            linkage.storeTemplateArgument(p, arg);
            ++i;
            p += 6L;
        }
        return block;
    }

    public static void clearArguments(PDOMNode parent, long record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue(len >= 0 && len <= 682);
        long p = record + 2L;
        int i = 0;
        while (i < len) {
            linkage.storeTemplateArgument(p, null);
            p += 6L;
            ++i;
        }
        db.free(record);
    }

    public static ICPPTemplateArgument[] getArguments(PDOMNode parent, long rec) throws CoreException {
        if (rec == 0L) {
            CCorePlugin.log(new IllegalArgumentException("Trying to access template arguments before they have been stored."));
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue(len >= 0 && len <= 682);
        if (len == 0) {
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        rec += 2L;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[len];
        int i = 0;
        while (i < len) {
            ICPPTemplateArgument arg = linkage.loadTemplateArgument(rec);
            if (arg == null) {
                arg = new CPPTemplateTypeArgument(new ProblemType(10005));
            }
            result[i] = arg;
            rec += 6L;
            ++i;
        }
        return result;
    }
}

