/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.Map;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSorting;
import org.neo4j.ogm.cypher.query.SortOrder;

public class PagingAndSortingQuery
implements PagingAndSorting {
    private Pagination paging;
    private SortOrder sortOrder = new SortOrder();
    private String matchClause;
    private String returnClause;
    private final Map<String, Object> parameters;
    private boolean returnsPath = false;
    private boolean hasPredicate;
    private String variable;

    public PagingAndSortingQuery(String matchClause, String returnClause, Map<String, Object> parameters, boolean returnsPath, boolean hasPredicate) {
        this(matchClause, returnClause, parameters, returnsPath, hasPredicate, "n");
    }

    public PagingAndSortingQuery(String matchClause, String returnClause, Map<String, Object> parameters, boolean returnsPath, boolean hasPredicate, String variable) {
        this.matchClause = matchClause;
        this.returnClause = returnClause;
        this.parameters = parameters;
        this.returnsPath = returnsPath;
        this.hasPredicate = hasPredicate;
        this.variable = variable;
    }

    public String getStatement() {
        String sorting = this.sortOrder().asString();
        StringBuilder sb = new StringBuilder();
        sb.append(this.matchClause);
        if (!sorting.isEmpty()) {
            sb.append(sorting.replace("$", this.variable));
        }
        if (this.paging != null) {
            sb.append(this.paging.toString());
        }
        sb.append(this.returnClause);
        if (this.needsRowResult()) {
            sb.append(", ID(").append(this.variable).append(")");
        }
        return sb.toString();
    }

    public boolean needsRowResult() {
        return (this.sortOrder.hasSortClauses() || this.paging != null || this.hasPredicate) && this.returnsPath;
    }

    @Override
    public PagingAndSortingQuery setPagination(Pagination paging) {
        this.paging = paging;
        return this;
    }

    @Override
    public PagingAndSortingQuery setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public void setReturnsPath(boolean returnsPath) {
        this.returnsPath = returnsPath;
    }

    private Pagination page() {
        return this.paging;
    }

    private SortOrder sortOrder() {
        return this.sortOrder;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

