/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.context.DirectedRelationship;
import org.neo4j.ogm.context.DirectedRelationshipForType;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAccessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityAccessManager.class);
    private static Map<ClassInfo, Map<DirectedRelationship, FieldInfo>> relationalReaderCache = new HashMap<ClassInfo, Map<DirectedRelationship, FieldInfo>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>> relationalWriterCache = new HashMap<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>> iterableWriterCache = new HashMap<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>>();
    private static final boolean STRICT_MODE = true;
    private static final boolean INFERRED_MODE = false;

    public static Object merge(Class<?> parameterType, Object newValues, Object[] currentValues, Class elementType) {
        if (currentValues != null) {
            return EntityAccessManager.merge(parameterType, newValues, Arrays.asList(currentValues), elementType);
        }
        return EntityAccessManager.merge(parameterType, newValues, new ArrayList(), elementType);
    }

    public static Object merge(Class<?> parameterType, Object newValues, Collection currentValues, Class elementType) {
        if (newValues != null) {
            newValues = EntityAccessManager.boxPrimitiveArray(newValues);
            newValues = EntityAccessManager.stringToCharacterIterable(newValues, parameterType, elementType);
        }
        if (parameterType.isArray()) {
            Class<?> type = parameterType.getComponentType();
            ArrayList<Object> objects = new ArrayList<Object>(EntityAccessManager.union((Collection)newValues, currentValues, elementType));
            Object array = Array.newInstance(type, objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                Array.set(array, i, Utils.coerceTypes(type, objects.get(i)));
            }
            return array;
        }
        Collection<?> newCollection = EntityAccessManager.createCollection(parameterType, (Collection)newValues, currentValues, elementType);
        if (newCollection != null) {
            return newCollection;
        }
        assert (newValues != null);
        if (parameterType.isAssignableFrom(newValues.getClass())) {
            return newValues;
        }
        throw new RuntimeException("Unsupported: " + parameterType.getName());
    }

    private static Collection<?> createCollection(Class<?> parameterType, Collection collection, Collection hydrated, Class elementType) {
        if (Vector.class.isAssignableFrom(parameterType)) {
            return new Vector<Object>(EntityAccessManager.union(collection, hydrated, elementType));
        }
        if (List.class.isAssignableFrom(parameterType)) {
            return new ArrayList<Object>(EntityAccessManager.union(collection, hydrated, elementType));
        }
        if (SortedSet.class.isAssignableFrom(parameterType)) {
            return new TreeSet<Object>(EntityAccessManager.union(collection, hydrated, elementType));
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return new HashSet<Object>(EntityAccessManager.union(collection, hydrated, elementType));
        }
        return null;
    }

    private static Collection<Object> union(Collection collection, Collection hydrated, Class elementType) {
        if (collection == null) {
            return hydrated;
        }
        if (hydrated == null || hydrated.size() == 0) {
            ArrayList<Object> result = new ArrayList<Object>(collection.size());
            for (Object object : collection) {
                result.add(Utils.coerceTypes(elementType, object));
            }
            return result;
        }
        int resultSize = collection.size();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(resultSize += hydrated.size());
        if (hydrated.size() > collection.size()) {
            result.addAll(hydrated);
            EntityAccessManager.addToCollection(collection, result, elementType);
        } else {
            EntityAccessManager.addToCollection(collection, result, elementType);
            EntityAccessManager.addToCollection(hydrated, result, elementType);
        }
        return result;
    }

    private static void addToCollection(Collection add, Collection<Object> addTo, Class elementType) {
        for (Object object : add) {
            addTo.add(Utils.coerceTypes(elementType, object));
        }
    }

    private static Object stringToCharacterIterable(Object value, Class parameterType, Class elementType) {
        boolean convertCharacters = false;
        if (value instanceof String) {
            char[] chars = ((String)value).toCharArray();
            ArrayList<Character> characters = new ArrayList<Character>(chars.length);
            for (char c : chars) {
                characters.add(Character.valueOf(c));
            }
            return characters;
        }
        if (parameterType.getComponentType() != null) {
            if (parameterType.getComponentType().equals(Character.class)) {
                convertCharacters = true;
            }
        } else if (elementType == Character.class || elementType == Character.TYPE) {
            convertCharacters = true;
        }
        if (value.getClass().isArray() && convertCharacters && value.getClass().getComponentType().equals(String.class)) {
            String[] strings = (String[])value;
            ArrayList<Character> characters = new ArrayList<Character>(strings.length);
            for (String s2 : strings) {
                characters.add(Character.valueOf(s2.toCharArray()[0]));
            }
            return characters;
        }
        if (value.getClass().isArray() && (elementType == String.class || elementType.isEnum())) {
            String[] strings = (String[])value;
            return Arrays.asList(strings);
        }
        return value;
    }

    private static Object boxPrimitiveArray(Object value) {
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            switch (value.getClass().getComponentType().toString()) {
                case "int": {
                    int[] intArray = (int[])value;
                    ArrayList<Integer> boxedIntList = new ArrayList<Integer>(intArray.length);
                    for (int i : intArray) {
                        boxedIntList.add(i);
                    }
                    return boxedIntList;
                }
                case "float": {
                    float[] floatArray = (float[])value;
                    ArrayList<Float> boxedFloatList = new ArrayList<Float>(floatArray.length);
                    for (float f : floatArray) {
                        boxedFloatList.add(Float.valueOf(f));
                    }
                    return boxedFloatList;
                }
                case "long": {
                    long[] longArray = (long[])value;
                    ArrayList<Long> boxedLongList = new ArrayList<Long>(longArray.length);
                    for (long l : longArray) {
                        boxedLongList.add(l);
                    }
                    return boxedLongList;
                }
                case "double": {
                    double[] dblArray = (double[])value;
                    ArrayList<Double> boxedDoubleList = new ArrayList<Double>(dblArray.length);
                    for (double d : dblArray) {
                        boxedDoubleList.add(d);
                    }
                    return boxedDoubleList;
                }
                case "boolean": {
                    boolean[] booleanArray = (boolean[])value;
                    ArrayList<Boolean> boxedBooleanList = new ArrayList<Boolean>(booleanArray.length);
                    for (boolean b : booleanArray) {
                        boxedBooleanList.add(b);
                    }
                    return boxedBooleanList;
                }
                case "char": {
                    char[] charArray = (char[])value;
                    ArrayList<Character> boxedCharList = new ArrayList<Character>(charArray.length);
                    for (char c : charArray) {
                        boxedCharList.add(Character.valueOf(c));
                    }
                    return boxedCharList;
                }
            }
        }
        return value;
    }

    public static FieldInfo getRelationalWriter(ClassInfo classInfo, String relationshipType, String relationshipDirection, Object scalarValue) {
        return EntityAccessManager.getRelationalWriter(classInfo, relationshipType, relationshipDirection, scalarValue.getClass());
    }

    public static FieldInfo getRelationalWriter(ClassInfo classInfo, String relationshipType, String relationshipDirection, Class<?> objectType) {
        if (!relationalWriterCache.containsKey(classInfo)) {
            relationalWriterCache.put(classInfo, new HashMap());
        }
        DirectedRelationshipForType directedRelationship = new DirectedRelationshipForType(relationshipType, relationshipDirection, objectType);
        if (relationalWriterCache.get(classInfo).containsKey(directedRelationship)) {
            return relationalWriterCache.get(classInfo).get(directedRelationship);
        }
        ClassInfo lookupClassInfo = classInfo;
        while (classInfo != null) {
            for (FieldInfo fieldInfo : classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, true)) {
                if (fieldInfo == null || fieldInfo.getAnnotations().isEmpty() || !fieldInfo.isTypeOf(objectType) && !fieldInfo.isParameterisedTypeOf(objectType) && !fieldInfo.isArrayOf(objectType)) continue;
                relationalWriterCache.get(lookupClassInfo).put(directedRelationship, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING")) {
                FieldInfo candidateFieldInfo;
                Set<FieldInfo> candidateRelationshipFields = classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, false);
                for (FieldInfo fieldInfo2 : candidateRelationshipFields) {
                    if (fieldInfo2 == null || fieldInfo2.getAnnotations().isEmpty() || !fieldInfo2.isTypeOf(objectType) && !fieldInfo2.isParameterisedTypeOf(objectType) && !fieldInfo2.isArrayOf(objectType)) continue;
                    relationalWriterCache.get(lookupClassInfo).put(directedRelationship, fieldInfo2);
                    return fieldInfo2;
                }
                for (FieldInfo fieldInfo : candidateRelationshipFields) {
                    if (fieldInfo == null || !fieldInfo.isTypeOf(objectType) && !fieldInfo.isParameterisedTypeOf(objectType) && !fieldInfo.isArrayOf(objectType)) continue;
                    relationalWriterCache.get(lookupClassInfo).put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
                List<FieldInfo> list = classInfo.findFields(objectType);
                if (list.size() == 1 && !(candidateFieldInfo = list.iterator().next()).relationshipDirection("UNDIRECTED").equals("INCOMING")) {
                    relationalWriterCache.get(lookupClassInfo).put(directedRelationship, candidateFieldInfo);
                    return candidateFieldInfo;
                }
            }
            classInfo = classInfo.directSuperclass();
        }
        relationalWriterCache.get(lookupClassInfo).put(directedRelationship, null);
        return null;
    }

    public static FieldInfo getRelationalReader(ClassInfo classInfo, String relationshipType, String relationshipDirection) {
        if (!relationalReaderCache.containsKey(classInfo)) {
            relationalReaderCache.put(classInfo, new HashMap());
        }
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        if (relationalReaderCache.get(classInfo).containsKey(directedRelationship)) {
            return relationalReaderCache.get(classInfo).get(directedRelationship);
        }
        ClassInfo lookupClassInfo = classInfo;
        while (classInfo != null) {
            FieldInfo fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
                relationalReaderCache.get(lookupClassInfo).put(directedRelationship, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING")) {
                fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, false);
                if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
                    relationalReaderCache.get(lookupClassInfo).put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
                if (fieldInfo != null) {
                    relationalReaderCache.get(lookupClassInfo).put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
            }
            classInfo = classInfo.directSuperclass();
        }
        relationalReaderCache.get(lookupClassInfo).put(directedRelationship, null);
        return null;
    }

    public static FieldInfo getIterableField(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection) {
        if (!iterableWriterCache.containsKey(classInfo)) {
            iterableWriterCache.put(classInfo, new HashMap());
        }
        DirectedRelationshipForType directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, parameterType);
        if (iterableWriterCache.get(classInfo).containsKey(directedRelationshipForType)) {
            return iterableWriterCache.get(classInfo).get(directedRelationshipForType);
        }
        ClassInfo lookupClassInfo = classInfo;
        while (classInfo != null) {
            FieldInfo fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
            if (fieldInfo != null) {
                EntityAccessManager.cacheIterableFieldWriter(lookupClassInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && (fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, false)) != null) {
                EntityAccessManager.cacheIterableFieldWriter(lookupClassInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldInfo);
                return fieldInfo;
            }
            classInfo = classInfo.directSuperclass();
        }
        iterableWriterCache.get(lookupClassInfo).put(directedRelationshipForType, null);
        return null;
    }

    private static FieldInfo getIterableFieldInfo(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, boolean strict) {
        List<FieldInfo> fieldInfos = classInfo.findIterableFields(parameterType, relationshipType, relationshipDirection, strict);
        if (fieldInfos.size() == 0 && !strict) {
            fieldInfos = classInfo.findIterableFields(parameterType);
        }
        if (fieldInfos.size() == 1) {
            AnnotationInfo relationshipAnnotation;
            FieldInfo candidateFieldInfo = fieldInfos.iterator().next();
            if (candidateFieldInfo.hasAnnotation(Relationship.class) && !relationshipType.equals((relationshipAnnotation = candidateFieldInfo.getAnnotations().get(Relationship.class)).get("type", null))) {
                return null;
            }
            if (relationshipDirection.equals("INCOMING") && candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") || candidateFieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED")) {
                return candidateFieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && !candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING")) {
                return candidateFieldInfo;
            }
        }
        if (fieldInfos.size() > 0) {
            LOGGER.warn("Cannot map iterable of {} to instance of {}. More than one potential matching field found.", (Object)parameterType, (Object)classInfo.name());
        }
        return null;
    }

    private static void cacheIterableFieldWriter(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, DirectedRelationshipForType directedRelationshipForType, FieldInfo fieldInfo, FieldInfo fieldAccessor) {
        if (fieldInfo.isParameterisedTypeOf(parameterType)) {
            directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, ClassUtils.getType(fieldInfo.getTypeDescriptor()));
        }
        iterableWriterCache.get(classInfo).put(directedRelationshipForType, fieldAccessor);
    }
}

