/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.Objects;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.NodeImpl;
import org.neo4j.ogm.metadata.schema.Relationship;

class RelationshipImpl
implements Relationship {
    private final String type;
    private final String direction;
    private final NodeImpl start;
    private final NodeImpl end;

    public RelationshipImpl(String type, String direction, NodeImpl start, NodeImpl end) {
        this.type = Objects.requireNonNull(type);
        this.direction = Objects.requireNonNull(direction);
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String direction(Node node) {
        if (this.start != node && this.end != node) {
            throw new IllegalArgumentException("Given node " + node + " is neither start or end node of this relationship");
        }
        if (this.start == this.end) {
            return this.direction;
        }
        switch (this.direction) {
            case "UNDIRECTED": {
                return "UNDIRECTED";
            }
            case "OUTGOING": {
                if (this.start == node) {
                    return "OUTGOING";
                }
                return "INCOMING";
            }
            case "INCOMING": {
                if (this.end == node) {
                    return "OUTGOING";
                }
                return "INCOMING";
            }
        }
        throw new IllegalStateException("Unknown direction " + this.direction);
    }

    @Override
    public Node start() {
        return this.start;
    }

    @Override
    public Node other(Node node) {
        if (this.start == node) {
            return this.end;
        }
        if (this.end == node) {
            return this.start;
        }
        throw new IllegalArgumentException("Given node " + node + " is neither start or end node of this relationship");
    }

    public String toString() {
        return "RelationshipImpl{start=" + this.start + ", end=" + this.end + ", type='" + this.type + '\'' + ", direction='" + this.direction + '\'' + '}';
    }
}

