/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;

class DeclaratorHandler
extends Handler<Declaration, IASTNameOwner, CXXLanguageFrontend> {
    DeclaratorHandler(CXXLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(CPPASTDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTArrayDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTFieldDeclarator.class, ctx -> this.handleFieldDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTFunctionDeclarator.class, ctx -> this.handleFunctionDeclarator((CPPASTFunctionDeclarator)ctx));
        this.map.put(CPPASTCompositeTypeSpecifier.class, ctx -> this.handleCompositeTypeSpecifier((CPPASTCompositeTypeSpecifier)ctx));
    }

    private Declaration handleDeclarator(CPPASTDeclarator ctx) {
        if (ctx.getInitializer() == null && ctx.getNestedDeclarator() instanceof CPPASTDeclarator) {
            return (Declaration)this.handle(ctx.getNestedDeclarator());
        }
        String name = ctx.getName().toString();
        if (((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentScope() instanceof RecordScope || name.contains(((CXXLanguageFrontend)this.lang).getNamespaceDelimiter())) {
            return this.handleFieldDeclarator(ctx);
        }
        VariableDeclaration declaration = NodeBuilder.newVariableDeclaration(ctx.getName().toString(), UnknownType.getUnknownType(), ctx.getRawSignature(), true);
        IASTInitializer init = ctx.getInitializer();
        if (init != null) {
            declaration.setInitializer((Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init));
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        return declaration;
    }

    private FieldDeclaration handleFieldDeclarator(CPPASTDeclarator ctx) {
        FieldDeclaration declaration;
        String name;
        IASTInitializer init = ctx.getInitializer();
        Expression initializer = null;
        if (init != null) {
            initializer = (Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init);
        }
        if ((name = ctx.getName().toString()).contains(((CXXLanguageFrontend)this.lang).getNamespaceDelimiter())) {
            String[] rr = name.split(((CXXLanguageFrontend)this.lang).getNamespaceDelimiter());
            String recordName = String.join((CharSequence)((CXXLanguageFrontend)this.lang).getNamespaceDelimiter(), Arrays.asList(rr).subList(0, rr.length - 1));
            String fieldName = rr[rr.length - 1];
            declaration = NodeBuilder.newFieldDeclaration(fieldName, UnknownType.getUnknownType(), Collections.emptyList(), ctx.getRawSignature(), ((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx), initializer, true);
            RecordDeclaration recordDeclaration = ((CXXLanguageFrontend)this.lang).getScopeManager().getRecordForName(((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentScope(), recordName);
        } else {
            declaration = NodeBuilder.newFieldDeclaration(name, UnknownType.getUnknownType(), Collections.emptyList(), ctx.getRawSignature(), ((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx), initializer, true);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        return declaration;
    }

    private MethodDeclaration createMethodOrConstructor(String name, String code, @Nullable RecordDeclaration recordDeclaration) {
        if (name.equals(recordDeclaration != null ? recordDeclaration.getName() : null)) {
            return NodeBuilder.newConstructorDeclaration(name, code, recordDeclaration);
        }
        return NodeBuilder.newMethodDeclaration(name, code, false, recordDeclaration);
    }

    private ValueDeclaration handleFunctionDeclarator(CPPASTFunctionDeclarator ctx) {
        FunctionDeclaration declaration;
        boolean outsideOfRecord;
        IASTDeclarator nameDecl = ctx;
        boolean hasPointer = false;
        while (nameDecl.getNestedDeclarator() != null) {
            if ((nameDecl = nameDecl.getNestedDeclarator()).getPointerOperators().length <= 0) continue;
            hasPointer = true;
        }
        String name = nameDecl.getName().toString();
        if (nameDecl != ctx && hasPointer) {
            return this.handleFunctionPointer(ctx, name);
        }
        if (name.startsWith("operator")) {
            name = name.replace(" ", "");
        }
        RecordDeclaration recordDeclaration = null;
        boolean bl = outsideOfRecord = !(((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentScope() instanceof RecordScope);
        if (name.contains(((CXXLanguageFrontend)this.lang).getNamespaceDelimiter())) {
            String[] rr = name.split(((CXXLanguageFrontend)this.lang).getNamespaceDelimiter());
            ICPPASTParameterDeclaration[] recordName = String.join((CharSequence)((CXXLanguageFrontend)this.lang).getNamespaceDelimiter(), Arrays.asList(rr).subList(0, rr.length - 1));
            String methodName = rr[rr.length - 1];
            recordDeclaration = ((CXXLanguageFrontend)this.lang).getScopeManager().getRecordForName(((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentScope(), (String)recordName);
            declaration = this.createMethodOrConstructor(methodName, ctx.getRawSignature(), recordDeclaration);
        } else if (((CXXLanguageFrontend)this.lang).getScopeManager().isInRecord()) {
            recordDeclaration = ((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
            declaration = this.createMethodOrConstructor(name, ctx.getRawSignature(), recordDeclaration);
        } else {
            declaration = NodeBuilder.newFunctionDeclaration(name, ctx.getRawSignature());
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        if (recordDeclaration != null && outsideOfRecord) {
            ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        int i = 0;
        for (ICPPASTParameterDeclaration param2 : ctx.getParameters()) {
            IBinding binding;
            ParamVariableDeclaration arg = (ParamVariableDeclaration)((CXXLanguageFrontend)this.lang).getParameterDeclarationHandler().handle(param2);
            if (arg.getType() instanceof IncompleteType) {
                if (!arg.getName().isEmpty()) {
                    Util.warnWithFileLocation(declaration, log, "Named parameter cannot have void type", new Object[0]);
                } else {
                    if (i == 0) continue;
                    Util.warnWithFileLocation(declaration, log, "void parameter must be the first and only parameter", new Object[0]);
                }
            }
            if ((binding = ctx.getParameters()[i].getDeclarator().getName().resolveBinding()) != null) {
                ((CXXLanguageFrontend)this.lang).cacheDeclaration(binding, arg);
            }
            arg.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(arg);
            ++i;
        }
        if (ctx.takesVarArgs()) {
            ParamVariableDeclaration varargs2 = NodeBuilder.newMethodParameterIn("va_args", UnknownType.getUnknownType(), true, "");
            varargs2.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(varargs2);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        if (recordDeclaration != null && outsideOfRecord) {
            ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        }
        return declaration;
    }

    private ValueDeclaration handleFunctionPointer(CPPASTFunctionDeclarator ctx, String name) {
        IASTNode parent;
        ValueDeclaration result;
        Expression initializer = ctx.getInitializer() == null ? null : (Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(ctx.getInitializer());
        RecordDeclaration recordDeclaration = ((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
        if (recordDeclaration == null) {
            result = NodeBuilder.newVariableDeclaration(name, UnknownType.getUnknownType(), ctx.getRawSignature(), true);
            result.setInitializer(initializer);
        } else {
            String code = ctx.getRawSignature();
            Pattern namePattern = Pattern.compile("\\((\\*|.+\\*)(?<name>[^)]*)");
            Matcher matcher = namePattern.matcher(code);
            String fieldName = "";
            if (matcher.find()) {
                fieldName = matcher.group("name").strip();
            }
            result = NodeBuilder.newFieldDeclaration(fieldName, UnknownType.getUnknownType(), Collections.emptyList(), code, ((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx), initializer, true);
        }
        for (parent = ctx.getParent(); parent != null && !(parent instanceof CPPASTSimpleDeclaration); parent = parent.getParent()) {
        }
        if (parent != null) {
            result.setType(TypeParser.createFrom(parent.getRawSignature(), true));
            result.refreshType();
        } else {
            log.warn("Could not find suitable parent ast node for function pointer node: {}", (Object)this);
        }
        result.setLocation(((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx));
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(result);
        return result;
    }

    private RecordDeclaration handleCompositeTypeSpecifier(CPPASTCompositeTypeSpecifier ctx) {
        String kind;
        switch (ctx.getKey()) {
            default: {
                kind = "struct";
                break;
            }
            case 2: {
                kind = "union";
                break;
            }
            case 3: {
                kind = "class";
            }
        }
        RecordDeclaration recordDeclaration = NodeBuilder.newRecordDeclaration(((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentNamePrefixWithDelimiter() + ctx.getName().toString(), kind, ctx.getRawSignature());
        recordDeclaration.setSuperClasses(Arrays.stream(ctx.getBaseSpecifiers()).map(b -> TypeParser.createFrom(b.getNameSpecifier().toString(), true)).collect(Collectors.toList()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration);
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration.getThis());
        this.processMembers(ctx);
        if (recordDeclaration.getConstructors().isEmpty()) {
            ConstructorDeclaration constructorDeclaration = NodeBuilder.newConstructorDeclaration(recordDeclaration.getName(), recordDeclaration.getName(), recordDeclaration);
            constructorDeclaration.setImplicit(true);
            constructorDeclaration.setType(TypeParser.createFrom(recordDeclaration.getName(), true));
            recordDeclaration.addConstructor(constructorDeclaration);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addDeclaration(constructorDeclaration);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        return recordDeclaration;
    }

    private void processMembers(CPPASTCompositeTypeSpecifier ctx) {
        for (IASTDeclaration member : ctx.getMembers()) {
            if (member instanceof CPPASTVisibilityLabel) continue;
            ((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(member);
        }
    }
}

