/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface DeclarationHolder {
    public void addDeclaration(@NonNull Declaration var1);

    default public <N extends Declaration> void addIfNotContains(Collection<N> collection, N declaration) {
        if (!collection.contains(declaration)) {
            collection.add(declaration);
        }
    }

    default public <T extends Node> void addIfNotContains(Collection<PropertyEdge<T>> collection, T declaration) {
        this.addIfNotContains(collection, declaration, true);
    }

    default public <T extends Node> void addIfNotContains(Collection<PropertyEdge<T>> collection, T declaration, boolean outgoing) {
        PropertyEdge<T> propertyEdge = outgoing ? new PropertyEdge<T>((Node)((Object)this), declaration) : new PropertyEdge<Node>(declaration, (Node)((Object)this));
        propertyEdge.addProperty(Properties.INDEX, collection.size());
        boolean contains = false;
        for (PropertyEdge<T> element : collection) {
            if (!((Node)element.getEnd()).equals(propertyEdge.getEnd())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            collection.add(propertyEdge);
        }
    }
}

