/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class TranslationUnitDeclaration
extends Declaration
implements DeclarationHolder {
    @Relationship(value="DECLARATIONS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private @NonNull List<PropertyEdge<Declaration>> declarations = new ArrayList<PropertyEdge<Declaration>>();
    @Relationship(value="INCLUDES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private @NonNull List<PropertyEdge<IncludeDeclaration>> includes = new ArrayList<PropertyEdge<IncludeDeclaration>>();
    @Relationship(value="NAMESPACES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private @NonNull List<PropertyEdge<Declaration>> namespaces = new ArrayList<PropertyEdge<Declaration>>();

    public <T extends Declaration> @Nullable T getDeclarationAs(int i, Class<T> clazz) {
        Declaration declaration = this.declarations.get(i).getEnd();
        if (declaration == null) {
            return null;
        }
        return (T)(declaration.getClass().isAssignableFrom(clazz) ? (Declaration)clazz.cast(this.declarations.get(i).getEnd()) : null);
    }

    public <T extends Declaration> @NonNull Set<T> getDeclarationsByName(@NonNull String name, @NonNull Class<T> clazz) {
        return this.declarations.stream().map(PropertyEdge::getEnd).filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).collect(Collectors.toSet());
    }

    public @Nullable IncludeDeclaration getIncludeByName(@NonNull String name) {
        return this.includes.stream().map(PropertyEdge::getEnd).filter(declaration -> Objects.equals(declaration.getName(), name)).findFirst().orElse(null);
    }

    public @NonNull List<Declaration> getDeclarations() {
        return PropertyEdge.unwrap(this.declarations);
    }

    public @NonNull List<PropertyEdge<Declaration>> getDeclarationsPropertyEdge() {
        return this.declarations;
    }

    public @NonNull List<IncludeDeclaration> getIncludes() {
        return PropertyEdge.unwrap(this.includes);
    }

    public @NonNull List<PropertyEdge<IncludeDeclaration>> getIncludesPropertyEdge() {
        return this.includes;
    }

    public @NonNull List<Declaration> getNamespaces() {
        return PropertyEdge.unwrap(this.namespaces);
    }

    public @NonNull List<PropertyEdge<Declaration>> getNamespacesPropertyEdge() {
        return this.namespaces;
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof IncludeDeclaration) {
            this.addIfNotContains(this.includes, (IncludeDeclaration)declaration);
        } else if (declaration instanceof NamespaceDeclaration) {
            this.addIfNotContains(this.namespaces, declaration);
        }
        this.addIfNotContains(this.declarations, declaration);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).append("declarations", this.declarations).append("includes", this.includes).append("namespaces", this.namespaces).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationUnitDeclaration)) {
            return false;
        }
        TranslationUnitDeclaration that = (TranslationUnitDeclaration)o;
        return super.equals(that) && Objects.equals(this.getDeclarations(), that.getDeclarations()) && PropertyEdge.propertyEqualsList(this.declarations, that.declarations) && Objects.equals(this.getIncludes(), that.getIncludes()) && PropertyEdge.propertyEqualsList(this.includes, that.includes) && Objects.equals(this.getNamespaces(), that.getNamespaces()) && PropertyEdge.propertyEqualsList(this.namespaces, that.namespaces);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

