/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class DeclarationStatement
extends Statement {
    @Relationship(value="DECLARATIONS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Declaration>> declarations = new ArrayList<PropertyEdge<Declaration>>();

    public Declaration getSingleDeclaration() {
        return this.isSingleDeclaration() ? this.declarations.get(0).getEnd() : null;
    }

    public boolean isSingleDeclaration() {
        return this.declarations.size() == 1;
    }

    public void setSingleDeclaration(Declaration declaration) {
        this.declarations.clear();
        PropertyEdge<Declaration> propertyEdge = new PropertyEdge<Declaration>(this, declaration);
        propertyEdge.addProperty(Properties.INDEX, 0);
        this.declarations.add(propertyEdge);
    }

    public <T extends Declaration> T getSingleDeclarationAs(Class<T> clazz) {
        return (T)((Declaration)clazz.cast(this.getSingleDeclaration()));
    }

    public @NonNull List<Declaration> getDeclarations() {
        return PropertyEdge.unwrap(this.declarations, true);
    }

    public List<PropertyEdge<Declaration>> getDeclarationsPropertyEdge() {
        return this.declarations;
    }

    public void setDeclarations(List<Declaration> declarations) {
        this.declarations = PropertyEdge.transformIntoOutgoingPropertyEdgeList(declarations, this);
    }

    public void addToPropertyEdgeDeclaration(@NonNull Declaration declaration) {
        PropertyEdge<Declaration> propertyEdge = new PropertyEdge<Declaration>(this, declaration);
        propertyEdge.addProperty(Properties.INDEX, this.declarations.size());
        this.declarations.add(propertyEdge);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("declarations", this.declarations).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclarationStatement)) {
            return false;
        }
        DeclarationStatement that = (DeclarationStatement)o;
        return super.equals(that) && Objects.equals(this.getDeclarations(), that.getDeclarations()) && PropertyEdge.propertyEqualsList(this.declarations, that.declarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

