/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ControlFlowSensitiveDFGPass
extends Pass {
    @Override
    public void cleanup() {
    }

    @Override
    public void accept(TranslationResult translationResult) {
        SubgraphWalker.IterativeGraphWalker walker = new SubgraphWalker.IterativeGraphWalker();
        walker.registerOnNodeVisit(this::handle);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    private void removeValues(FunctionLevelFixpointIterator fixDFGs) {
        for (Node currNode : fixDFGs.getRemoves().keySet()) {
            for (Node prev : fixDFGs.getRemoves().get(currNode)) {
                currNode.removePrevDFG(prev);
            }
        }
    }

    public void handle(Node node) {
        if (node instanceof FunctionDeclaration) {
            FunctionLevelFixpointIterator flfIterator = new FunctionLevelFixpointIterator();
            flfIterator.handle(node);
            this.removeValues(flfIterator);
        }
    }

    private class FunctionLevelFixpointIterator {
        private Map<Node, Set<Node>> removes = new HashMap<Node, Set<Node>>();
        private Map<Node, Map<VariableDeclaration, Set<Node>>> joinPoints = new HashMap<Node, Map<VariableDeclaration, Set<Node>>>();

        private FunctionLevelFixpointIterator() {
        }

        public void handle(Node functionRoot) {
            this.iterateTillFixpoint(functionRoot, new HashMap<VariableDeclaration, Set<Node>>(), null, false);
            this.removes = new HashMap<Node, Set<Node>>();
            this.propagateValues();
        }

        public Map<Node, Set<Node>> getRemoves() {
            return this.removes;
        }

        private void addToRemoves(Node curr, Node prev) {
            if (!this.removes.containsKey(curr)) {
                this.removes.put(curr, new HashSet());
            }
            this.removes.get(curr).add(prev);
        }

        private Set<Node> eogTraversal(Node node) {
            HashSet<Node> eogReachableNodes = new HashSet<Node>();
            HashSet<Node> checkRechable = new HashSet<Node>();
            checkRechable.add(node);
            while (!checkRechable.isEmpty()) {
                Node n = (Node)checkRechable.iterator().next();
                checkRechable.addAll(n.getNextEOG());
                eogReachableNodes.add(n);
                checkRechable.removeAll(eogReachableNodes);
            }
            return eogReachableNodes;
        }

        private void setIngoingDFG(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            HashSet<Node> prevDFGs = new HashSet<Node>(currNode.getPrevDFG());
            for (Node prev : prevDFGs) {
                if (!(prev instanceof VariableDeclaration) || !variables.containsKey(prev)) continue;
                for (Node target : variables.get(prev)) {
                    currNode.addPrevDFG(target);
                }
                this.addToRemoves(currNode, prev);
            }
        }

        private void registerOutgoingDFG(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            HashSet<Node> nextDFG = new HashSet<Node>(currNode.getNextDFG());
            for (Node next : nextDFG) {
                if (!(next instanceof VariableDeclaration) || !variables.containsKey(next)) continue;
                HashSet<Node> values2 = new HashSet<Node>(currNode.getPrevDFG());
                variables.replace((VariableDeclaration)next, values2);
            }
        }

        private Node obtainAssignmentNode(Node node) {
            HashSet<Node> nextEOG = new HashSet<Node>(node.getNextEOG());
            HashSet<Node> rechableEOGs = new HashSet<Node>();
            for (Node next : nextEOG) {
                rechableEOGs.addAll(this.eogTraversal(next));
            }
            return rechableEOGs.stream().filter(n -> n instanceof BinaryOperator && ((BinaryOperator)n).getLhs().equals(node)).findAny().orElse(null);
        }

        private void modifyDFGEdges(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            this.registerOutgoingDFG(currNode, variables);
            this.setIngoingDFG(currNode, variables);
        }

        public Map<VariableDeclaration, Set<Node>> iterateTillFixpoint(Node node, Map<VariableDeclaration, Set<Node>> variables, Node endNode, boolean stopBefore) {
            Node next;
            if (node == null) {
                return variables;
            }
            do {
                if (node.getPrevEOG().size() != 1) {
                    if (!this.joinPoints.containsKey(node)) {
                        this.joinPoints.put(node, this.createShallowCopy(variables));
                    } else {
                        Map<VariableDeclaration, Set<Node>> currentJoinpoint = this.joinPoints.get(node);
                        if (!this.mergeStates(currentJoinpoint, variables)) {
                            return currentJoinpoint;
                        }
                        variables = this.createShallowCopy(currentJoinpoint);
                    }
                }
                if (node.equals(endNode) && stopBefore) {
                    return variables;
                }
                if (node instanceof DeclaredReferenceExpression) {
                    node = this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node, variables, this::iterateTillFixpoint);
                }
                if (node.equals(endNode) && !stopBefore) {
                    return variables;
                }
                if (node.getNextEOG().size() > 1) {
                    HashMap<VariableDeclaration, Set<Node>> updatedVariables = new HashMap<VariableDeclaration, Set<Node>>();
                    for (Node next2 : node.getNextEOG()) {
                        if (next2 instanceof VariableDeclaration) {
                            this.addDFGToMap((VariableDeclaration)next2, node, variables);
                        }
                        this.mergeStates(updatedVariables, this.iterateTillFixpoint(next2, this.createShallowCopy(variables), endNode, stopBefore));
                    }
                    return updatedVariables;
                }
                if (node.getNextEOG().isEmpty()) {
                    return variables;
                }
                next = node.getNextEOG().get(0);
                if (!(next instanceof VariableDeclaration)) continue;
                this.addDFGToMap((VariableDeclaration)next, node, variables);
            } while ((node = next) != null);
            return variables;
        }

        private Node handleDeclaredReferenceExpression(DeclaredReferenceExpression currNode, Map<VariableDeclaration, Set<Node>> variables, IterationFunction iterationFunction) {
            Node binaryOperator;
            if (currNode.getAccess().equals((Object)AccessValues.WRITE) && (binaryOperator = this.obtainAssignmentNode(currNode)) != null) {
                Node nextEOG = currNode.getNextEOG().get(0);
                Map<VariableDeclaration, Set<Node>> updatedVariables = iterationFunction.iterate(nextEOG, this.createShallowCopy(variables), binaryOperator, false);
                variables.clear();
                variables.putAll(updatedVariables);
                this.modifyDFGEdges(currNode, variables);
                return binaryOperator;
            }
            this.modifyDFGEdges(currNode, variables);
            return currNode;
        }

        public void propagateValues() {
            for (Map.Entry<Node, Map<VariableDeclaration, Set<Node>>> joinPoint : this.joinPoints.entrySet()) {
                this.propagateFromJoinPoints(joinPoint.getKey(), joinPoint.getValue(), null, true);
            }
        }

        public Map<VariableDeclaration, Set<Node>> propagateFromJoinPoints(Node node, Map<VariableDeclaration, Set<Node>> variables, Node endNode, boolean stopBefore) {
            Node next;
            if (node == null) {
                return variables;
            }
            do {
                if (node.equals(endNode) && stopBefore) {
                    return variables;
                }
                if (node instanceof DeclaredReferenceExpression) {
                    node = this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node, variables, this::propagateFromJoinPoints);
                }
                if (node.equals(endNode) && !stopBefore) {
                    return variables;
                }
                if (node.getNextEOG().size() > 1) {
                    HashMap<VariableDeclaration, Set<Node>> updatedVariables = new HashMap<VariableDeclaration, Set<Node>>();
                    for (Node next2 : node.getNextEOG()) {
                        if (next2 instanceof VariableDeclaration) {
                            this.addDFGToMap((VariableDeclaration)next2, node, variables);
                        }
                        if (this.joinPoints.containsKey(next2)) continue;
                        this.mergeStates(updatedVariables, this.iterateTillFixpoint(next2, this.createShallowCopy(variables), endNode, stopBefore));
                    }
                    return updatedVariables;
                }
                if (node.getNextEOG().isEmpty()) {
                    return variables;
                }
                next = node.getNextEOG().get(0);
                if (!(next instanceof VariableDeclaration)) continue;
                this.addDFGToMap((VariableDeclaration)next, node, variables);
            } while (!this.joinPoints.containsKey(node = next) && !node.getNextEOG().isEmpty());
            return variables;
        }

        private void addDFGToMap(VariableDeclaration variableDeclaration, Node prev, Map<VariableDeclaration, Set<Node>> variables) {
            Set<Node> prevDFGSet = variableDeclaration.getPrevDFG();
            if (prevDFGSet.contains(prev)) {
                if (variables.containsKey(variableDeclaration)) {
                    variables.get(variableDeclaration).add(prev);
                } else {
                    HashSet<Node> dfgSet = new HashSet<Node>();
                    dfgSet.add(prev);
                    variables.put(variableDeclaration, dfgSet);
                }
            }
        }

        public boolean mergeStates(Map<VariableDeclaration, Set<Node>> currentJoinpoint, Map<VariableDeclaration, Set<Node>> variables) {
            boolean changed = false;
            for (Map.Entry<VariableDeclaration, Set<Node>> entry : variables.entrySet()) {
                Set<Node> newAssignments = entry.getValue();
                if (currentJoinpoint.containsKey(entry.getKey())) {
                    Set<Node> existing = currentJoinpoint.get(entry.getKey());
                    for (Node assignment : newAssignments) {
                        if (existing.contains(assignment)) continue;
                        existing.add(assignment);
                        changed = true;
                    }
                    continue;
                }
                currentJoinpoint.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
                changed = true;
            }
            return changed;
        }

        public Map<VariableDeclaration, Set<Node>> createShallowCopy(Map<VariableDeclaration, Set<Node>> state) {
            LinkedHashMap<VariableDeclaration, Set<Node>> shallowCopy = new LinkedHashMap<VariableDeclaration, Set<Node>>();
            for (Map.Entry<VariableDeclaration, Set<Node>> entry : state.entrySet()) {
                shallowCopy.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
            }
            return shallowCopy;
        }
    }

    private static interface IterationFunction {
        public Map<VariableDeclaration, Set<Node>> iterate(Node var1, Map<VariableDeclaration, Set<Node>> var2, Node var3, boolean var4);
    }
}

