/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.processing.strategy;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class Strategy {
    private Strategy() {
    }

    public static @NonNull Iterator<Node> NO_STRATEGY(@NonNull Node x) {
        return Collections.emptyIterator();
    }

    public static @NonNull Iterator<Node> EOG_FORWARD(@NonNull Node x) {
        return x.getNextEOG().iterator();
    }

    public static @NonNull Iterator<Node> EOG_BACKWARD(@NonNull Node x) {
        return x.getPrevEOG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_FORWARD(@NonNull Node x) {
        return x.getNextDFG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_BACKWARD(@NonNull Node x) {
        return x.getPrevDFG().iterator();
    }

    private static Object handlePropertyEdges(Field field2, Object obj) {
        boolean outgoing = true;
        if (field2.getAnnotation(Relationship.class) != null) {
            outgoing = field2.getAnnotation(Relationship.class).direction().equals("OUTGOING");
        }
        if (PropertyEdge.checkForPropertyEdge(field2, obj)) {
            return PropertyEdge.unwrapPropertyEdge(obj, outgoing);
        }
        return obj;
    }

    public static @NonNull Iterator<Node> AST_FORWARD(@NonNull Node x) {
        HashSet<Node> children = new HashSet<Node>();
        Class<?> classType = x.getClass();
        for (Field field2 : Strategy.getAllFields(classType)) {
            SubGraph subGraph = field2.getAnnotation(SubGraph.class);
            if (subGraph == null || !Arrays.asList(subGraph.value()).contains("AST")) continue;
            try {
                field2.setAccessible(true);
                Object obj = field2.get(x);
                field2.setAccessible(false);
                if (obj == null) continue;
                if ((obj = Strategy.handlePropertyEdges(field2, obj)) instanceof Node) {
                    children.add((Node)obj);
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                Collection astChildren = (Collection)obj;
                astChildren.removeIf(Objects::isNull);
                children.addAll(astChildren);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return children.iterator();
    }

    private static Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            Collection<Field> fields = Strategy.getAllFields(classType.getSuperclass());
            fields.addAll(Arrays.asList(classType.getDeclaredFields()));
            return fields;
        }
        return new ArrayList<Field>();
    }
}

