/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.node;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.builders.node.AbstractPropertyContainerBuilder;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.PropertyModel;

public class DefaultNodeBuilder
extends AbstractPropertyContainerBuilder<NodeBuilder, NodeModel>
implements NodeBuilder {
    public DefaultNodeBuilder(Long reference) {
        super(new NodeModel(reference));
    }

    @Override
    public NodeBuilder addProperty(String key, Object value) {
        List<Property<String, Object>> propertyList = ((NodeModel)this.targetContainer).getPropertyList();
        for (Property<String, Object> property : propertyList) {
            if (!property.getKey().equals(key)) continue;
            throw new MappingException("Node model already contains property: " + key);
        }
        propertyList.add(new PropertyModel<String, Object>(key, value));
        return this;
    }

    @Override
    public NodeBuilder addLabels(Collection<String> newLabels) {
        String[] labels = newLabels.toArray(new String[newLabels.size()]);
        ((NodeModel)this.targetContainer).setLabels(labels);
        return this;
    }

    @Override
    public Long reference() {
        return ((NodeModel)this.targetContainer).getId();
    }

    @Override
    public NodeBuilder setPreviousDynamicLabels(Set<String> previousDynamicLabels) {
        ((NodeModel)this.targetContainer).setPreviousDynamicLabels(previousDynamicLabels);
        return this;
    }

    @Override
    public Node node() {
        return (Node)this.targetContainer;
    }

    @Override
    public NodeBuilder setPrimaryIndex(String primaryIndexField) {
        ((NodeModel)this.targetContainer).setPrimaryIndex(primaryIndexField);
        return this;
    }

    @Override
    public NodeBuilder setVersionProperty(String name, Long version) {
        ((NodeModel)this.targetContainer).setVersion(new PropertyModel<String, Long>(name, version));
        return this;
    }
}

