/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import org.neo4j.ogm.cypher.query.SortOrder;

public class SortClause {
    private final SortOrder.Direction direction;
    private final String[] properties;

    SortClause(SortOrder.Direction direction, String ... properties) {
        this.direction = direction;
        this.properties = properties;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public SortClause fromResolvedProperties(String ... resolvedProperties) {
        if (resolvedProperties.length != this.properties.length) {
            throw new IllegalArgumentException("Resolved properties count must match existing properties count.");
        }
        return new SortClause(this.direction, resolvedProperties);
    }

    String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.properties.length > 0) {
            for (String n : this.properties) {
                sb.append("$.").append(n);
                if (this.direction == SortOrder.Direction.DESC) {
                    sb.append(" DESC");
                }
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

