/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.metadata.MethodInfo;

public class MethodsInfo {
    private final Set<MethodInfo> methods = new HashSet<MethodInfo>();

    MethodsInfo(Class<?> cls, Field delegateHolder) {
        Class<?> currentClass = cls;
        do {
            Set methodInfoOfCurrentClass = Arrays.stream(currentClass.getDeclaredMethods()).filter(MethodsInfo::includeMethod).map(method -> MethodInfo.of(method, delegateHolder)).collect(Collectors.toSet());
            this.methods.addAll(methodInfoOfCurrentClass);
        } while ((currentClass = currentClass.getSuperclass()) != null);
    }

    Collection<MethodInfo> findMethodInfoBy(Predicate<MethodInfo> predicate2) {
        return this.methods.stream().filter(predicate2).collect(Collectors.toList());
    }

    public void append(MethodsInfo methodsInfo) {
        this.methods.addAll(methodsInfo.methods);
    }

    private static boolean includeMethod(Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers);
    }
}

