/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.WriteProtectionTarget;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.LoadStrategy;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.WriteProtectionStrategy;
import org.neo4j.ogm.session.delegates.DeleteDelegate;
import org.neo4j.ogm.session.delegates.ExecuteQueriesDelegate;
import org.neo4j.ogm.session.delegates.GraphIdDelegate;
import org.neo4j.ogm.session.delegates.LoadByIdsDelegate;
import org.neo4j.ogm.session.delegates.LoadByInstancesDelegate;
import org.neo4j.ogm.session.delegates.LoadByTypeDelegate;
import org.neo4j.ogm.session.delegates.LoadOneDelegate;
import org.neo4j.ogm.session.delegates.SaveDelegate;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.request.OptimisticLockingChecker;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.NodeQueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.PathNodeLoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.PathRelationshipLoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipQueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.SchemaNodeLoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.SchemaRelationshipLoadClauseBuilder;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.session.transaction.support.TransactionalUnitOfWork;
import org.neo4j.ogm.session.transaction.support.TransactionalUnitOfWorkWithoutResult;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jSession
implements Session {
    private final Logger logger = LoggerFactory.getLogger(Neo4jSession.class);
    private final MetaData metaData;
    private final MappingContext mappingContext;
    private final DefaultTransactionManager txManager;
    private final LoadOneDelegate loadOneHandler = new LoadOneDelegate(this);
    private final LoadByTypeDelegate loadByTypeHandler = new LoadByTypeDelegate(this);
    private final LoadByIdsDelegate loadByIdsHandler = new LoadByIdsDelegate(this);
    private final LoadByInstancesDelegate loadByInstancesDelegate = new LoadByInstancesDelegate(this);
    private final SaveDelegate saveDelegate = new SaveDelegate(this);
    private final DeleteDelegate deleteDelegate = new DeleteDelegate(this);
    private final ExecuteQueriesDelegate executeQueriesDelegate = new ExecuteQueriesDelegate(this);
    private final GraphIdDelegate graphIdDelegate = new GraphIdDelegate(this);
    private LoadStrategy loadStrategy;
    private EntityInstantiator entityInstantiator;
    private Driver driver;
    private String bookmark;
    private List<EventListener> registeredEventListeners = new LinkedList<EventListener>();
    private final boolean useStrictQuerying;

    public Neo4jSession(MetaData metaData, boolean useStrictQuerying, Driver driver) {
        this.metaData = metaData;
        this.useStrictQuerying = useStrictQuerying;
        this.driver = driver;
        this.mappingContext = new MappingContext(metaData);
        this.txManager = new DefaultTransactionManager(this, driver.getTransactionFactorySupplier());
        this.loadStrategy = LoadStrategy.PATH_LOAD_STRATEGY;
        this.entityInstantiator = new ReflectionEntityInstantiator(metaData);
    }

    public Neo4jSession(MetaData metaData, boolean useStrictQuerying, Driver driver, List<EventListener> eventListeners, LoadStrategy loadStrategy, EntityInstantiator entityInstantiator) {
        this(metaData, useStrictQuerying, driver);
        this.registeredEventListeners.addAll(eventListeners);
        this.loadStrategy = loadStrategy;
        this.entityInstantiator = entityInstantiator;
    }

    @Override
    public EventListener register(EventListener eventListener) {
        this.registeredEventListeners.add(eventListener);
        return eventListener;
    }

    @Override
    public void notifyListeners(Event event) {
        block6: for (EventListener eventListener : this.registeredEventListeners) {
            switch (event.getLifeCycle()) {
                case PRE_SAVE: {
                    eventListener.onPreSave(event);
                    continue block6;
                }
                case POST_SAVE: {
                    eventListener.onPostSave(event);
                    continue block6;
                }
                case PRE_DELETE: {
                    eventListener.onPreDelete(event);
                    continue block6;
                }
                case POST_DELETE: {
                    eventListener.onPostDelete(event);
                    continue block6;
                }
            }
            this.logger.warn("Event not recognised: {}", (Object)event);
        }
    }

    @Override
    public boolean eventsEnabled() {
        return this.registeredEventListeners.size() > 0;
    }

    @Override
    public boolean dispose(EventListener eventListener) {
        for (EventListener next : this.registeredEventListeners) {
            if (eventListener != next) continue;
            this.registeredEventListeners.remove(eventListener);
            return true;
        }
        return false;
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id) {
        return this.loadOneHandler.load(type, id);
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id, int depth) {
        return this.loadOneHandler.load(type, id, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadByTypeHandler.loadAll(type);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadByTypeHandler.loadAll(type, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadByTypeHandler.loadAll(type, paging);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadByTypeHandler.loadAll(type, paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadByTypeHandler.loadAll(type, filter);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadByTypeHandler.loadAll(type, filters);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids) {
        return this.loadByIdsHandler.loadAll(type, ids);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging) {
        return this.loadByIdsHandler.loadAll(type, ids, paging);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, paging, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.loadByInstancesDelegate.loadAll(objects, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination, depth);
    }

    @Override
    public <T> T queryForObject(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.queryForObject(type, cypher, parameters);
    }

    @Override
    public <T> Iterable<T> query(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.query(type, cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.query(cypher, parameters, false);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        return this.executeQueriesDelegate.query(cypher, parameters, readOnly);
    }

    @Override
    public long countEntitiesOfType(Class<?> entity) {
        return this.executeQueriesDelegate.countEntitiesOfType(entity);
    }

    @Override
    public long count(Class<?> clazz, Iterable<Filter> filters) {
        return this.executeQueriesDelegate.count(clazz, filters);
    }

    @Override
    public void purgeDatabase() {
        this.deleteDelegate.purgeDatabase();
    }

    @Override
    public <T> void delete(T object) {
        this.deleteDelegate.delete(object);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        this.deleteDelegate.deleteAll(type);
    }

    @Override
    public <T> Object delete(Class<T> type, Iterable<Filter> filters, boolean listResults) {
        return this.deleteDelegate.delete(type, filters, listResults);
    }

    @Override
    public <T> void save(T object) {
        this.saveDelegate.save(object);
    }

    @Override
    public <T> void save(T object, int depth) {
        this.saveDelegate.save(object, depth);
    }

    public void addWriteProtection(WriteProtectionTarget target, Predicate<Object> protection) {
        this.saveDelegate.addWriteProtection(target, protection);
    }

    public void removeWriteProtection(WriteProtectionTarget target) {
        this.saveDelegate.removeWriteProtection(target);
    }

    public void setWriteProtectionStrategy(WriteProtectionStrategy writeProtectionStrategy) {
        this.saveDelegate.setWriteProtectionStrategy(writeProtectionStrategy);
    }

    @Override
    public Transaction beginTransaction() {
        return this.txManager.openTransaction();
    }

    @Override
    public Transaction beginTransaction(Transaction.Type type) {
        return this.txManager.openTransaction(type, Collections.emptySet());
    }

    @Override
    public Transaction beginTransaction(Transaction.Type type, Iterable<String> bookmarks) {
        return this.txManager.openTransaction(type, bookmarks);
    }

    public void doInTransaction(TransactionalUnitOfWorkWithoutResult function, Transaction.Type txType) {
        this.doInTransaction(() -> {
            function.doInTransaction();
            return null;
        }, txType);
    }

    public void doInTransaction(TransactionalUnitOfWorkWithoutResult function, boolean forceTx, Transaction.Type txType) {
        this.doInTransaction(() -> {
            function.doInTransaction();
            return null;
        }, forceTx, txType);
    }

    public <T> T doInTransaction(TransactionalUnitOfWork<T> function, Transaction.Type txType) {
        return this.doInTransaction(function, false, txType);
    }

    public <T> T doInTransaction(TransactionalUnitOfWork<T> function, boolean forceTx, Transaction.Type txType) {
        Transaction transaction = this.txManager.getCurrentTransaction();
        boolean newTransaction = false;
        try {
            if (forceTx || this.driver.requiresTransaction() && transaction == null) {
                transaction = this.beginTransaction(txType);
                newTransaction = true;
            }
            T result = function.doInTransaction();
            if (newTransaction && this.txManager.canCommit()) {
                transaction.commit();
            }
            T t = result;
            return t;
        }
        catch (CypherException e) {
            if (newTransaction && this.txManager.canRollback()) {
                this.logger.warn("Error executing query : {} - {}. Rolling back transaction.", (Object)e.getCode(), (Object)e.getDescription());
                transaction.rollback();
            }
            throw e;
        }
        catch (Throwable e) {
            if (newTransaction && this.txManager.canRollback()) {
                this.logger.warn("Error executing query : {}. Rolling back transaction.", (Object)e.getMessage());
                transaction.rollback();
            }
            throw this.driver.getExceptionTranslator().translateExceptionIfPossible(e);
        }
        finally {
            if (newTransaction && transaction != null && !transaction.status().equals((Object)Transaction.Status.CLOSED)) {
                transaction.close();
            }
        }
    }

    @Override
    public Transaction getTransaction() {
        return this.txManager.getCurrentTransaction();
    }

    @Override
    public Long resolveGraphIdFor(Object possibleEntity) {
        return this.graphIdDelegate.resolveGraphIdFor(possibleEntity);
    }

    @Override
    public boolean detachNodeEntity(Long id) {
        return this.graphIdDelegate.detachNodeEntity(id);
    }

    @Override
    public boolean detachRelationshipEntity(Long id) {
        return this.graphIdDelegate.detachRelationshipEntity(id);
    }

    public <T, ID extends Serializable> QueryStatements<ID> queryStatementsFor(Class<T> type, int depth) {
        String primaryIdName;
        FieldInfo fieldInfo = this.metaData.classInfo(type.getName()).primaryIndexField();
        String string = primaryIdName = fieldInfo != null ? fieldInfo.property() : null;
        if (this.metaData.isRelationshipEntity(type.getName())) {
            return new RelationshipQueryStatements(primaryIdName, this.loadRelationshipClauseBuilder(depth));
        }
        return new NodeQueryStatements(primaryIdName, this.loadNodeClauseBuilder(depth));
    }

    public Optional<String> determineLabelsOrTypeForLoading(Class<?> type) {
        Optional<String> labelsOrType;
        if (this.useStrictQuerying) {
            ClassInfo classInfo = this.metaData().classInfo(type);
            String result = null;
            if (classInfo != null) {
                result = classInfo.isRelationshipEntity() ? classInfo.neo4jName() : String.join((CharSequence)"`:`", classInfo.staticLabels());
            }
            labelsOrType = Optional.ofNullable(result);
        } else {
            labelsOrType = Optional.ofNullable(this.metaData.entityType(type.getName()));
        }
        return labelsOrType.map(String::trim).filter(s2 -> !s2.isEmpty());
    }

    public MappingContext context() {
        return this.mappingContext;
    }

    public OptimisticLockingChecker optimisticLockingChecker() {
        return new OptimisticLockingChecker(this);
    }

    public MetaData metaData() {
        return this.metaData;
    }

    @Override
    public void clear() {
        this.mappingContext.clear();
    }

    public Request requestHandler() {
        return this.driver.request(this.txManager.getCurrentTransaction());
    }

    public void warn(String msg) {
        this.logger.warn("Thread {}: {}", (Object)Thread.currentThread().getId(), (Object)msg);
    }

    @Override
    public String getLastBookmark() {
        return this.bookmark;
    }

    @Override
    public void withBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public EntityInstantiator getEntityInstantiator() {
        return this.entityInstantiator;
    }

    @Override
    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    private LoadClauseBuilder loadNodeClauseBuilder(int depth) {
        if (depth < 0) {
            return new PathNodeLoadClauseBuilder();
        }
        switch (this.loadStrategy) {
            case PATH_LOAD_STRATEGY: {
                return new PathNodeLoadClauseBuilder();
            }
            case SCHEMA_LOAD_STRATEGY: {
                return new SchemaNodeLoadClauseBuilder(this.metaData.getSchema());
            }
        }
        throw new IllegalStateException("Unknown loadStrategy " + (Object)((Object)this.loadStrategy));
    }

    private LoadClauseBuilder loadRelationshipClauseBuilder(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Can't load unlimited depth for relationships");
        }
        switch (this.loadStrategy) {
            case PATH_LOAD_STRATEGY: {
                return new PathRelationshipLoadClauseBuilder();
            }
            case SCHEMA_LOAD_STRATEGY: {
                return new SchemaRelationshipLoadClauseBuilder(this.metaData.getSchema());
            }
        }
        throw new IllegalStateException("Unknown loadStrategy " + (Object)((Object)this.loadStrategy));
    }
}

