/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.SessionDelegate;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.PersistenceEvent;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.NodeDeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipDeleteStatements;
import org.neo4j.ogm.transaction.Transaction;

public class DeleteDelegate
extends SessionDelegate {
    public DeleteDelegate(Neo4jSession session) {
        super(session);
    }

    public <T> void delete(T object) {
        List<T> objectsForDeletion = this.createObjectsCollectionFromObject(object);
        this.delete(objectsForDeletion);
    }

    public <T> void deleteAll(Class<T> type) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo != null) {
            String entityLabel = classInfo.neo4jName();
            if (entityLabel == null) {
                this.session.warn("Unable to find database label for entity " + type.getName() + " : no results will be returned. Make sure the class is registered, and not abstract without @NodeEntity annotation");
                return;
            }
            CypherQuery request = this.getDeleteStatementsBasedOnType(type).delete(entityLabel);
            DefaultRowModelRequest query = new DefaultRowModelRequest(request.getStatement(), request.getParameters());
            this.session.notifyListeners(new PersistenceEvent(type, Event.TYPE.PRE_DELETE));
            this.session.doInTransaction(() -> {
                try (Response<RowModel> response = this.session.requestHandler().execute(query);){
                    this.session.context().removeType(type);
                    if (this.session.eventsEnabled()) {
                        this.session.notifyListeners(new PersistenceEvent(type, Event.TYPE.POST_DELETE));
                    }
                }
            }, Transaction.Type.READ_WRITE);
        } else {
            this.session.warn(type.getName() + " is not a persistable class");
        }
    }

    public <T> Object delete(Class<T> clazz, Iterable<Filter> filters, boolean listResults) {
        ClassInfo classInfo = this.session.metaData().classInfo(clazz.getSimpleName());
        if (classInfo != null) {
            this.resolvePropertyAnnotations(clazz, filters);
            CypherQuery query = classInfo.isRelationshipEntity() ? new RelationshipDeleteStatements().deleteAndList(classInfo.neo4jName(), filters) : new NodeDeleteStatements().deleteAndList(classInfo.neo4jName(), filters);
            if (listResults) {
                return this.list(query, classInfo.isRelationshipEntity());
            }
            return this.count(query, classInfo.isRelationshipEntity());
        }
        throw new RuntimeException(clazz.getName() + " is not a persistable class");
    }

    public void purgeDatabase() {
        CypherQuery stmt = new NodeDeleteStatements().deleteAll();
        DefaultRowModelRequest query = new DefaultRowModelRequest(stmt.getStatement(), stmt.getParameters());
        this.session.doInTransaction(() -> this.session.requestHandler().execute(query).close(), Transaction.Type.READ_WRITE);
        this.session.context().clear();
    }

    public void clear() {
        this.session.context().clear();
    }

    private <T> List<T> createObjectsCollectionFromObject(T object) {
        List<Object> objectCollection;
        if (object.getClass().isArray()) {
            Object[] objectsAsArray = (Object[])object;
            objectCollection = Arrays.asList(objectsAsArray);
        } else if (Iterable.class.isAssignableFrom(object.getClass())) {
            objectCollection = new ArrayList<Object>();
            ((Iterable)object).forEach(objectCollection::add);
        } else {
            objectCollection = Collections.singletonList(object);
        }
        return objectCollection;
    }

    private <T> void delete(List<T> objectsForDeletion) {
        if (objectsForDeletion.isEmpty()) {
            return;
        }
        HashSet<Object> allNeighbours = new HashSet<Object>();
        for (T element : objectsForDeletion) {
            allNeighbours.addAll(this.session.context().neighbours(element));
        }
        this.deleteOneOrMoreObjects(objectsForDeletion, allNeighbours);
    }

    private void deleteOneOrMoreObjects(List<?> objects, Set<Object> neighbours) {
        HashSet<Object> notified = new HashSet<Object>();
        if (this.session.eventsEnabled()) {
            for (Object affectedObject : neighbours) {
                if (notified.contains(affectedObject)) continue;
                this.session.notifyListeners(new PersistenceEvent(affectedObject, Event.TYPE.PRE_SAVE));
                notified.add(affectedObject);
            }
        }
        for (Object object : objects) {
            MetaData metaData = this.session.metaData();
            ClassInfo classInfo = metaData.classInfo(object);
            if (classInfo == null) {
                this.session.warn(object.getClass().getName() + " is not an instance of a persistable class");
                continue;
            }
            MappingContext mappingContext = this.session.context();
            Long id = mappingContext.optionalNativeId(object).filter(possibleId -> possibleId >= 0L).orElseGet(() -> {
                this.session.warn(String.format("Instance of class %s has to be reloaded to be deleted. This can happen if the session has been cleared between loading and deleting or using an object from a different transaction.", object.getClass()));
                return classInfo.getPrimaryIndexOrIdReader().apply(object).map(primaryIndexOrId -> this.session.load(object.getClass(), (Serializable)primaryIndexOrId)).flatMap(reloadedObject -> mappingContext.optionalNativeId(reloadedObject)).orElse(-1L);
            });
            if (id < 0L) continue;
            Statement request = this.getDeleteStatement(object, id, classInfo);
            if (this.session.eventsEnabled() && !notified.contains(object)) {
                this.session.notifyListeners(new PersistenceEvent(object, Event.TYPE.PRE_DELETE));
                notified.add(object);
            }
            DefaultRowModelRequest query = new DefaultRowModelRequest(request.getStatement(), request.getParameters());
            this.session.doInTransaction(() -> {
                try (Response<RowModel> response = this.session.requestHandler().execute(query);){
                    if (request.optimisticLockingConfig().isPresent()) {
                        List<RowModel> rowModels = response.toList();
                        this.session.optimisticLockingChecker().checkResultsCount(rowModels, request);
                    }
                    if (metaData.isRelationshipEntity(classInfo.name())) {
                        this.session.detachRelationshipEntity(id);
                    } else {
                        this.session.detachNodeEntity(id);
                    }
                    if (notified.contains(object)) {
                        this.session.notifyListeners(new PersistenceEvent(object, Event.TYPE.POST_DELETE));
                    }
                }
            }, Transaction.Type.READ_WRITE);
        }
        if (this.session.eventsEnabled()) {
            for (Object affectedObject : neighbours) {
                if (!notified.contains(affectedObject)) continue;
                this.session.notifyListeners(new PersistenceEvent(affectedObject, Event.TYPE.POST_SAVE));
            }
        }
    }

    private DeleteStatements getDeleteStatementsBasedOnType(Class type) {
        if (this.session.metaData().isRelationshipEntity(type.getName())) {
            return new RelationshipDeleteStatements();
        }
        return new NodeDeleteStatements();
    }

    private Statement getDeleteStatement(Object object, Long identity, ClassInfo classInfo) {
        DeleteStatements deleteStatements = this.getDeleteStatementsBasedOnType(object.getClass());
        CypherQuery request = classInfo.hasVersionField() ? deleteStatements.delete(identity, object, classInfo) : deleteStatements.delete(identity);
        return request;
    }

    private List<Long> list(CypherQuery query, boolean isRelationshipEntity) {
        String resultKey = isRelationshipEntity ? "ID(r0)" : "ID(n)";
        Result result = this.session.query(query.getStatement(), query.getParameters());
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map resultEntry : result) {
            Long deletedObjectId = Long.parseLong(resultEntry.get(resultKey).toString());
            this.postDelete(deletedObjectId, isRelationshipEntity);
            ids.add(deletedObjectId);
        }
        return ids;
    }

    private Long count(CypherQuery query, boolean isRelationshipEntity) {
        String resultKey = isRelationshipEntity ? "ID(r0)" : "ID(n)";
        Result result = this.session.query(query.getStatement(), query.getParameters());
        long count = 0L;
        for (Map resultEntry : result) {
            Long deletedObjectId = Long.parseLong(resultEntry.get(resultKey).toString());
            this.postDelete(deletedObjectId, isRelationshipEntity);
            ++count;
        }
        return count;
    }

    private void postDelete(Long identity, boolean isRelationshipEntity) {
        Object object;
        if (isRelationshipEntity) {
            object = this.session.context().getRelationshipEntity(identity);
            if (object != null) {
                this.session.detachRelationshipEntity(identity);
            }
        } else {
            object = this.session.context().getNodeEntity(identity);
            if (object != null) {
                this.session.detachNodeEntity(identity);
            }
        }
        if (this.session.eventsEnabled() && object != null) {
            this.session.notifyListeners(new PersistenceEvent(object, Event.TYPE.POST_DELETE));
        }
    }
}

