/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class EnumCollectionStringConverter
implements AttributeConverter<Collection<Enum>, String[]> {
    private final Class<? extends Enum> enumClass;
    private final Class<? extends Collection> collectionClass;

    public EnumCollectionStringConverter(Class<? extends Enum> enumClass, Class<? extends Collection> collectionClass) {
        this.enumClass = enumClass;
        this.collectionClass = collectionClass;
    }

    @Override
    public String[] toGraphProperty(Collection<Enum> value) {
        if (value == null) {
            return null;
        }
        String[] values2 = new String[value.size()];
        int i = 0;
        for (Enum e : value) {
            values2[i++] = e.name();
        }
        return values2;
    }

    @Override
    public Collection<Enum> toEntityAttribute(String[] stringValues) {
        ArrayList<Enum> values2;
        if (stringValues == null) {
            return null;
        }
        if (List.class.isAssignableFrom(this.collectionClass)) {
            values2 = new ArrayList(stringValues.length);
        } else if (Vector.class.isAssignableFrom(this.collectionClass)) {
            values2 = new Vector(stringValues.length);
        } else if (Set.class.isAssignableFrom(this.collectionClass)) {
            values2 = new HashSet(stringValues.length);
        } else {
            return null;
        }
        for (String value : stringValues) {
            values2.add(Enum.valueOf(this.enumClass, value));
        }
        return values2;
    }
}

