/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.java;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.java.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.java.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.java.StatementAnalyzer;
import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.AnnotationMember;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.CommonPath;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JavaLanguageFrontend
extends LanguageFrontend {
    public static final String THIS = "this";
    public static final String ANNOTATION_MEMBER_VALUE = "value";
    private CompilationUnit context;
    private ExpressionHandler expressionHandler = new ExpressionHandler(this);
    private StatementAnalyzer statementHandler = new StatementAnalyzer(this);
    private DeclarationHandler declarationHandler = new DeclarationHandler(this);
    private JavaSymbolSolver javaSymbolResolver;
    private CombinedTypeSolver internalTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);

    public JavaLanguageFrontend(@NonNull TranslationConfiguration config, ScopeManager scopeManager) {
        super(config, scopeManager, ".");
        ReflectionTypeSolver reflectionTypeSolver = new ReflectionTypeSolver();
        this.internalTypeSolver.add((TypeSolver)reflectionTypeSolver);
        File root = config.getTopLevel();
        if (root == null) {
            root = CommonPath.commonPath(config.getSourceLocations());
        }
        if (root == null) {
            log.warn("Could not determine source root for {}", config.getSourceLocations());
        } else {
            log.info("Source file root used for type solver: {}", (Object)root);
            JavaParserTypeSolver javaParserTypeSolver = new JavaParserTypeSolver(root);
            this.internalTypeSolver.add((TypeSolver)javaParserTypeSolver);
        }
        this.javaSymbolResolver = new JavaSymbolSolver((TypeSolver)this.internalTypeSolver);
    }

    @Override
    public TranslationUnitDeclaration parse(File file) throws TranslationException {
        TypeManager.getInstance().setLanguageFrontend(this);
        try {
            ParserConfiguration parserConfiguration = new ParserConfiguration();
            parserConfiguration.setSymbolResolver((SymbolResolver)this.javaSymbolResolver);
            JavaParser parser = new JavaParser(parserConfiguration);
            Benchmark bench = new Benchmark(this.getClass(), "Parsing source file");
            this.context = this.parse(file, parser);
            bench.stop();
            bench = new Benchmark(this.getClass(), "Transform to CPG");
            this.context.setData(Node.SYMBOL_RESOLVER_KEY, (Object)this.javaSymbolResolver);
            TranslationUnitDeclaration fileDeclaration = NodeBuilder.newTranslationUnitDeclaration(file.toString(), this.context.toString());
            this.setCurrentTU(fileDeclaration);
            this.scopeManager.resetToGlobal(fileDeclaration);
            PackageDeclaration packDecl = this.context.getPackageDeclaration().orElse(null);
            NamespaceDeclaration namespaceDeclaration = null;
            if (packDecl != null) {
                namespaceDeclaration = NodeBuilder.newNamespaceDeclaration(packDecl.getName().asString(), this.getCodeFromRawNode(packDecl));
                this.scopeManager.addDeclaration(namespaceDeclaration);
                this.scopeManager.enterScope(namespaceDeclaration);
            }
            for (TypeDeclaration type : this.context.getTypes()) {
                this.getDeclarationHandler().handle(type);
            }
            for (ImportDeclaration anImport : this.context.getImports()) {
                IncludeDeclaration incl = NodeBuilder.newIncludeDeclaration(anImport.getNameAsString());
                this.scopeManager.addDeclaration(incl);
            }
            if (packDecl != null) {
                this.scopeManager.leaveScope(namespaceDeclaration);
            }
            bench.stop();
            return fileDeclaration;
        }
        catch (IOException ex) {
            throw new TranslationException(ex);
        }
    }

    protected CompilationUnit parse(File file, JavaParser parser) throws TranslationException, FileNotFoundException {
        ParseResult result = parser.parse(file);
        Optional optional = result.getResult();
        if (optional.isEmpty()) {
            throw new TranslationException("JavaParser could not parse file");
        }
        if (((CompilationUnit)optional.get()).getParsed() == Node.Parsedness.PARSED) {
            log.debug("Successfully parsed java file");
        } else {
            result.getProblems().forEach(p -> {
                StringBuilder sb = new StringBuilder();
                sb.append(p.getMessage());
                if (p.getLocation().isPresent() && ((TokenRange)p.getLocation().get()).getBegin().getRange().isPresent()) {
                    sb.append(" ");
                    sb.append(((Range)((TokenRange)p.getLocation().get()).getBegin().getRange().get()).begin.toString());
                }
                log.error(sb.toString());
            });
            log.error("Could not parse the file {} correctly! AST may be empty", (Object)file);
        }
        return (CompilationUnit)optional.get();
    }

    @Override
    public <T> String getCodeFromRawNode(T astNode) {
        Node node;
        Optional optional;
        if (astNode instanceof Node && (optional = (node = (Node)astNode).getTokenRange()).isPresent()) {
            return ((TokenRange)optional.get()).toString();
        }
        return astNode.toString();
    }

    @Override
    public <T> @Nullable PhysicalLocation getLocationFromRawNode(T astNode) {
        if (astNode instanceof Node) {
            Node node = (Node)astNode;
            CompilationUnit cu = node.findCompilationUnit().orElse(null);
            if (cu == null) {
                return null;
            }
            CompilationUnit.Storage storage = cu.getStorage().orElse(null);
            if (storage == null) {
                return null;
            }
            Optional optional = node.getRange();
            if (optional.isPresent()) {
                Range r = (Range)optional.get();
                Region region = new Region(r.begin.line, r.begin.column, r.end.line, r.end.column + 1);
                return new PhysicalLocation(storage.getPath().toUri(), region);
            }
        }
        return null;
    }

    public Type getTypeAsGoodAsPossible(NodeWithType nodeWithType, ResolvedValueDeclaration resolved) {
        try {
            return TypeParser.createFrom(resolved.getType().describe(), true);
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            return this.getTypeFromImportIfPossible(nodeWithType.getType());
        }
    }

    public String getQualifiedMethodNameAsGoodAsPossible(MethodCallExpr callExpr) {
        try {
            return callExpr.resolve().getQualifiedName();
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            Optional scope = callExpr.getScope();
            if (scope.isPresent()) {
                String fromImport;
                com.github.javaparser.ast.expr.Expression expression = (com.github.javaparser.ast.expr.Expression)scope.get();
                if (expression instanceof NameExpr && (fromImport = this.getQualifiedNameFromImports(callExpr.getNameAsString())) != null) {
                    return fromImport;
                }
                if (((com.github.javaparser.ast.expr.Expression)scope.get()).toString().equals(THIS)) {
                    return this.getScopeManager().getCurrentNamePrefix() + "." + callExpr.getNameAsString();
                }
                return ((com.github.javaparser.ast.expr.Expression)scope.get()).toString() + "." + callExpr.getNameAsString();
            }
            String fromImport = this.getQualifiedNameFromImports(callExpr.getNameAsString());
            if (fromImport != null) {
                return fromImport;
            }
            return this.getScopeManager().getCurrentNamePrefix() + "." + callExpr.getNameAsString();
        }
    }

    public @Nullable String recoverTypeFromUnsolvedException(Throwable ex) {
        if (ex instanceof UnsolvedSymbolException || ex.getCause() != null && ex.getCause() instanceof UnsolvedSymbolException) {
            String qualifier = ex instanceof UnsolvedSymbolException ? ((UnsolvedSymbolException)ex).getName() : ((UnsolvedSymbolException)ex.getCause()).getName();
            if (qualifier.startsWith("We are unable to find") || qualifier.startsWith("Solving ")) {
                return null;
            }
            String fromImport = this.getQualifiedNameFromImports(qualifier);
            if (fromImport != null) {
                return fromImport;
            }
            return this.getFQNInCurrentPackage(qualifier);
        }
        log.debug("Unable to resolve qualified name from exception");
        return null;
    }

    public @Nullable String getQualifiedNameFromImports(String className) {
        if (this.context != null && className != null) {
            ArrayList<CallSite> potentialClassNames = new ArrayList<CallSite>();
            StringBuilder prefix = new StringBuilder();
            for (String string : className.split("\\.")) {
                potentialClassNames.add((CallSite)((Object)(prefix + string)));
                prefix.append(string).append(".");
            }
            for (ImportDeclaration importDeclaration : this.context.getImports()) {
                for (String string : potentialClassNames) {
                    if (!importDeclaration.getName().asString().endsWith("." + string)) continue;
                    prefix = new StringBuilder(importDeclaration.getName().asString());
                    return prefix.substring(0, prefix.lastIndexOf(string)) + className;
                }
            }
        }
        return null;
    }

    public Type getTypeAsGoodAsPossible(com.github.javaparser.ast.type.Type type) {
        try {
            return TypeParser.createFrom(type.resolve().describe(), true);
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            return this.getTypeFromImportIfPossible(type);
        }
    }

    public Type getReturnTypeAsGoodAsPossible(NodeWithType nodeWithType, ResolvedMethodDeclaration resolved) {
        try {
            Type type = TypeManager.getInstance().getTypeParameter(this.scopeManager.getCurrentRecord(), resolved.getReturnType().describe());
            if (type == null) {
                type = TypeParser.createFrom(resolved.getReturnType().describe(), true);
            }
            return type;
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            return this.getTypeFromImportIfPossible(nodeWithType.getType());
        }
    }

    private String getFQNInCurrentPackage(String simpleName) {
        Scope theScope = this.getScopeManager().getFirstScopeThat(scope -> scope.getAstNode() instanceof NamespaceDeclaration);
        if (theScope == null) {
            return simpleName;
        }
        return theScope.getScopedName() + this.getNamespaceDelimiter() + simpleName;
    }

    private Type getTypeFromImportIfPossible(com.github.javaparser.ast.type.Type type) {
        com.github.javaparser.ast.type.Type searchType = type;
        while (searchType.isArrayType()) {
            searchType = searchType.getElementType();
        }
        if (!searchType.isClassOrInterfaceType() || this.context == null) {
            log.warn("Unable to resolve type for {}", (Object)type.asString());
            Type returnType = TypeParser.createFrom(type.asString(), true);
            returnType.setTypeOrigin(Type.Origin.GUESSED);
            return returnType;
        }
        ClassOrInterfaceType clazz = searchType.asClassOrInterfaceType();
        if (clazz != null) {
            for (ImportDeclaration importDeclaration : this.context.getImports()) {
                if (!importDeclaration.getName().getIdentifier().endsWith(clazz.getName().getIdentifier())) continue;
                return TypeParser.createFrom(importDeclaration.getNameAsString(), true);
            }
            Object name = clazz.asString();
            Optional o = this.context.getPackageDeclaration();
            if (o.isPresent()) {
                name = ((PackageDeclaration)o.get()).getNameAsString() + this.getNamespaceDelimiter() + (String)name;
            }
            Type returnType = TypeParser.createFrom((String)name, true);
            returnType.setTypeOrigin(Type.Origin.GUESSED);
            return returnType;
        }
        log.warn("Unable to resolve type for {}", (Object)type.asString());
        Type returnType = TypeParser.createFrom(type.asString(), true);
        returnType.setTypeOrigin(Type.Origin.GUESSED);
        return returnType;
    }

    @Override
    public void cleanup() {
        JavaParserFacade.clearInstances();
        super.cleanup();
        this.context = null;
        this.expressionHandler = null;
        this.statementHandler = null;
        this.declarationHandler = null;
        this.javaSymbolResolver = null;
    }

    @Override
    public <S, T> void setComment(S s, T ctx) {
        if (ctx instanceof de.fraunhofer.aisec.cpg.graph.Node && s instanceof de.fraunhofer.aisec.cpg.graph.Node) {
            Node node = (Node)ctx;
            de.fraunhofer.aisec.cpg.graph.Node cpgNode = (de.fraunhofer.aisec.cpg.graph.Node)s;
            node.getComment().ifPresent(comment -> cpgNode.setComment(comment.getContent()));
        }
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public StatementAnalyzer getStatementHandler() {
        return this.statementHandler;
    }

    public DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    public CompilationUnit getContext() {
        return this.context;
    }

    public CombinedTypeSolver getNativeTypeResolver() {
        return this.internalTypeSolver;
    }

    public void processAnnotations(@NonNull de.fraunhofer.aisec.cpg.graph.Node node, NodeWithAnnotations<?> owner) {
        if (this.config.processAnnotations) {
            node.addAnnotations(this.handleAnnotations(owner));
        }
    }

    private List<Annotation> handleAnnotations(NodeWithAnnotations<?> owner) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (AnnotationExpr expr : owner.getAnnotations()) {
            com.github.javaparser.ast.expr.Expression value;
            Annotation annotation = NodeBuilder.newAnnotation(expr.getNameAsString(), this.getCodeFromRawNode(expr));
            ArrayList<AnnotationMember> members = new ArrayList<AnnotationMember>();
            if (expr.isNormalAnnotationExpr()) {
                for (MemberValuePair pair : expr.asNormalAnnotationExpr().getPairs()) {
                    AnnotationMember member = NodeBuilder.newAnnotationMember(pair.getNameAsString(), (Expression)this.expressionHandler.handle(pair.getValue()), this.getCodeFromRawNode(pair));
                    members.add(member);
                }
            } else if (expr.isSingleMemberAnnotationExpr() && (value = expr.asSingleMemberAnnotationExpr().getMemberValue()) != null) {
                AnnotationMember member = NodeBuilder.newAnnotationMember(ANNOTATION_MEMBER_VALUE, (Expression)this.expressionHandler.handle(value.asLiteralExpr()), this.getCodeFromRawNode(value));
                members.add(member);
            }
            annotation.setMembers(members);
            list.add(annotation);
        }
        return list;
    }
}

