/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class FunctionDeclaration
extends ValueDeclaration
implements DeclarationHolder {
    private static final String WHITESPACE = " ";
    private static final String BRACKET_LEFT = "(";
    private static final String COMMA = ",";
    private static final String BRACKET_RIGHT = ")";
    @SubGraph(value={"AST"})
    protected Statement body;
    @Relationship(value="RECORDS", direction="OUTGOING")
    protected List<PropertyEdge<RecordDeclaration>> records = new ArrayList<PropertyEdge<RecordDeclaration>>();
    @Relationship(value="PARAMETERS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    protected List<PropertyEdge<ParamVariableDeclaration>> parameters = new ArrayList<PropertyEdge<ParamVariableDeclaration>>();
    @Relationship(value="THROWS_TYPES", direction="OUTGOING")
    protected List<PropertyEdge<Type>> throwsTypes = new ArrayList<PropertyEdge<Type>>();
    @Relationship(value="OVERRIDES", direction="INCOMING")
    private final List<PropertyEdge<FunctionDeclaration>> overriddenBy = new ArrayList<PropertyEdge<FunctionDeclaration>>();
    @Relationship(value="OVERRIDES", direction="OUTGOING")
    private final List<PropertyEdge<FunctionDeclaration>> overrides = new ArrayList<PropertyEdge<FunctionDeclaration>>();
    private boolean isDefinition;
    @Relationship(value="DEFINES")
    private FunctionDeclaration definition;

    public boolean hasBody() {
        return this.body != null;
    }

    public String getSignature() {
        return this.name + BRACKET_LEFT + this.parameters.stream().map(PropertyEdge::getEnd).map(x -> x.getType().getTypeName()).collect(Collectors.joining(", ")) + BRACKET_RIGHT + ((Type)Objects.requireNonNullElse(this.type, UnknownType.getUnknownType())).getTypeName();
    }

    public boolean hasSignature(List<Type> targetSignature) {
        List signature = this.parameters.stream().map(PropertyEdge::getEnd).sorted(Comparator.comparingInt(Node::getArgumentIndex)).collect(Collectors.toList());
        if (targetSignature.size() < signature.size()) {
            return false;
        }
        for (int i = 0; i < signature.size(); ++i) {
            ParamVariableDeclaration declared = (ParamVariableDeclaration)signature.get(i);
            if (declared.isVariadic() && targetSignature.size() >= signature.size()) {
                return true;
            }
            Type provided = targetSignature.get(i);
            if (TypeManager.getInstance().isSupertypeOf(declared.getType(), provided)) continue;
            return false;
        }
        return targetSignature.size() == signature.size();
    }

    public boolean isOverrideCandidate(FunctionDeclaration other) {
        return other.getName().equals(this.name) && other.getType().equals(this.type) && other.getSignature().equals(this.getSignature());
    }

    public List<FunctionDeclaration> getOverriddenBy() {
        return PropertyEdge.unwrap(this.overriddenBy, false);
    }

    public List<PropertyEdge<FunctionDeclaration>> getOverriddenByPropertyEdge() {
        return this.overriddenBy;
    }

    public void addOverriddenBy(Collection<? extends FunctionDeclaration> c) {
        for (FunctionDeclaration functionDeclaration : c) {
            this.addOverriddenBy(functionDeclaration);
        }
    }

    public void addOverriddenBy(FunctionDeclaration functionDeclaration) {
        this.addIfNotContains(this.overriddenBy, functionDeclaration, false);
    }

    public List<FunctionDeclaration> getOverrides() {
        return PropertyEdge.unwrap(this.overrides);
    }

    public List<PropertyEdge<FunctionDeclaration>> getOverridesPropertyEdge() {
        return this.overrides;
    }

    public void addOverrides(FunctionDeclaration functionDeclaration) {
        this.addIfNotContains(this.overrides, functionDeclaration);
    }

    public List<Type> getThrowsTypes() {
        return PropertyEdge.unwrap(this.throwsTypes);
    }

    public List<PropertyEdge<Type>> getThrowsTypesPropertyEdge() {
        return this.throwsTypes;
    }

    public void setThrowsTypes(List<Type> throwsTypes) {
        this.throwsTypes = PropertyEdge.transformIntoOutgoingPropertyEdgeList(throwsTypes, this);
    }

    public void addThrowTypes(Type type) {
        PropertyEdge<Type> propertyEdge = new PropertyEdge<Type>(this, type);
        propertyEdge.addProperty(Properties.INDEX, this.throwsTypes.size());
        this.throwsTypes.add(propertyEdge);
    }

    public void addThrowTypes(Collection<Type> collection) {
        for (Type type : collection) {
            this.addThrowTypes(type);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public <T> @Nullable T getBodyStatementAs(int i, Class<T> clazz) {
        if (this.body instanceof CompoundStatement) {
            Statement statement = ((CompoundStatement)this.body).getStatements().get(i);
            if (statement == null) {
                return null;
            }
            return statement.getClass().isAssignableFrom(clazz) ? (T)clazz.cast(statement) : null;
        }
        return null;
    }

    public void setBody(Statement body) {
        if (this.body instanceof ReturnStatement) {
            this.removePrevDFG(this.body);
        } else if (this.body instanceof CompoundStatement) {
            ((CompoundStatement)this.body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::removePrevDFG);
        }
        this.body = body;
        if (body instanceof ReturnStatement) {
            this.addPrevDFG(body);
        } else if (body instanceof CompoundStatement) {
            ((CompoundStatement)body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::addPrevDFG);
        }
    }

    public List<ParamVariableDeclaration> getParameters() {
        return PropertyEdge.unwrap(this.parameters);
    }

    public List<Type> getSignatureTypes() {
        ArrayList<Type> signatureTypes = new ArrayList<Type>();
        for (ParamVariableDeclaration paramVariableDeclaration : PropertyEdge.unwrap(this.parameters)) {
            signatureTypes.add(paramVariableDeclaration.getType());
        }
        return signatureTypes;
    }

    public List<PropertyEdge<ParamVariableDeclaration>> getParametersPropertyEdge() {
        return this.parameters;
    }

    public void addParameter(ParamVariableDeclaration paramVariableDeclaration) {
        PropertyEdge<ParamVariableDeclaration> propertyEdge = new PropertyEdge<ParamVariableDeclaration>(this, paramVariableDeclaration);
        propertyEdge.addProperty(Properties.INDEX, this.parameters.size());
        this.parameters.add(propertyEdge);
    }

    public void removeParameter(ParamVariableDeclaration paramVariableDeclaration) {
        this.parameters.removeIf(propertyEdge -> ((ParamVariableDeclaration)propertyEdge.getEnd()).equals(paramVariableDeclaration));
    }

    public void setParameters(List<ParamVariableDeclaration> parameters) {
        this.parameters = PropertyEdge.transformIntoOutgoingPropertyEdgeList(parameters, this);
    }

    public Optional<VariableDeclaration> getVariableDeclarationByName(String name) {
        if (this.body instanceof CompoundStatement) {
            return ((CompoundStatement)this.body).getStatements().stream().filter(statement -> statement instanceof DeclarationStatement).map(DeclarationStatement.class::cast).flatMap(declarationStatement -> declarationStatement.getDeclarations().stream()).filter(declaration -> declaration instanceof VariableDeclaration).map(VariableDeclaration.class::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.type).append("parameters", (Object)this.parameters.stream().map(PropertyEdge::getEnd).map(Node::getName).collect(Collectors.joining(", "))).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionDeclaration)) {
            return false;
        }
        FunctionDeclaration that = (FunctionDeclaration)o;
        return super.equals(that) && Objects.equals(this.body, that.body) && Objects.equals(this.getParameters(), that.getParameters()) && PropertyEdge.propertyEqualsList(this.parameters, that.parameters) && Objects.equals(this.getThrowsTypes(), that.getThrowsTypes()) && PropertyEdge.propertyEqualsList(this.throwsTypes, that.throwsTypes) && Objects.equals(this.getOverriddenBy(), that.getOverriddenBy()) && PropertyEdge.propertyEqualsList(this.overriddenBy, that.overriddenBy) && Objects.equals(this.getOverrides(), that.getOverrides()) && PropertyEdge.propertyEqualsList(this.overrides, that.overrides);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public FunctionDeclaration getDefinition() {
        return this.isDefinition ? this : this.definition;
    }

    public boolean isDefinition() {
        return this.isDefinition;
    }

    public void setIsDefinition(boolean definition) {
        this.isDefinition = definition;
    }

    public void setDefinition(FunctionDeclaration definition) {
        this.definition = definition;
    }

    public List<RecordDeclaration> getRecords() {
        return PropertyEdge.unwrap(this.records);
    }

    public List<PropertyEdge<RecordDeclaration>> getRecordsPropertyEdge() {
        return this.records;
    }

    public void setRecords(List<RecordDeclaration> records) {
        this.records = PropertyEdge.transformIntoOutgoingPropertyEdgeList(records, this);
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof ParamVariableDeclaration) {
            this.addIfNotContains(this.parameters, (ParamVariableDeclaration)declaration);
        }
        if (declaration instanceof RecordDeclaration) {
            this.addIfNotContains(this.records, (RecordDeclaration)declaration);
        }
    }
}

