/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class Util {
    public static List<Node> subnodesOfCode(Node node, String searchCode) {
        return SubgraphWalker.flattenAST(node).stream().filter(n -> n.getCode() != null && n.getCode().equals(searchCode)).collect(Collectors.toList());
    }

    public static boolean eogConnect(Connect cn, Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, cn, en, n, cr, refs);
    }

    public static boolean eogConnect(Quantifier q, Connect cn, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(q, cn, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(q, Connect.SUBTREE, en, n, cr, refs);
    }

    public static boolean eogConnect(Connect cn, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, cn, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(q, Connect.SUBTREE, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, Connect.SUBTREE, en, n, cr, refs);
    }

    public static boolean eogConnect(Edge en, Node n, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, Connect.SUBTREE, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Connect cn, Edge en, Node n, Connect cr, Node ... refs) {
        List<Node> nodeSide = List.of(n);
        Edge er = en == Edge.ENTRIES ? Edge.EXITS : Edge.ENTRIES;
        List<Node> refSide = Arrays.asList(refs);
        if (cn == Connect.SUBTREE) {
            SubgraphWalker.Border border2 = SubgraphWalker.getEOGPathEdges(n);
            nodeSide = en == Edge.ENTRIES ? border2.getEntries().stream().flatMap(r -> r.getPrevEOG().stream()).collect(Collectors.toList()) : border2.getExits();
        } else {
            nodeSide = nodeSide.stream().flatMap(node -> (en == Edge.ENTRIES ? node.getPrevEOG() : List.of(node)).stream()).collect(Collectors.toList());
        }
        if (cr == Connect.SUBTREE) {
            List borders = Arrays.stream(refs).map(SubgraphWalker::getEOGPathEdges).collect(Collectors.toList());
            refSide = borders.stream().flatMap(border -> Edge.ENTRIES == er ? border.getEntries().stream().flatMap(r -> r.getPrevEOG().stream()) : border.getExits().stream()).collect(Collectors.toList());
        } else {
            refSide = refSide.stream().flatMap(node -> (er == Edge.ENTRIES ? node.getPrevEOG() : List.of(node)).stream()).collect(Collectors.toList());
        }
        List<Node> refNodes = refSide;
        return Quantifier.ANY == q ? nodeSide.stream().anyMatch(refNodes::contains) : refNodes.containsAll(nodeSide);
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public static <T> Predicate<T> distinctByIdentity() {
        IdentityHashMap seen = new IdentityHashMap();
        return t -> {
            if (seen.containsKey(t)) {
                return false;
            }
            seen.put(t, true);
            return true;
        };
    }

    public static <T> Predicate<T> distinctBy(Function<? super T, ?> by) {
        HashSet seen = new HashSet();
        return t -> seen.add(by.apply(t));
    }

    public static String getExtension(@NonNull File file) {
        int pos = file.getName().lastIndexOf(46);
        if (pos > 0) {
            return file.getName().substring(pos).toLowerCase();
        }
        return "";
    }

    public static <S> void warnWithFileLocation(@NonNull LanguageFrontend lang, S astNode, Logger log, String format, Object ... arguments) {
        log.warn(String.format("%s: %s", PhysicalLocation.locationLink(lang.getLocationFromRawNode(astNode)), format), arguments);
    }

    public static <S> void errorWithFileLocation(@NonNull LanguageFrontend lang, S astNode, Logger log, String format, Object ... arguments) {
        log.error(String.format("%s: %s", PhysicalLocation.locationLink(lang.getLocationFromRawNode(astNode)), format), arguments);
    }

    public static void warnWithFileLocation(@NonNull Node node, Logger log, String format, Object ... arguments) {
        log.warn(String.format("%s: %s", PhysicalLocation.locationLink(node.getLocation()), format), arguments);
    }

    public static void errorWithFileLocation(@NonNull Node node, Logger log, String format, Object ... arguments) {
        log.error(String.format("%s: %s", PhysicalLocation.locationLink(node.getLocation()), format), arguments);
    }

    public static List<String> splitLeavingParenthesisContents(String toSplit, String delimiters) {
        ArrayList<String> result = new ArrayList<String>();
        int openParentheses = 0;
        StringBuilder currPart = new StringBuilder();
        for (char c : toSplit.toCharArray()) {
            if (c == '(') {
                ++openParentheses;
                currPart.append(c);
                continue;
            }
            if (c == ')') {
                if (openParentheses > 0) {
                    --openParentheses;
                }
                currPart.append(c);
                continue;
            }
            if (delimiters.contains("" + c)) {
                if (openParentheses == 0) {
                    String toAdd = currPart.toString().strip();
                    if (!toAdd.isEmpty()) {
                        result.add(currPart.toString().strip());
                    }
                    currPart = new StringBuilder();
                    continue;
                }
                currPart.append(c);
                continue;
            }
            currPart.append(c);
        }
        if (currPart.length() > 0) {
            result.add(currPart.toString().strip());
        }
        return result;
    }

    public static String removeRedundantParentheses(String original) {
        char[] result = original.toCharArray();
        char marker = '\uffff';
        ArrayDeque<Integer> openingParentheses = new ArrayDeque<Integer>();
        block4: for (int i = 0; i < original.length(); ++i) {
            char c = original.charAt(i);
            switch (c) {
                case '(': {
                    openingParentheses.push(i);
                    continue block4;
                }
                case ')': {
                    int matching = (Integer)openingParentheses.pop();
                    if (matching == 0 && i == original.length() - 1) {
                        result[matching] = result[i] = marker;
                        continue block4;
                    }
                    if (matching <= 0 || result[matching - 1] != '(' || result[i + 1] != ')') continue block4;
                    result[matching] = result[i] = marker;
                }
            }
        }
        return new String(result).replace("" + marker, "");
    }

    public static boolean containsOnOuterLevel(String input, char marker) {
        int openParentheses = 0;
        for (char c : input.toCharArray()) {
            if (c == '(') {
                ++openParentheses;
                continue;
            }
            if (c == ')') {
                --openParentheses;
                continue;
            }
            if (c != marker || openParentheses != 0) continue;
            return true;
        }
        return false;
    }

    public static void attachCallParameters(FunctionDeclaration target, List<Expression> arguments) {
        target.getParametersPropertyEdge().sort(Comparator.comparing(pe -> ((ParamVariableDeclaration)pe.getEnd()).getArgumentIndex()));
        for (int j = 0; j < arguments.size(); ++j) {
            List<ParamVariableDeclaration> parameters = target.getParameters();
            if (j >= parameters.size()) continue;
            ParamVariableDeclaration param = parameters.get(j);
            if (param.isVariadic()) {
                while (j < arguments.size()) {
                    param.addPrevDFG(arguments.get(j));
                    ++j;
                }
                break;
            }
            param.addPrevDFG(arguments.get(j));
        }
    }

    public static String getSimpleName(String delimiter, String name) {
        if (name.contains(delimiter)) {
            name = name.substring(name.lastIndexOf(delimiter) + delimiter.length());
        }
        return name;
    }

    public static void detachCallParameters(FunctionDeclaration target, List<Expression> arguments) {
        for (ParamVariableDeclaration param : target.getParameters()) {
            param.getPrevDFG().stream().filter(arguments::contains).forEach(param::removeNextDFG);
        }
    }

    public static List<ParamVariableDeclaration> createParameters(List<Type> signature) {
        ArrayList<ParamVariableDeclaration> params = new ArrayList<ParamVariableDeclaration>();
        for (int i = 0; i < signature.size(); ++i) {
            Type targetType = signature.get(i);
            String paramName = Util.generateParamName(i, targetType);
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(paramName, targetType, false, "");
            param.setImplicit(true);
            param.setArgumentIndex(i);
            params.add(param);
        }
        return params;
    }

    private static String generateParamName(int i, @NonNull Type targetType) {
        ArrayDeque<String> hierarchy = new ArrayDeque<String>();
        Type currLevel = targetType;
        while (currLevel != null) {
            if (currLevel instanceof FunctionPointerType) {
                hierarchy.push("Fptr");
                currLevel = null;
                continue;
            }
            if (currLevel instanceof PointerType) {
                hierarchy.push("Ptr");
                currLevel = ((PointerType)currLevel).getElementType();
                continue;
            }
            if (currLevel instanceof ReferenceType) {
                hierarchy.push("Ref");
                currLevel = ((ReferenceType)currLevel).getElementType();
                continue;
            }
            hierarchy.push(currLevel.getTypeName());
            currLevel = null;
        }
        StringBuilder paramName = new StringBuilder();
        while (!hierarchy.isEmpty()) {
            String part = (String)hierarchy.pop();
            if (part.isEmpty()) continue;
            if (paramName.length() > 0) {
                paramName.append(part.substring(0, 1).toUpperCase());
                if (part.length() < 2) continue;
                paramName.append(part.substring(1));
                continue;
            }
            paramName.append(part.toLowerCase());
        }
        paramName.append(i);
        return paramName.toString();
    }

    public static <T, S extends T> List<S> filterCast(List<T> genericList, Class<S> specificClass) {
        return genericList.stream().filter(g -> specificClass.isAssignableFrom(g.getClass())).map(specificClass::cast).collect(Collectors.toList());
    }

    static <T> Stream<T> reverse(Stream<T> input) {
        Object[] temp = input.toArray();
        return IntStream.range(0, temp.length).mapToObj(i -> temp[temp.length - i - 1]);
    }

    public static List<Node> getAdjacentDFGNodes(Node n, boolean incoming) {
        Set<Node> subnodes = SubgraphWalker.getAstChildren(n);
        List<Node> adjacentNodes = incoming ? subnodes.stream().filter(prevCandidate -> prevCandidate.getNextDFG().contains(n)).collect(Collectors.toList()) : subnodes.stream().filter(nextCandidate -> nextCandidate.getPrevDFG().contains(n)).collect(Collectors.toList());
        return adjacentNodes;
    }

    public static void addDFGEdgesForMutuallyExclusiveBranchingExpression(Node n, Node branchingExp, Node branchingDecl) {
        List<Node> conditionNodes = new ArrayList<Node>();
        if (branchingExp != null) {
            conditionNodes = new ArrayList();
            conditionNodes.add(branchingExp);
        } else if (branchingDecl != null) {
            conditionNodes = Util.getAdjacentDFGNodes(branchingDecl, true);
        }
        conditionNodes.forEach(c -> n.addPrevDFG((Node)c));
    }

    public static enum Edge {
        ENTRIES,
        EXITS;

    }

    public static enum Quantifier {
        ANY,
        ALL;

    }

    public static enum Connect {
        NODE,
        SUBTREE;

    }
}

