/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaExternalTypeHierarchyResolver
extends Pass {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaExternalTypeHierarchyResolver.class);

    @Override
    public void accept(TranslationResult translationResult) {
        if (this.lang instanceof JavaLanguageFrontend) {
            CombinedTypeSolver resolver = ((JavaLanguageFrontend)this.lang).getNativeTypeResolver();
            TypeManager tm = TypeManager.getInstance();
            for (Type t : new HashSet<Type>(tm.getFirstOrderTypes())) {
                SymbolReference symbol = resolver.tryToSolveType(t.getTypeName());
                if (!symbol.isSolved()) continue;
                try {
                    List resolvedSuperTypes = ((ResolvedReferenceTypeDeclaration)symbol.getCorrespondingDeclaration()).getAncestors(true);
                    for (ResolvedReferenceType anc : resolvedSuperTypes) {
                        Type superType = TypeParser.createFrom(anc.getQualifiedName(), false);
                        superType.setTypeOrigin(Type.Origin.RESOLVED);
                        t.getSuperTypes().add(superType);
                    }
                }
                catch (UnsolvedSymbolException e) {
                    LOGGER.warn("Could not resolve supertypes of {}", (Object)symbol.getCorrespondingDeclaration());
                }
            }
        }
    }

    @Override
    public void cleanup() {
    }
}

