/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Empty;
import wpds.interfaces.IPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;
import wpds.interfaces.WPDSUpdateListener;
import wpds.wildcard.ExclusionWildcard;
import wpds.wildcard.Wildcard;

public abstract class PostStar<N extends Location, D extends State, W extends Weight> {
    private IPushdownSystem<N, D, W> pds;
    private WeightedPAutomaton<N, D, W> fa;

    public void poststar(IPushdownSystem<N, D, W> pds, WeightedPAutomaton<N, D, W> initialAutomaton) {
        this.pds = pds;
        this.fa = initialAutomaton;
        this.fa.setInitialAutomaton(this.fa);
        this.pds.registerUpdateListener(new PostStarUpdateListener(this.fa));
    }

    private void update(Transition<N, D> trans, W weight) {
        if (!this.fa.nested()) {
            this.fa.addWeightForTransition(trans, weight);
        } else {
            this.getSummaryAutomaton(trans.getTarget()).addWeightForTransition(trans, weight);
        }
    }

    private W getWeightFor(Transition<N, D> trans) {
        if (!this.fa.nested()) {
            return this.fa.getWeightFor(trans);
        }
        return this.getSummaryAutomaton(trans.getTarget()).getWeightFor(trans);
    }

    private WeightedPAutomaton<N, D, W> getOrCreateSummaryAutomaton(D target, Transition<N, D> transition, W weight, WeightedPAutomaton<N, D, W> context) {
        WeightedPAutomaton<N, D, W> aut = this.getSummaryAutomaton(target);
        if (aut == null) {
            aut = context.createNestedAutomaton(target);
            this.putSummaryAutomaton(target, aut);
            aut.setInitialAutomaton(this.fa);
        } else {
            context.addNestedAutomaton(aut);
        }
        aut.addWeightForTransition(transition, weight);
        return aut;
    }

    public abstract void putSummaryAutomaton(D var1, WeightedPAutomaton<N, D, W> var2);

    public abstract WeightedPAutomaton<N, D, W> getSummaryAutomaton(D var1);

    private class HandlePushListener
    extends WPAStateListener<N, D, W> {
        private PushRule<N, D, W> rule;

        public HandlePushListener(PushRule<N, D, W> rule) {
            super(rule.getS1());
            this.rule = rule;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
            if (t.getLabel().equals(this.rule.getL1()) || this.rule.getL1() instanceof Wildcard) {
                if (this.rule.getCallSite() instanceof Wildcard && t.getLabel().equals(PostStar.this.fa.epsilon())) {
                    return;
                }
                Object p = this.rule.getS2();
                Object gammaPrime = this.rule.getL2();
                Object irState = PostStar.this.fa.createState(p, gammaPrime);
                Object transitionLabel = this.rule.getCallSite() instanceof Wildcard ? t.getLabel() : this.rule.getCallSite();
                Transition<Object, Object> callSiteTransition = new Transition<Object, Object>(irState, transitionLabel, t.getTarget());
                Transition calleeTransition = new Transition(p, gammaPrime, irState);
                Weight weightAtCallsite = ((Weight)weight).extendWith((Weight)this.rule.getWeight());
                PostStar.this.update(callSiteTransition, weightAtCallsite);
                if (!PostStar.this.fa.nested()) {
                    PostStar.this.update(calleeTransition, PostStar.this.fa.getOne());
                } else {
                    if (!PostStar.this.fa.isGeneratedState(irState)) {
                        throw new RuntimeException("State must be generated");
                    }
                    WeightedPAutomaton summary = PostStar.this.getOrCreateSummaryAutomaton(irState, calleeTransition, PostStar.this.fa.getOne(), aut);
                    summary.registerListener(new WPAUpdateListener<N, D, W>((State)irState, callSiteTransition){
                        final /* synthetic */ State val$irState;
                        final /* synthetic */ Transition val$callSiteTransition;
                        {
                            this.val$irState = state;
                            this.val$callSiteTransition = transition;
                        }

                        @Override
                        public void onWeightAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> innerAut) {
                            if (t.getLabel().equals(PostStar.this.fa.epsilon()) && t.getTarget().equals(this.val$irState)) {
                                PostStar.this.update(t, w);
                                Weight newWeight = PostStar.this.getWeightFor(this.val$callSiteTransition);
                                PostStar.this.update(new Transition<Object, Object>(t.getStart(), this.val$callSiteTransition.getLabel(), this.val$callSiteTransition.getTarget()), newWeight.extendWith((Weight)w));
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlePushListener other = (HandlePushListener)obj;
            return !(this.rule == null ? other.rule != null : !this.rule.equals(other.rule));
        }
    }

    private class HandleNormalListener
    extends WPAStateListener<N, D, W> {
        private NormalRule<N, D, W> rule;

        public HandleNormalListener(NormalRule<N, D, W> rule) {
            super(rule.getS1());
            this.rule = rule;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
            if (t.getLabel().equals(this.rule.getL1()) || this.rule.getL1() instanceof Wildcard) {
                Weight newWeight = ((Weight)weight).extendWith((Weight)this.rule.getWeight());
                Object p = this.rule.getS2();
                Object l2 = this.rule.getL2();
                if (l2 instanceof ExclusionWildcard) {
                    ExclusionWildcard ex = (ExclusionWildcard)l2;
                    if (t.getLabel().equals(ex.excludes())) {
                        return;
                    }
                }
                if (l2 instanceof Wildcard && (l2 = t.getLabel()).equals(PostStar.this.fa.epsilon())) {
                    return;
                }
                if (!this.rule.canBeApplied(t, weight)) {
                    return;
                }
                PostStar.this.update(new Transition<Object, Object>(p, l2, t.getTarget()), newWeight);
            }
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandleNormalListener other = (HandleNormalListener)obj;
            return !(this.rule == null ? other.rule != null : !this.rule.equals(other.rule));
        }
    }

    private static class HandlePopListener
    extends WPAStateListener<N, D, W> {
        private N popLabel;
        private D targetState;
        private W ruleWeight;
        final /* synthetic */ PostStar this$0;

        public HandlePopListener(D state, N popLabel, D targetState, W ruleWeight) {
            this.this$0 = var1_1;
            super(state);
            this.targetState = targetState;
            this.popLabel = popLabel;
            this.ruleWeight = ruleWeight;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
            if (t.getLabel().accepts((Location)this.popLabel) || this.popLabel.accepts((Location)t.getLabel())) {
                if (this.this$0.fa.isGeneratedState(t.getTarget())) {
                    if (this.popLabel instanceof Empty) {
                        throw new RuntimeException("IllegalState");
                    }
                    Weight newWeight = ((Weight)weight).extendWith((Weight)this.ruleWeight);
                    this.this$0.update(new Transition(this.targetState, this.this$0.fa.epsilon(), t.getTarget()), newWeight);
                    this.this$0.fa.registerListener(new UpdateTransitivePopListener(this.this$0, this.targetState, (Location)t.getLabel(), (State)t.getTarget(), newWeight));
                    aut.registerSummaryEdge(t);
                } else if (this.this$0.fa.isUnbalancedState(t.getTarget())) {
                    if (this.popLabel instanceof Empty) {
                        throw new RuntimeException("IllegalState");
                    }
                    Weight newWeight = ((Weight)weight).extendWith((Weight)this.ruleWeight);
                    this.this$0.fa.unbalancedPop(this.targetState, t, weight);
                }
            }
            if (t.getLabel() instanceof Empty) {
                this.this$0.fa.registerListener(new HandlePopListener(this.this$0, (State)t.getTarget(), this.popLabel, this.targetState, this.ruleWeight));
            }
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W weight, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.popLabel == null ? 0 : this.popLabel.hashCode());
            result = 31 * result + (this.ruleWeight == null ? 0 : this.ruleWeight.hashCode());
            result = 31 * result + (this.targetState == null ? 0 : this.targetState.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlePopListener other = (HandlePopListener)obj;
            if (this.popLabel == null ? other.popLabel != null : !this.popLabel.equals(other.popLabel)) {
                return false;
            }
            if (this.ruleWeight == null ? other.ruleWeight != null : !this.ruleWeight.equals(other.ruleWeight)) {
                return false;
            }
            return !(this.targetState == null ? other.targetState != null : !this.targetState.equals(other.targetState));
        }
    }

    private static class UpdateTransitivePopListener
    extends WPAStateListener<N, D, W> {
        private D start;
        private N label;
        private W newWeight;
        final /* synthetic */ PostStar this$0;

        public UpdateTransitivePopListener(D start, N label, D target, W newWeight) {
            this.this$0 = var1_1;
            super(target);
            this.start = start;
            this.label = label;
            this.newWeight = newWeight;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
            Weight extendWith = ((Weight)w).extendWith((Weight)this.newWeight);
            this.this$0.update(new Transition<Object, Object>(this.start, t.getLabel(), t.getTarget()), extendWith);
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
            result = 31 * result + (this.newWeight == null ? 0 : this.newWeight.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateTransitivePopListener other = (UpdateTransitivePopListener)obj;
            if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
                return false;
            }
            if (this.newWeight == null ? other.newWeight != null : !this.newWeight.equals(other.newWeight)) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
    }

    private class PostStarUpdateListener
    implements WPDSUpdateListener<N, D, W> {
        private WeightedPAutomaton<N, D, W> aut;

        public PostStarUpdateListener(WeightedPAutomaton<N, D, W> fa) {
            this.aut = fa;
        }

        @Override
        public void onRuleAdded(Rule<N, D, W> rule) {
            if (rule instanceof NormalRule) {
                PostStar.this.fa.registerListener(new HandleNormalListener((NormalRule)rule));
            } else if (rule instanceof PushRule) {
                PostStar.this.fa.registerListener(new HandlePushListener((PushRule)rule));
            } else if (rule instanceof PopRule) {
                PostStar.this.fa.registerListener(new HandlePopListener(PostStar.this, rule.getS1(), rule.getL1(), rule.getS2(), rule.getWeight()));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aut == null ? 0 : this.aut.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostStarUpdateListener other = (PostStarUpdateListener)obj;
            return !(this.aut == null ? other.aut != null : !this.aut.equals(other.aut));
        }
    }
}

