/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import wpds.impl.Configuration;
import wpds.impl.Weight;
import wpds.interfaces.Location;
import wpds.interfaces.State;

public abstract class Rule<N extends Location, D extends State, W extends Weight> {
    protected N l1;
    protected D s1;
    protected N l2;
    protected D s2;
    protected W w;

    public Rule(D s1, N l1, D s2, N l2, W w) {
        this.l1 = l1;
        this.s1 = s1;
        this.l2 = l2;
        this.s2 = s2;
        this.w = w;
    }

    public Configuration<N, D> getStartConfig() {
        return new Configuration<N, D>(this.l1, this.s1);
    }

    public Configuration<N, D> getTargetConfig() {
        return new Configuration<N, D>(this.l2, this.s2);
    }

    public N getL1() {
        return this.l1;
    }

    public N getL2() {
        return this.l2;
    }

    public D getS1() {
        return this.s1;
    }

    public D getS2() {
        return this.s2;
    }

    public void setS1(D s1) {
        this.s1 = s1;
    }

    public W getWeight() {
        return this.w;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.l1 == null ? 0 : this.l1.hashCode());
        result = 31 * result + (this.l2 == null ? 0 : this.l2.hashCode());
        result = 31 * result + (this.s1 == null ? 0 : this.s1.hashCode());
        result = 31 * result + (this.s2 == null ? 0 : this.s2.hashCode());
        result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.l1 == null ? other.l1 != null : !this.l1.equals(other.l1)) {
            return false;
        }
        if (this.l2 == null ? other.l2 != null : !this.l2.equals(other.l2)) {
            return false;
        }
        if (this.s1 == null ? other.s1 != null : !this.s1.equals(other.s1)) {
            return false;
        }
        if (this.s2 == null ? other.s2 != null : !this.s2.equals(other.s2)) {
            return false;
        }
        return !(this.w == null ? other.w != null : !this.w.equals(other.w));
    }
}

