/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PostStar;
import wpds.impl.PreStar;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.IPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPDSUpdateListener;
import wpds.wildcard.Wildcard;

public class WeightedPushdownSystem<N extends Location, D extends State, W extends Weight>
implements IPushdownSystem<N, D, W> {
    protected final Set<PushRule<N, D, W>> pushRules = Sets.newHashSet();
    protected final Set<PopRule<N, D, W>> popRules = Sets.newHashSet();
    protected final Set<NormalRule<N, D, W>> normalRules = Sets.newHashSet();
    protected final Set<WPDSUpdateListener<N, D, W>> listeners = Sets.newHashSet();

    @Override
    public boolean addRule(Rule<N, D, W> rule) {
        if (this.addRuleInternal(rule)) {
            for (WPDSUpdateListener l : Lists.newArrayList(this.listeners)) {
                l.onRuleAdded(rule);
            }
            return true;
        }
        return false;
    }

    private boolean addRuleInternal(Rule<N, D, W> rule) {
        if (rule instanceof PushRule) {
            return this.pushRules.add((PushRule)rule);
        }
        if (rule instanceof PopRule) {
            return this.popRules.add((PopRule)rule);
        }
        if (rule instanceof NormalRule) {
            return this.normalRules.add((NormalRule)rule);
        }
        throw new RuntimeException("Try to add a rule of wrong type");
    }

    @Override
    public void registerUpdateListener(WPDSUpdateListener<N, D, W> listener) {
        if (!this.listeners.add(listener)) {
            return;
        }
        for (Rule<N, D, W> r : this.getAllRules()) {
            listener.onRuleAdded(r);
        }
    }

    @Override
    public Set<NormalRule<N, D, W>> getNormalRules() {
        return this.normalRules;
    }

    @Override
    public Set<PopRule<N, D, W>> getPopRules() {
        return this.popRules;
    }

    @Override
    public Set<PushRule<N, D, W>> getPushRules() {
        return this.pushRules;
    }

    @Override
    public Set<Rule<N, D, W>> getAllRules() {
        HashSet rules = Sets.newHashSet();
        rules.addAll(this.normalRules);
        rules.addAll(this.popRules);
        rules.addAll(this.pushRules);
        return rules;
    }

    @Override
    public Set<Rule<N, D, W>> getRulesStarting(D start, N string) {
        HashSet<Rule<N, D, W>> result = new HashSet<Rule<N, D, W>>();
        this.getRulesStartingWithinSet(start, string, this.popRules, result);
        this.getRulesStartingWithinSet(start, string, this.normalRules, result);
        this.getRulesStartingWithinSet(start, string, this.pushRules, result);
        return result;
    }

    private void getRulesStartingWithinSet(D start, N string, Set<? extends Rule<N, D, W>> rules, Set<Rule<N, D, W>> res) {
        for (Rule<N, D, W> r : rules) {
            if (r.getS1().equals(start) && (r.getL1().equals(string) || r.getL1() instanceof Wildcard)) {
                res.add(r);
            }
            if (!(string instanceof Wildcard) || !r.getS1().equals(start)) continue;
            res.add(r);
        }
    }

    @Override
    public Set<NormalRule<N, D, W>> getNormalRulesEnding(D start, N string) {
        Set<NormalRule<N, D, W>> allRules = this.getNormalRules();
        HashSet<NormalRule<N, D, W>> result = new HashSet<NormalRule<N, D, W>>();
        for (NormalRule<N, D, W> r : allRules) {
            if (!r.getS2().equals(start) || !r.getL2().equals(string)) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public Set<PushRule<N, D, W>> getPushRulesEnding(D start, N string) {
        Set<PushRule<N, D, W>> allRules = this.getPushRules();
        HashSet<PushRule<N, D, W>> result = new HashSet<PushRule<N, D, W>>();
        for (PushRule<N, D, W> r : allRules) {
            if (!r.getS2().equals(start) || !r.getL2().equals(string)) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public Set<D> getStates() {
        HashSet states = Sets.newHashSet();
        for (Rule<N, D, W> r : this.getAllRules()) {
            states.add(r.getS1());
            states.add(r.getS2());
        }
        return states;
    }

    @Override
    public void poststar(WeightedPAutomaton<N, D, W> initialAutomaton, final NestedWeightedPAutomatons<N, D, W> summaries) {
        new PostStar<N, D, W>(){

            @Override
            public void putSummaryAutomaton(D target, WeightedPAutomaton<N, D, W> aut) {
                summaries.putSummaryAutomaton(target, aut);
            }

            @Override
            public WeightedPAutomaton<N, D, W> getSummaryAutomaton(D target) {
                return summaries.getSummaryAutomaton(target);
            }
        }.poststar(this, initialAutomaton);
    }

    @Override
    public void poststar(final WeightedPAutomaton<N, D, W> initialAutomaton) {
        new PostStar<N, D, W>(){

            @Override
            public void putSummaryAutomaton(D target, WeightedPAutomaton<N, D, W> aut) {
            }

            @Override
            public WeightedPAutomaton<N, D, W> getSummaryAutomaton(D target) {
                return initialAutomaton;
            }
        }.poststar(this, initialAutomaton);
    }

    @Override
    public void prestar(WeightedPAutomaton<N, D, W> initialAutomaton) {
        new PreStar<N, D, W>().prestar(this, initialAutomaton);
    }

    public String toString() {
        String s = "WPDS (#Rules: " + this.getAllRules().size() + ")\n";
        s = s + "\tNormalRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.normalRules);
        s = s + "\n";
        s = s + "\tPopRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.popRules);
        s = s + "\n";
        s = s + "\tPushRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.pushRules);
        return s;
    }

    @Override
    public void unregisterAllListeners() {
        this.listeners.clear();
    }
}

