/*
 * Decompiled with CFR 0.152.
 */
package wpds.wildcard;

import java.util.HashSet;
import java.util.Set;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PushRule;
import wpds.impl.PushdownSystem;
import wpds.impl.Rule;
import wpds.impl.UNormalRule;
import wpds.impl.UPopRule;
import wpds.impl.UPushRule;
import wpds.impl.Weight;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.wildcard.Wildcard;

public abstract class WildcardPushdownSystem<N extends Location, D extends State>
extends PushdownSystem<N, D> {
    @Override
    public Set<Rule<N, D, Weight.NoWeight>> getRulesStarting(D start, N string) {
        assert (!string.equals(this.anyTransition()));
        Set allRules = this.getAllRules();
        HashSet<Rule<N, D, Weight.NoWeight>> result = new HashSet<Rule<N, D, Weight.NoWeight>>();
        for (Rule r : allRules) {
            if (r.getS1().equals(start) && r.getL1().equals(string)) {
                result.add(r);
            }
            if (this.anyTransition() == null || !r.getS1().equals(start) || !r.getL1().equals(this.anyTransition())) continue;
            if (r instanceof NormalRule) {
                result.add(new UNormalRule(r.getS1(), string, r.getS2(), string));
                continue;
            }
            if (r instanceof PopRule) {
                result.add(new UPopRule(r.getS1(), string, r.getS2()));
                continue;
            }
            if (!(r instanceof PushRule)) continue;
            result.add(new UPushRule(r.getS1(), string, r.getS2(), r.getL2(), string));
        }
        return result;
    }

    @Override
    public Set<NormalRule<N, D, Weight.NoWeight>> getNormalRulesEnding(D start, N string) {
        assert (!string.equals(this.anyTransition()));
        Set allRules = this.getNormalRules();
        HashSet<NormalRule<N, D, Weight.NoWeight>> result = new HashSet<NormalRule<N, D, Weight.NoWeight>>();
        for (NormalRule r : allRules) {
            if (r.getS2().equals(start) && r.getL2().equals(string)) {
                result.add(r);
            }
            if (!r.getS2().equals(start) || !r.getL2().equals(this.anyTransition())) continue;
            result.add(new UNormalRule(r.getS1(), string, r.getS2(), string));
        }
        return result;
    }

    @Override
    public Set<PushRule<N, D, Weight.NoWeight>> getPushRulesEnding(D start, N string) {
        assert (!string.equals(this.anyTransition()));
        Set allRules = this.getPushRules();
        HashSet<PushRule<N, D, Weight.NoWeight>> result = new HashSet<PushRule<N, D, Weight.NoWeight>>();
        for (PushRule r : allRules) {
            if (!r.getS2().equals(start) || !r.getL2().equals(string)) continue;
            result.add(r);
        }
        return result;
    }

    public abstract Wildcard anyTransition();
}

