/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pathexpression.Edge;
import pathexpression.IRegEx;
import pathexpression.LabeledGraph;
import pathexpression.PathExpressionComputer;
import pathexpression.RegEx;
import wpds.impl.ConnectPushListener;
import wpds.impl.NestedAutomatonListener;
import wpds.impl.Transition;
import wpds.impl.UnbalancedPopListener;
import wpds.impl.Weight;
import wpds.interfaces.ForwardDFSEpsilonVisitor;
import wpds.interfaces.ForwardDFSVisitor;
import wpds.interfaces.Location;
import wpds.interfaces.ReachabilityListener;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class WeightedPAutomaton<N extends Location, D extends State, W extends Weight>
implements LabeledGraph<D, N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightedPAutomaton.class);
    private Map<Transition<N, D>, W> transitionToWeights = new HashMap<Transition<N, D>, W>();
    protected Set<Transition<N, D>> transitions = Sets.newHashSet();
    protected Set<D> finalState = Sets.newHashSet();
    protected Multimap<D, D> initialStatesToSource = HashMultimap.create();
    protected Set<D> states = Sets.newHashSet();
    private final Multimap<D, Transition<N, D>> transitionsOutOf = HashMultimap.create();
    private final Multimap<D, Transition<N, D>> transitionsInto = HashMultimap.create();
    private Set<WPAUpdateListener<N, D, W>> listeners = Sets.newHashSet();
    private Multimap<D, WPAStateListener<N, D, W>> stateListeners = HashMultimap.create();
    private Map<D, ForwardDFSVisitor<N, D, W>> stateToDFS = Maps.newHashMap();
    private Map<D, ForwardDFSVisitor<N, D, W>> stateToEpsilonDFS = Maps.newHashMap();
    private Set<WeightedPAutomaton<N, D, W>> nestedAutomatons = Sets.newHashSet();
    private Set<NestedAutomatonListener<N, D, W>> nestedAutomataListeners = Sets.newHashSet();
    private Map<D, ReachabilityListener<N, D>> stateToEpsilonReachabilityListener = Maps.newHashMap();
    private Map<D, ReachabilityListener<N, D>> stateToReachabilityListener = Maps.newHashMap();
    private Set<ReturnSiteWithWeights> connectedPushes = Sets.newHashSet();
    private Set<ConnectPushListener<N, D, W>> conntectedPushListeners = Sets.newHashSet();
    private Set<UnbalancedPopListener<N, D, W>> unbalancedPopListeners = Sets.newHashSet();
    private Map<UnbalancedPopEntry, W> unbalancedPops = Maps.newHashMap();
    private Map<Transition<N, D>, W> transitionsToFinalWeights = Maps.newHashMap();
    private ForwardDFSVisitor<N, D, W> dfsVisitor;
    private ForwardDFSVisitor<N, D, W> dfsEpsVisitor;
    public int failedAdditions;
    public int failedDirectAdditions;
    private WeightedPAutomaton<N, D, W> initialAutomaton;
    private PathExpressionComputer<D, N> pathExpressionComputer;
    private int lastStates = 0;
    private Stopwatch watch = Stopwatch.createUnstarted();
    private Map<D, Integer> stateToDistanceToInitial = Maps.newHashMap();
    private Map<D, Integer> stateToUnbalancedDistance = Maps.newHashMap();
    private final Map<D, Transition<N, D>> stateCreatingTransition = Maps.newHashMap();
    private static final boolean SUMMARIZE = false;
    private static int count = 0;
    private Set<Transition<N, D>> summaryEdges = Sets.newHashSet();
    private Set<SummaryListener<N, D>> summaryEdgeListener = Sets.newHashSet();

    public abstract D createState(D var1, N var2);

    public abstract boolean isGeneratedState(D var1);

    public Collection<Transition<N, D>> getTransitions() {
        return Lists.newArrayList(this.transitions);
    }

    public boolean addTransition(Transition<N, D> trans) {
        boolean addWeightForTransition = this.addWeightForTransition(trans, this.getOne());
        if (!addWeightForTransition) {
            ++this.failedDirectAdditions;
        }
        return addWeightForTransition;
    }

    public Set<D> getFinalState() {
        return this.finalState;
    }

    public String toString() {
        Object s = "PAutomaton\n";
        s = (String)s + "\tInitialStates:" + this.initialStatesToSource.keySet() + "\n";
        s = (String)s + "\tFinalStates:" + this.finalState + "\n";
        s = (String)s + "\tWeightToTransitions:\n\t\t";
        s = (String)s + Joiner.on((String)"\n\t\t").join(this.transitionToWeights.entrySet());
        for (WeightedPAutomaton<N, D, W> nested : this.nestedAutomatons) {
            s = (String)s + "\n";
            s = (String)s + nested.toString();
        }
        return s;
    }

    private String wrapIfInitialOrFinalState(D s) {
        return this.initialStatesToSource.containsKey(s) ? "ENTRY: " + this.wrapFinalState(s) : this.wrapFinalState(s);
    }

    private String wrapFinalState(D s) {
        return this.finalState.contains(s) ? "TO: " + s : s.toString();
    }

    public String toDotString() {
        return this.toDotString(Sets.newHashSet());
    }

    private String toDotString(Set<WeightedPAutomaton<N, D, W>> visited) {
        if (!visited.add(this)) {
            return "NESTED loop: " + this.getInitialStates();
        }
        Object s = "digraph {\n";
        TreeSet<CallSite> trans = new TreeSet<CallSite>();
        ArrayList summaryIdentifier = Lists.newArrayList();
        HashSet removableTrans = Sets.newHashSet();
        for (State state : this.states) {
            Collection collection = this.transitionsOutOf.get((Object)state);
            for (State target : this.states) {
                LinkedList labels = Lists.newLinkedList();
                for (Transition t : collection) {
                    if (removableTrans.contains(t) || !t.getTarget().equals(target)) continue;
                    labels.add(this.escapeQuotes(t.getLabel().toString()) + " W: " + this.transitionToWeights.get(t));
                }
                if (labels.isEmpty()) continue;
                String v = "\t\"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(state)) + "\"";
                v = v + " -> \"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(target)) + "\"";
                v = v + "[label=\"" + Joiner.on((String)"\\n").join((Iterable)labels) + "\"];\n";
                trans.add((CallSite)((Object)v));
            }
        }
        s = (String)s + Joiner.on((String)"").join(trans);
        s = (String)s + "}\n";
        s = (String)s + "Transitions: " + this.transitions.size() + " Nested: " + this.nestedAutomatons.size() + "\n";
        for (WeightedPAutomaton weightedPAutomaton : this.nestedAutomatons) {
            s = (String)s + "NESTED -> \n";
            s = (String)s + weightedPAutomaton.toDotString(visited);
        }
        s = (String)s + "End nesting\n";
        return s;
    }

    public Set<D> getInitialStates() {
        return this.initialStatesToSource.keySet();
    }

    private String escapeQuotes(String string) {
        return string.replace("\"", "");
    }

    /*
     * WARNING - void declaration
     */
    public String toLabelGroupedDotString() {
        HashBasedTable groupedByTargetAndLabel = HashBasedTable.create();
        for (Transition<N, D> t : this.transitions) {
            void var4_4;
            Collection collection = (Collection)groupedByTargetAndLabel.get(t.getTarget(), t.getLabel());
            if (collection == null) {
                HashSet hashSet = Sets.newHashSet();
            }
            var4_4.add(t.getStart());
            groupedByTargetAndLabel.put(t.getTarget(), t.getLabel(), (Object)var4_4);
        }
        Object s = "digraph {\n";
        for (State state : groupedByTargetAndLabel.rowKeySet()) {
            for (Location label : groupedByTargetAndLabel.columnKeySet()) {
                Collection source = (Collection)groupedByTargetAndLabel.get((Object)state, (Object)label);
                if (source == null) continue;
                s = (String)s + "\t\"" + Joiner.on((String)"\\n").join((Iterable)source) + "\"";
                s = (String)s + " -> \"" + this.wrapIfInitialOrFinalState(state) + "\"";
                s = (String)s + "[label=\"" + label + "\"];\n";
            }
        }
        s = (String)s + "}\n";
        s = (String)s + "Transitions: " + this.transitions.size() + "\n";
        for (WeightedPAutomaton weightedPAutomaton : this.nestedAutomatons) {
            s = (String)s + "NESTED -> \n";
            s = (String)s + weightedPAutomaton.toDotString();
        }
        return s;
    }

    public abstract N epsilon();

    public IRegEx<N> extractLanguage(D from) {
        PathExpressionComputer expr = new PathExpressionComputer((LabeledGraph)this);
        IRegEx res = null;
        for (State finalState : this.getFinalState()) {
            IRegEx regEx = expr.getExpressionBetween(from, (Object)finalState);
            if (res == null) {
                res = regEx;
                continue;
            }
            res = RegEx.union((IRegEx)res, (IRegEx)regEx);
        }
        if (res == null) {
            return new RegEx.EmptySet();
        }
        return res;
    }

    public IRegEx<N> extractLanguage(D from, D to) {
        PathExpressionComputer expr = new PathExpressionComputer((LabeledGraph)this);
        IRegEx res = expr.getExpressionBetween(from, to);
        if (res == null) {
            return new RegEx.EmptySet();
        }
        return res;
    }

    public Set<D> getStates() {
        return this.states;
    }

    public Set<Edge<D, N>> getEdges() {
        HashSet trans = Sets.newHashSet();
        for (Edge edge : this.transitions) {
            if (((Location)edge.getLabel()).equals(this.epsilon())) continue;
            trans.add(new Transition<Location, State>((State)edge.getTarget(), (Location)edge.getLabel(), (State)edge.getStart()));
        }
        return trans;
    }

    public Set<D> getNodes() {
        return this.getStates();
    }

    public boolean addWeightForTransition(Transition<N, D> trans, W weight) {
        W newWeight;
        if (weight == null) {
            throw new IllegalArgumentException("Weight must not be null!");
        }
        if (trans.getStart().equals(trans.getTarget()) && trans.getLabel().equals(this.epsilon())) {
            ++this.failedAdditions;
            return false;
        }
        int distanceToInitial = this.computeDistance(trans);
        if (this.hasMaxDepth() && distanceToInitial > this.getMaxDepth()) {
            return false;
        }
        if (!this.watch.isRunning()) {
            this.watch.start();
        }
        this.transitionsOutOf.get(trans.getStart()).add(trans);
        this.transitionsInto.get(trans.getTarget()).add(trans);
        if (this.states.add(trans.getTarget())) {
            this.stateCreatingTransition.put(trans.getTarget(), trans);
        }
        this.states.add(trans.getStart());
        boolean added = this.transitions.add(trans);
        Weight oldWeight = (Weight)this.transitionToWeights.get(trans);
        Object object = newWeight = oldWeight == null ? weight : oldWeight.combineWith((Weight)weight);
        if (!newWeight.equals(oldWeight)) {
            this.transitionToWeights.put(trans, newWeight);
            for (Object l : Lists.newArrayList(this.listeners)) {
                l.onWeightAdded(trans, newWeight, this);
            }
            for (Object l : Lists.newArrayList((Iterable)this.stateListeners.get(trans.getStart()))) {
                ((WPAStateListener)l).onOutTransitionAdded(trans, newWeight, this);
            }
            for (Object l : Lists.newArrayList((Iterable)this.stateListeners.get(trans.getTarget()))) {
                ((WPAStateListener)l).onInTransitionAdded(trans, newWeight, this);
            }
            added = true;
        }
        if (this.watch.isRunning()) {
            this.watch.stop();
        }
        if (!added) {
            ++this.failedAdditions;
        }
        return added;
    }

    protected int computeDistance(Transition<N, D> trans) {
        Integer distance;
        if (this.isUnbalancedState(trans.getTarget())) {
            distance = 0;
        } else {
            distance = this.stateToDistanceToInitial.get(trans.getTarget());
            if (distance == null) {
                return -1;
            }
        }
        Integer integer = distance = Integer.valueOf(distance + 1);
        Integer currDistance = this.stateToDistanceToInitial.get(trans.getStart());
        if (currDistance == null || integer < currDistance) {
            this.stateToDistanceToInitial.put(trans.getStart(), integer);
            return integer;
        }
        return currDistance;
    }

    public W getWeightFor(Transition<N, D> trans) {
        return (W)((Weight)this.transitionToWeights.get(trans));
    }

    public void registerListener(WPAUpdateListener<N, D, W> listener) {
        if (!this.listeners.add(listener)) {
            return;
        }
        for (Map.Entry transAndWeight : Lists.newArrayList(this.transitionToWeights.entrySet())) {
            listener.onWeightAdded((Transition)transAndWeight.getKey(), (Weight)transAndWeight.getValue(), this);
        }
        for (WeightedPAutomaton nested : Lists.newArrayList(this.nestedAutomatons)) {
            nested.registerListener(listener);
        }
    }

    private void increaseListenerCount(WPAStateListener<N, D, W> l) {
        if (++count % 100000 == 0) {
            this.onManyStateListenerRegister();
        }
    }

    public void onManyStateListenerRegister() {
    }

    public void registerListener(WPAStateListener<N, D, W> l) {
        if (!this.stateListeners.put(l.getState(), l)) {
            return;
        }
        this.increaseListenerCount(l);
        for (Transition t : Lists.newArrayList((Iterable)this.transitionsOutOf.get(l.getState()))) {
            l.onOutTransitionAdded(t, (Weight)this.transitionToWeights.get(t), this);
        }
        for (Transition t : Lists.newArrayList((Iterable)this.transitionsInto.get(l.getState()))) {
            l.onInTransitionAdded(t, (Weight)this.transitionToWeights.get(t), this);
        }
        for (WeightedPAutomaton nested : Lists.newArrayList(this.nestedAutomatons)) {
            nested.registerListener(l);
        }
    }

    public void addFinalState(D state) {
        this.finalState.add(state);
    }

    public void registerDFSListener(D state, ReachabilityListener<N, D> l) {
        this.stateToReachabilityListener.put(state, l);
        if (this.dfsVisitor == null) {
            this.dfsVisitor = new ForwardDFSVisitor(this);
            this.registerListener(this.dfsVisitor);
        }
        this.dfsVisitor.registerListener(state, l);
    }

    protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToDFS() {
        return this.stateToDFS;
    }

    public void registerDFSEpsilonListener(D state, ReachabilityListener<N, D> l) {
        this.stateToEpsilonReachabilityListener.put(state, l);
        if (this.dfsEpsVisitor == null) {
            this.dfsEpsVisitor = new ForwardDFSEpsilonVisitor(this);
            this.registerListener(this.dfsEpsVisitor);
        }
        for (WeightedPAutomaton nested : Lists.newLinkedList(this.nestedAutomatons)) {
            nested.registerDFSEpsilonListener(state, l);
        }
        this.dfsEpsVisitor.registerListener(state, l);
    }

    protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToEpsilonDFS() {
        return this.stateToEpsilonDFS;
    }

    public abstract W getOne();

    public WeightedPAutomaton<N, D, W> createNestedAutomaton(D initialState) {
        WeightedPAutomaton nested = new WeightedPAutomaton<N, D, W>(){

            @Override
            public D createState(D d, N loc) {
                return WeightedPAutomaton.this.createState(d, loc);
            }

            @Override
            public N epsilon() {
                return WeightedPAutomaton.this.epsilon();
            }

            @Override
            public W getOne() {
                return WeightedPAutomaton.this.getOne();
            }

            @Override
            public boolean isGeneratedState(D d) {
                return WeightedPAutomaton.this.isGeneratedState(d);
            }

            @Override
            protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToDFS() {
                return WeightedPAutomaton.this.stateToDFS;
            }

            @Override
            protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToEpsilonDFS() {
                return WeightedPAutomaton.this.stateToEpsilonDFS;
            }

            @Override
            public boolean nested() {
                return true;
            }

            @Override
            public String toString() {
                return "NESTED: \n" + super.toString();
            }
        };
        this.addNestedAutomaton(nested);
        return nested;
    }

    public void registerUnbalancedPopListener(UnbalancedPopListener<N, D, W> l) {
        if (this.unbalancedPopListeners.add(l)) {
            for (Map.Entry e : Lists.newArrayList(this.unbalancedPops.entrySet())) {
                UnbalancedPopEntry t = (UnbalancedPopEntry)e.getKey();
                l.unbalancedPop(t.targetState, t.trans, (Weight)e.getValue());
            }
        }
    }

    public void unbalancedPop(D targetState, Transition<N, D> trans, W weight) {
        W newVal;
        UnbalancedPopEntry t = new UnbalancedPopEntry(this, targetState, trans);
        Weight oldVal = (Weight)this.unbalancedPops.get(t);
        Object object = newVal = oldVal == null ? weight : oldVal.combineWith((Weight)weight);
        if (!newVal.equals(oldVal)) {
            this.unbalancedPops.put(t, newVal);
            for (UnbalancedPopListener l : Lists.newArrayList(this.unbalancedPopListeners)) {
                l.unbalancedPop(targetState, trans, newVal);
            }
        }
    }

    public void registerSummaryEdge(Transition<N, D> t) {
        if (this.summaryEdges.add(t)) {
            for (SummaryListener l : Lists.newArrayList(this.summaryEdgeListener)) {
                l.addedSummary(t);
            }
        }
    }

    public void addSummaryListener(SummaryListener<N, D> l) {
        if (this.summaryEdgeListener.add(l)) {
            for (Transition edge : Lists.newArrayList(this.summaryEdges)) {
                l.addedSummary(edge);
            }
            for (WeightedPAutomaton nested : Lists.newArrayList(this.nestedAutomatons)) {
                nested.addSummaryListener(l);
            }
        }
    }

    public Map<Transition<N, D>, W> getTransitionsToFinalWeights() {
        LOGGER.trace("Start computing final weights");
        Stopwatch w = Stopwatch.createStarted();
        for (State s : this.initialStatesToSource.keySet()) {
            this.registerListener(new ValueComputationListener(this, s, this.getOne()));
        }
        LOGGER.trace("Finished computing final weights in {}", (Object)w);
        return this.transitionsToFinalWeights;
    }

    public boolean nested() {
        return false;
    }

    public void addNestedAutomaton(WeightedPAutomaton<N, D, W> nested) {
        if (!this.nestedAutomatons.add(nested)) {
            return;
        }
        for (Object e : Lists.newArrayList((Iterable)this.stateListeners.values())) {
            nested.registerListener((WPAStateListener<N, State, W>)e);
        }
        for (Object e : Lists.newArrayList(this.listeners)) {
            nested.registerListener((WPAUpdateListener<N, State, W>)e);
        }
        for (Object e : Lists.newArrayList(this.summaryEdgeListener)) {
            nested.addSummaryListener((SummaryListener<N, State>)e);
        }
        for (Object e : Lists.newArrayList(this.unbalancedPopListeners)) {
            nested.registerUnbalancedPopListener((UnbalancedPopListener<N, State, W>)e);
        }
        for (Object e : Lists.newArrayList(this.stateToEpsilonReachabilityListener.entrySet())) {
            nested.registerDFSEpsilonListener((State)e.getKey(), (ReachabilityListener)e.getValue());
        }
        for (Object e : Lists.newArrayList(this.stateToReachabilityListener.entrySet())) {
            nested.registerDFSListener((State)e.getKey(), (ReachabilityListener)e.getValue());
        }
        for (Object e : Lists.newArrayList(this.stateToReachabilityListener.entrySet())) {
            nested.registerDFSListener((State)e.getKey(), (ReachabilityListener)e.getValue());
        }
        for (Object e : Lists.newArrayList(this.nestedAutomataListeners)) {
            e.nestedAutomaton(this, nested);
            nested.registerNestedAutomatonListener((NestedAutomatonListener<N, State, W>)e);
        }
    }

    public void registerNestedAutomatonListener(NestedAutomatonListener<N, D, W> l) {
        if (!this.nestedAutomataListeners.add(l)) {
            return;
        }
        for (WeightedPAutomaton nested : Lists.newArrayList(this.nestedAutomatons)) {
            l.nestedAutomaton(this, nested);
        }
    }

    public void setInitialAutomaton(WeightedPAutomaton<N, D, W> aut) {
        this.initialAutomaton = aut;
    }

    public boolean isInitialAutomaton(WeightedPAutomaton<N, D, W> aut) {
        return this.initialAutomaton.equals(aut);
    }

    public IRegEx<N> toRegEx(D start, D end) {
        if (this.lastStates < this.states.size()) {
            this.pathExpressionComputer = new PathExpressionComputer((LabeledGraph)this);
            this.lastStates = this.states.size();
        }
        return RegEx.reverse((IRegEx)this.pathExpressionComputer.getExpressionBetween(end, start));
    }

    public boolean containsLoop() {
        HashSet visited = Sets.newHashSet();
        LinkedList worklist = Lists.newLinkedList();
        worklist.addAll(this.initialStatesToSource.keySet());
        while (!worklist.isEmpty()) {
            State pop = (State)worklist.pop();
            visited.add(pop);
            Collection inTrans = this.transitionsInto.get((Object)pop);
            for (Transition t : inTrans) {
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(t.getStart())) continue;
                if (visited.contains(t.getStart())) {
                    return true;
                }
                worklist.add(t.getStart());
            }
        }
        return false;
    }

    public Set<N> getLongestPath() {
        LinkedList worklist = Lists.newLinkedList();
        worklist.addAll(this.initialStatesToSource.keySet());
        HashMap pathReachingD = Maps.newHashMap();
        while (!worklist.isEmpty()) {
            State pop = (State)worklist.pop();
            Set<N> atCurr = this.getOrCreate(pathReachingD, pop);
            Collection inTrans = this.transitionsInto.get((Object)pop);
            for (Transition t : inTrans) {
                boolean addAll;
                Object next;
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(next = t.getStart()) || next.equals(pop)) continue;
                Set<N> atNext = this.getOrCreate(pathReachingD, next);
                HashSet newAtCurr = Sets.newHashSet(atCurr);
                if (!newAtCurr.add(t.getLabel()) || !(addAll = atNext.addAll(newAtCurr))) continue;
                worklist.add(next);
            }
        }
        Set longest = Sets.newHashSet();
        for (Set l : pathReachingD.values()) {
            if (longest.size() >= l.size()) continue;
            longest = l;
        }
        return longest;
    }

    private Set<N> getOrCreate(Map<D, Set<N>> pathReachingD, D pop) {
        HashSet collection = pathReachingD.get(pop);
        if (collection == null) {
            collection = Sets.newHashSet();
            pathReachingD.put(pop, collection);
        }
        return collection;
    }

    public boolean isUnbalancedState(D target) {
        return this.initialStatesToSource.containsKey(target);
    }

    public boolean addUnbalancedState(D state, D parent) {
        Integer distance = 0;
        HashSet parents = Sets.newHashSet();
        if (!this.initialStatesToSource.containsKey(parent)) {
            distance = this.stateToUnbalancedDistance.get(parent);
            parents.add(parent);
        } else {
            parents.addAll(this.initialStatesToSource.get(parent));
        }
        Integer newDistance = distance = Integer.valueOf(distance + 1);
        this.stateToUnbalancedDistance.put(state, newDistance);
        if (this.getMaxUnbalancedDepth() > 0 && newDistance > this.getMaxUnbalancedDepth()) {
            return false;
        }
        this.initialStatesToSource.putAll(state, (Iterable)parents);
        return true;
    }

    public boolean addInitialState(D state) {
        return this.initialStatesToSource.put(state, state);
    }

    public void unregisterAllListeners() {
        this.conntectedPushListeners.clear();
        this.nestedAutomataListeners.clear();
        this.stateListeners.clear();
        this.listeners.clear();
        this.stateToEpsilonReachabilityListener.clear();
        this.stateToReachabilityListener.clear();
        this.summaryEdgeListener.clear();
        this.unbalancedPopListeners.clear();
    }

    public Stopwatch getWatch() {
        return this.watch;
    }

    public boolean hasMaxDepth() {
        return this.getMaxDepth() > 0;
    }

    public int getMaxDepth() {
        return -1;
    }

    public int getMaxUnbalancedDepth() {
        return -1;
    }

    public Collection<D> getUnbalancedStartOf(D target) {
        return this.initialStatesToSource.get(target);
    }

    private static class ValueComputationListener
    extends WPAStateListener<N, D, W> {
        private W weight;
        final /* synthetic */ WeightedPAutomaton this$0;

        public ValueComputationListener(D state, W weight) {
            this.this$0 = var1_1;
            super(state);
            this.weight = weight;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
            Weight newWeight = ((Weight)this.weight).extendWith((Weight)w);
            Weight weightAtTarget = (Weight)this.this$0.transitionsToFinalWeights.get(t);
            Weight newVal = weightAtTarget == null ? newWeight : weightAtTarget.combineWith(newWeight);
            this.this$0.transitionsToFinalWeights.put(t, newVal);
            if (this.this$0.isGeneratedState(t.getStart())) {
                this.this$0.registerListener(new ValueComputationListener(this.this$0, (State)t.getStart(), newVal));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueComputationListener other = (ValueComputationListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }

    private static class ReturnSiteWithWeights {
        private final N returnSite;
        private final W returnedWeight;
        private final D returnedFact;
        final /* synthetic */ WeightedPAutomaton this$0;

        public ReturnSiteWithWeights(N returnSite, D returnedFact, W returnedWeight) {
            this.this$0 = var1_1;
            this.returnSite = returnSite;
            this.returnedFact = returnedFact;
            this.returnedWeight = returnedWeight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.returnSite == null ? 0 : this.returnSite.hashCode());
            result = 31 * result + (this.returnedFact == null ? 0 : this.returnedFact.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnSiteWithWeights other = (ReturnSiteWithWeights)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.returnSite == null ? other.returnSite != null : !this.returnSite.equals(other.returnSite)) {
                return false;
            }
            if (this.returnedFact == null ? other.returnedFact != null : !this.returnedFact.equals(other.returnedFact)) {
                return false;
            }
            return !(this.returnedWeight == null ? other.returnedWeight != null : !this.returnedWeight.equals(other.returnedWeight));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }

    private static class UnbalancedPopEntry {
        private final Transition<N, D> trans;
        private final D targetState;
        final /* synthetic */ WeightedPAutomaton this$0;

        public UnbalancedPopEntry(D targetState, Transition<N, D> trans) {
            this.this$0 = var1_1;
            this.targetState = targetState;
            this.trans = trans;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.targetState == null ? 0 : this.targetState.hashCode());
            result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedPopEntry other = (UnbalancedPopEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.targetState == null ? other.targetState != null : !this.targetState.equals(other.targetState)) {
                return false;
            }
            return !(this.trans == null ? other.trans != null : !this.trans.equals(other.trans));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }

    public static interface SummaryListener<N extends Location, D extends State> {
        public void addedSummary(Transition<N, D> var1);
    }
}

