/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.DefaultBoomerangOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class FromFileBoomerangOptions
extends DefaultBoomerangOptions {
    private Properties options = new Properties();

    public FromFileBoomerangOptions(File optFile) {
        try {
            this.options.load(new FileInputStream(optFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean staticFlows() {
        return this.getBooleanFromFile("staticFlows");
    }

    private boolean getBooleanFromFile(String prop) {
        return Boolean.parseBoolean(this.getProperty(prop));
    }

    private String getProperty(String prop) {
        String property = this.options.getProperty(prop);
        if (property == null) {
            throw new RuntimeException("Boomerang property file does not contain a value for " + prop);
        }
        return property;
    }

    @Override
    public boolean arrayFlows() {
        return this.getBooleanFromFile("arrayFlows");
    }

    @Override
    public boolean typeCheck() {
        return this.getBooleanFromFile("typeCheck");
    }

    @Override
    public boolean onTheFlyCallGraph() {
        return this.getBooleanFromFile("on-the-fly-cg");
    }

    @Override
    public boolean throwFlows() {
        return false;
    }

    @Override
    public boolean callSummaries() {
        return this.getBooleanFromFile("callSummaries");
    }

    @Override
    public boolean fieldSummaries() {
        return this.getBooleanFromFile("fieldSummaries");
    }

    @Override
    public int analysisTimeoutMS() {
        return Integer.parseInt(this.getProperty("timeout"));
    }
}

