/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BackwardQuery;
import boomerang.BoomerangOptions;
import boomerang.BoomerangTimeoutException;
import boomerang.Context;
import boomerang.DefaultBoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.IContextRequester;
import boomerang.Query;
import boomerang.SolverCreationListener;
import boomerang.UnbalancedPopHandler;
import boomerang.WeightedForwardQuery;
import boomerang.WholeProgramBoomerang;
import boomerang.callgraph.BackwardsObservableICFG;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.customize.BackwardEmptyCalleeFlow;
import boomerang.customize.EmptyCalleeFlow;
import boomerang.customize.ForwardEmptyCalleeFlow;
import boomerang.debugger.Debugger;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.StaticFieldVal;
import boomerang.jimple.Val;
import boomerang.poi.AbstractPOI;
import boomerang.poi.ExecuteImportFieldStmtPOI;
import boomerang.poi.PointOfIndirection;
import boomerang.preanalysis.BoomerangPretransformer;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.solver.ReachableMethodListener;
import boomerang.solver.StatementBasedCallTransitionListener;
import boomerang.stats.IBoomerangStats;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import heros.utilities.DefaultValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import sync.pds.solver.SyncPDSUpdateListener;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Rule;
import wpds.impl.StackListener;
import wpds.impl.SummaryNestedWeightedPAutomatons;
import wpds.impl.Transition;
import wpds.impl.UnbalancedPopListener;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class WeightedBoomerang<W extends Weight> {
    public static final boolean DEBUG = false;
    protected ObservableICFG<Unit, SootMethod> icfg;
    private static final Logger logger = LoggerFactory.getLogger(WeightedBoomerang.class);
    private Map<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>> genField = new HashMap<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>>();
    private long lastTick;
    private IBoomerangStats<W> stats;
    private Set<SolverCreationListener<W>> solverCreationListeners = Sets.newHashSet();
    private Multimap<SolverPair, ExecuteImportFieldStmtPOI<W>> poiListeners = HashMultimap.create();
    private Multimap<SolverPair, INode<Node<Statement, Val>>> activatedPoi = HashMultimap.create();
    private final DefaultValueMap<Query, AbstractBoomerangSolver<W>> queryToSolvers = new DefaultValueMap<Query, AbstractBoomerangSolver<W>>(){

        protected AbstractBoomerangSolver<W> createItem(final Query key) {
            AbstractBoomerangSolver solver;
            if (key instanceof BackwardQuery) {
                logger.debug("Backward solving query: " + key);
                solver = WeightedBoomerang.this.createBackwardSolver((BackwardQuery)key);
            } else {
                logger.debug("Forward solving query: " + key);
                solver = WeightedBoomerang.this.createForwardSolver((ForwardQuery)key);
            }
            solver.getCallAutomaton().registerUnbalancedPopListener(new UnbalancedPopListener<Statement, INode<Val>, W>(){

                public void unbalancedPop(final INode<Val> returningFact, Transition<Statement, INode<Val>> trans, W weight) {
                    Statement exitStmt = (Statement)trans.getLabel();
                    SootMethod callee = exitStmt.getMethod();
                    if (!callee.isStaticInitializer()) {
                        UnbalancedPopHandler info = new UnbalancedPopHandler(returningFact, trans, weight);
                        WeightedBoomerang.this.icfg().addCallerListener(new UnbalancedPopCallerListener(callee, info, key, solver));
                    } else {
                        for (SootMethod entryPoint : Scene.v().getEntryPoints()) {
                            for (Unit ep : WeightedBoomerang.this.icfg().getStartPointsOf(entryPoint)) {
                                final Statement callStatement = new Statement((Stmt)ep, WeightedBoomerang.this.icfg().getMethodOf(ep));
                                solver.submit(callStatement.getMethod(), new Runnable(){

                                    @Override
                                    public void run() {
                                        Val unbalancedFact = ((Val)returningFact.fact()).asUnbalanced(callStatement);
                                        SingleNode unbalancedState = new SingleNode((Object)unbalancedFact);
                                        solver.getCallAutomaton().addUnbalancedState((State)unbalancedState);
                                        solver.getCallAutomaton().addWeightForTransition(new Transition(solver.getCallAutomaton().getInitialState(), (Location)callStatement, (State)unbalancedState), solver.getCallAutomaton().getOne());
                                    }
                                });
                            }
                        }
                    }
                }
            });
            WeightedBoomerang.this.stats.registerSolver(key, solver);
            solver.getCallAutomaton().registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

                public void onWeightAdded(Transition<Statement, INode<Val>> t, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                    WeightedBoomerang.this.checkTimeout();
                }
            });
            solver.getFieldAutomaton().registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

                public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                    WeightedBoomerang.this.checkTimeout();
                }
            });
            SeedFactory seedFactory = WeightedBoomerang.this.getSeedFactory();
            if (WeightedBoomerang.this.options.onTheFlyCallGraph() && seedFactory != null) {
                for (SootMethod m : seedFactory.getMethodScope(key)) {
                    solver.addReachable(m);
                }
            }
            WeightedBoomerang.this.onCreateSubSolver(key, solver);
            return solver;
        }
    };
    Multimap<Node<Statement, AbstractBoomerangSolver<W>>, UnbalancedPopHandler<W>> unbalancedListeners = HashMultimap.create();
    Set<Node<Statement, AbstractBoomerangSolver<W>>> unbalancedPopPairs = Sets.newHashSet();
    private ObservableICFG<Unit, SootMethod> bwicfg;
    private EmptyCalleeFlow forwardEmptyCalleeFlow = new ForwardEmptyCalleeFlow();
    private EmptyCalleeFlow backwardEmptyCalleeFlow = new BackwardEmptyCalleeFlow();
    private NestedWeightedPAutomatons<Statement, INode<Val>, W> backwardCallSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> backwardFieldSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<Statement, INode<Val>, W> forwardCallSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> forwardFieldSummaries = new SummaryNestedWeightedPAutomatons();
    private DefaultValueMap<FieldWritePOI, FieldWritePOI> fieldWrites = new DefaultValueMap<FieldWritePOI, FieldWritePOI>(){

        protected FieldWritePOI createItem(FieldWritePOI key) {
            WeightedBoomerang.this.stats.registerFieldWritePOI(key);
            return key;
        }
    };
    private DefaultValueMap<FieldReadPOI, FieldReadPOI> fieldReads = new DefaultValueMap<FieldReadPOI, FieldReadPOI>(){

        protected FieldReadPOI createItem(FieldReadPOI key) {
            WeightedBoomerang.this.stats.registerFieldReadPOI(key);
            return key;
        }
    };
    protected final BoomerangOptions options;
    private Debugger<W> debugger;
    private Stopwatch analysisWatch = Stopwatch.createUnstarted();
    private Set<BackwardQuery> scopedQueries = Sets.newHashSet();

    private void registerUnbalancedPopListener(Node<Statement, AbstractBoomerangSolver<W>> unbalancedPopPair, UnbalancedPopHandler<W> unbalancedPopInfo) {
        if (this.unbalancedPopPairs.contains(unbalancedPopPair)) {
            unbalancedPopInfo.trigger((Statement)unbalancedPopPair.stmt(), (AbstractBoomerangSolver)((Object)unbalancedPopPair.fact()));
        } else {
            this.unbalancedListeners.put(unbalancedPopPair, unbalancedPopInfo);
        }
    }

    public void checkTimeout() {
        if (this.options.analysisTimeoutMS() > 0) {
            long elapsed = this.analysisWatch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed - this.lastTick > 15000L) {
                System.out.println("Alive " + elapsed + "  " + this.options.analysisTimeoutMS());
                this.lastTick = elapsed;
            }
            if ((long)this.options.analysisTimeoutMS() < elapsed) {
                if (this.analysisWatch.isRunning()) {
                    this.analysisWatch.stop();
                }
                throw new BoomerangTimeoutException(elapsed, this.stats);
            }
        }
    }

    private void triggerUnbalancedPop(Node<Statement, AbstractBoomerangSolver<W>> unbalancedPopPair) {
        if (this.unbalancedPopPairs.add(unbalancedPopPair)) {
            for (UnbalancedPopHandler unbalancedPopInfo : Lists.newArrayList((Iterable)this.unbalancedListeners.get(unbalancedPopPair))) {
                unbalancedPopInfo.trigger((Statement)unbalancedPopPair.stmt(), (AbstractBoomerangSolver)((Object)unbalancedPopPair.fact()));
            }
        }
    }

    public WeightedBoomerang(BoomerangOptions options) {
        this.options = options;
        this.stats = options.statsFactory();
        if (!BoomerangPretransformer.v().isApplied()) {
            throw new RuntimeException("Using WeightedBoomerang requires a call to BoomerangPretransformer.v().apply() prior constructing the ICFG");
        }
    }

    public WeightedBoomerang() {
        this(new DefaultBoomerangOptions());
    }

    protected AbstractBoomerangSolver<W> createBackwardSolver(final BackwardQuery backwardQuery) {
        final BackwardBoomerangSolver solver = new BackwardBoomerangSolver<W>(this.bwicfg(), backwardQuery, this.genField, this.options, this.createCallSummaries(backwardQuery, this.backwardCallSummaries), this.createFieldSummaries(backwardQuery, this.backwardFieldSummaries)){

            @Override
            protected Collection<? extends State> computeCallFlow(SootMethod caller, Statement returnSite, Statement callSite, InvokeExpr invokeExpr, Val fact, SootMethod callee, Stmt calleeSp) {
                return super.computeCallFlow(caller, returnSite, callSite, invokeExpr, fact, callee, calleeSp);
            }

            @Override
            protected Collection<? extends State> getEmptyCalleeFlow(SootMethod caller, Stmt callSite, Val value, Stmt returnSite) {
                return WeightedBoomerang.this.backwardEmptyCalleeFlow.getEmptyCalleeFlow(caller, callSite, value, returnSite);
            }

            protected WeightFunctions<Statement, Val, Field, W> getFieldWeights() {
                return WeightedBoomerang.this.getBackwardFieldWeights();
            }

            protected WeightFunctions<Statement, Val, Statement, W> getCallWeights() {
                return WeightedBoomerang.this.getBackwardCallWeights();
            }

            protected void onManyStateListenerRegister() {
                WeightedBoomerang.this.checkTimeout();
            }
        };
        solver.registerListener((SyncPDSUpdateListener)new SyncPDSUpdateListener<Statement, Val>(){

            public void onReachableNodeAdded(Node<Statement, Val> node) {
                if (WeightedBoomerang.this.hasNoMethod(node)) {
                    return;
                }
                Optional<AllocVal> allocNode = WeightedBoomerang.this.isAllocationNode((Statement)node.stmt(), (Val)node.fact());
                if (allocNode.isPresent()) {
                    ForwardQuery q = new ForwardQuery((Statement)node.stmt(), (Val)allocNode.get());
                    final AbstractBoomerangSolver forwardSolver = WeightedBoomerang.this.forwardSolve(q);
                    solver.registerReachableMethodListener(new ReachableMethodListener<W>(){

                        @Override
                        public void reachable(SootMethod m) {
                            forwardSolver.addReachable(m);
                        }
                    });
                }
                if (!WeightedBoomerang.isFieldStore((Statement)node.stmt())) {
                    if (WeightedBoomerang.isArrayLoad((Statement)node.stmt())) {
                        WeightedBoomerang.this.backwardHandleFieldRead(node, WeightedBoomerang.this.createArrayFieldLoad((Statement)node.stmt()), backwardQuery);
                    } else if (WeightedBoomerang.isFieldLoad((Statement)node.stmt())) {
                        WeightedBoomerang.this.backwardHandleFieldRead(node, WeightedBoomerang.this.createFieldLoad((Statement)node.stmt()), backwardQuery);
                    }
                }
                if (WeightedBoomerang.this.isBackwardEnterCall((Statement)node.stmt())) {
                    // empty if block
                }
                if (WeightedBoomerang.this.options.trackStaticFieldAtEntryPointToClinit() && ((Val)node.fact()).isStatic() && WeightedBoomerang.this.isFirstStatementOfEntryPoint((Statement)node.stmt())) {
                    StaticFieldVal val = (StaticFieldVal)node.fact();
                    for (SootMethod m : val.field().getDeclaringClass().getMethods()) {
                        if (!m.isStaticInitializer()) continue;
                        solver.addReachable(m);
                        for (Unit ep : WeightedBoomerang.this.icfg().getEndPointsOf(m)) {
                            StaticFieldVal newVal = new StaticFieldVal(val.value(), val.field(), m);
                            solver.addNormalCallFlow(node, new Node((Object)new Statement((Stmt)ep, m), (Object)newVal));
                            solver.addNormalFieldFlow(node, new Node((Object)new Statement((Stmt)ep, m), (Object)newVal));
                        }
                    }
                }
            }
        });
        return solver;
    }

    protected boolean hasNoMethod(Node<Statement, Val> node) {
        return this.icfg().getMethodOf((Unit)((Statement)node.stmt()).getUnit().get()) == null;
    }

    protected boolean isFirstStatementOfEntryPoint(Statement stmt) {
        for (SootMethod m : Scene.v().getEntryPoints()) {
            if (!m.hasActiveBody() || !stmt.equals(new Statement((Stmt)m.getActiveBody().getUnits().getFirst(), m))) continue;
            return true;
        }
        return false;
    }

    protected boolean isBackwardEnterCall(Statement stmt) {
        if (!stmt.getUnit().isPresent()) {
            return false;
        }
        try {
            return this.icfg().isExitStmt((Unit)stmt.getUnit().get());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected Optional<AllocVal> isAllocationNode(Statement s, Val fact) {
        Optional<Stmt> optUnit = s.getUnit();
        if (optUnit.isPresent()) {
            Stmt stmt = (Stmt)optUnit.get();
            return this.options.getAllocationVal(s.getMethod(), stmt, fact, this.icfg());
        }
        return Optional.absent();
    }

    protected ForwardBoomerangSolver<W> createForwardSolver(final ForwardQuery sourceQuery) {
        ForwardBoomerangSolver solver = new ForwardBoomerangSolver<W>(this.icfg(), sourceQuery, this.genField, this.options, this.createCallSummaries(sourceQuery, this.forwardCallSummaries), this.createFieldSummaries(sourceQuery, this.forwardFieldSummaries)){

            @Override
            protected Collection<? extends State> getEmptyCalleeFlow(SootMethod caller, Stmt callSite, Val value, Stmt returnSite) {
                return WeightedBoomerang.this.forwardEmptyCalleeFlow.getEmptyCalleeFlow(caller, callSite, value, returnSite);
            }

            protected WeightFunctions<Statement, Val, Statement, W> getCallWeights() {
                return WeightedBoomerang.this.getForwardCallWeights(sourceQuery);
            }

            protected WeightFunctions<Statement, Val, Field, W> getFieldWeights() {
                return WeightedBoomerang.this.getForwardFieldWeights();
            }

            @Override
            public void addCallRule(Rule<Statement, INode<Val>, W> rule) {
                if (WeightedBoomerang.this.preventCallRuleAdd(sourceQuery, rule)) {
                    return;
                }
                super.addCallRule(rule);
            }

            protected void onManyStateListenerRegister() {
                WeightedBoomerang.this.checkTimeout();
            }
        };
        solver.registerListener((SyncPDSUpdateListener)new SyncPDSUpdateListener<Statement, Val>(){

            public void onReachableNodeAdded(Node<Statement, Val> node) {
                if (WeightedBoomerang.this.hasNoMethod(node)) {
                    return;
                }
                if (WeightedBoomerang.isFieldStore((Statement)node.stmt())) {
                    WeightedBoomerang.this.forwardHandleFieldWrite(node, WeightedBoomerang.this.createFieldStore((Statement)node.stmt()), sourceQuery);
                } else if (WeightedBoomerang.isArrayStore((Statement)node.stmt())) {
                    if (WeightedBoomerang.this.options.arrayFlows()) {
                        WeightedBoomerang.this.forwardHandleFieldWrite(node, WeightedBoomerang.this.createArrayFieldStore((Statement)node.stmt()), sourceQuery);
                    }
                } else if (WeightedBoomerang.isFieldLoad((Statement)node.stmt())) {
                    WeightedBoomerang.this.forwardHandleFieldLoad((Node<Statement, Val>)node, WeightedBoomerang.this.createFieldLoad((Statement)node.stmt()), sourceQuery);
                } else if (WeightedBoomerang.isArrayLoad((Statement)node.stmt())) {
                    WeightedBoomerang.this.forwardHandleFieldLoad((Node<Statement, Val>)node, WeightedBoomerang.this.createArrayFieldLoad((Statement)node.stmt()), sourceQuery);
                }
                if (WeightedBoomerang.this.isBackwardEnterCall((Statement)node.stmt())) {
                    // empty if block
                }
            }
        });
        return solver;
    }

    private NestedWeightedPAutomatons<Statement, INode<Val>, W> createCallSummaries(final Query sourceQuery, final NestedWeightedPAutomatons<Statement, INode<Val>, W> summaries) {
        return new NestedWeightedPAutomatons<Statement, INode<Val>, W>(){

            public void putSummaryAutomaton(INode<Val> target, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                summaries.putSummaryAutomaton(target, aut);
            }

            public WeightedPAutomaton<Statement, INode<Val>, W> getSummaryAutomaton(INode<Val> target) {
                if (((Val)target.fact()).equals(sourceQuery.var())) {
                    return ((AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.getOrCreate((Object)sourceQuery))).getCallAutomaton();
                }
                return summaries.getSummaryAutomaton(target);
            }
        };
    }

    private NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> createFieldSummaries(final Query query, final NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> summaries) {
        return new NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W>(){

            public void putSummaryAutomaton(INode<Node<Statement, Val>> target, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                summaries.putSummaryAutomaton(target, aut);
            }

            public WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> getSummaryAutomaton(INode<Node<Statement, Val>> target) {
                if (((Node)target.fact()).equals(query.asNode())) {
                    return ((AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.getOrCreate((Object)query))).getFieldAutomaton();
                }
                return summaries.getSummaryAutomaton(target);
            }
        };
    }

    public boolean preventCallRuleAdd(ForwardQuery sourceQuery, Rule<Statement, INode<Val>, W> rule) {
        return false;
    }

    protected FieldReadPOI createFieldLoad(Statement s) {
        Stmt stmt = (Stmt)s.getUnit().get();
        AssignStmt as = (AssignStmt)stmt;
        InstanceFieldRef ifr = (InstanceFieldRef)as.getRightOp();
        Val base = new Val(ifr.getBase(), this.icfg().getMethodOf((Unit)as));
        Field field = new Field(ifr.getField());
        return (FieldReadPOI)this.fieldReads.getOrCreate((Object)new FieldReadPOI(s, base, field, new Val(as.getLeftOp(), this.icfg().getMethodOf((Unit)as))));
    }

    protected FieldReadPOI createArrayFieldLoad(Statement s) {
        Stmt stmt = (Stmt)s.getUnit().get();
        AssignStmt as = (AssignStmt)stmt;
        ArrayRef ifr = (ArrayRef)as.getRightOp();
        Val base = new Val(ifr.getBase(), this.icfg().getMethodOf((Unit)as));
        Val stored = new Val(as.getLeftOp(), this.icfg().getMethodOf((Unit)as));
        return (FieldReadPOI)this.fieldReads.getOrCreate((Object)new FieldReadPOI(s, base, Field.array(), stored));
    }

    protected FieldWritePOI createArrayFieldStore(Statement s) {
        Stmt stmt = (Stmt)s.getUnit().get();
        AssignStmt as = (AssignStmt)stmt;
        ArrayRef ifr = (ArrayRef)as.getLeftOp();
        Val base = new Val(ifr.getBase(), this.icfg().getMethodOf((Unit)as));
        Val stored = new Val(as.getRightOp(), this.icfg().getMethodOf((Unit)as));
        return (FieldWritePOI)this.fieldWrites.getOrCreate((Object)new FieldWritePOI(s, base, Field.array(), stored));
    }

    protected FieldWritePOI createFieldStore(Statement s) {
        Stmt stmt = (Stmt)s.getUnit().get();
        AssignStmt as = (AssignStmt)stmt;
        InstanceFieldRef ifr = (InstanceFieldRef)as.getLeftOp();
        Val base = new Val(ifr.getBase(), this.icfg().getMethodOf((Unit)as));
        Val stored = new Val(as.getRightOp(), this.icfg().getMethodOf((Unit)as));
        Field field = new Field(ifr.getField());
        return (FieldWritePOI)this.fieldWrites.getOrCreate((Object)new FieldWritePOI(s, base, field, stored));
    }

    public static boolean isFieldStore(Statement s) {
        Stmt stmt;
        Optional<Stmt> optUnit = s.getUnit();
        return optUnit.isPresent() && (stmt = (Stmt)optUnit.get()) instanceof AssignStmt && ((AssignStmt)stmt).getLeftOp() instanceof InstanceFieldRef;
    }

    public static boolean isArrayStore(Statement s) {
        Stmt stmt;
        Optional<Stmt> optUnit = s.getUnit();
        return optUnit.isPresent() && (stmt = (Stmt)optUnit.get()) instanceof AssignStmt && ((AssignStmt)stmt).getLeftOp() instanceof ArrayRef;
    }

    public static boolean isArrayLoad(Statement s) {
        Stmt stmt;
        Optional<Stmt> optUnit = s.getUnit();
        return optUnit.isPresent() && (stmt = (Stmt)optUnit.get()) instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof ArrayRef;
    }

    public static boolean isFieldLoad(Statement s) {
        Stmt stmt;
        Optional<Stmt> optUnit = s.getUnit();
        return optUnit.isPresent() && (stmt = (Stmt)optUnit.get()) instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof InstanceFieldRef;
    }

    protected void backwardHandleFieldRead(Node<Statement, Val> node, FieldReadPOI fieldRead, BackwardQuery sourceQuery) {
        if (((Val)node.fact()).equals(fieldRead.getStoredVar())) {
            fieldRead.addFlowAllocation(sourceQuery);
        }
    }

    protected void forwardHandleFieldWrite(Node<Statement, Val> node, FieldWritePOI fieldWritePoi, ForwardQuery sourceQuery) {
        BackwardQuery backwardQuery = new BackwardQuery((Statement)node.stmt(), (Val)fieldWritePoi.getBaseVar());
        if (((Val)node.fact()).equals(fieldWritePoi.getStoredVar())) {
            this.backwardSolveUnderScope(backwardQuery, sourceQuery, node);
            ((AbstractBoomerangSolver)((Object)this.queryToSolvers.get((Object)sourceQuery))).getFieldAutomaton().registerListener((WPAUpdateListener)new ForwardHandleFieldWrite(sourceQuery, fieldWritePoi, (Statement)node.stmt()));
        }
        if (((Val)node.fact()).equals(fieldWritePoi.getBaseVar())) {
            ((AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)sourceQuery))).getFieldAutomaton().registerListener((WPAStateListener)new TriggerBaseAllocationAtFieldWrite((INode<Node<Statement, Val>>)new SingleNode(node), fieldWritePoi, sourceQuery));
        }
    }

    public BackwardBoomerangResults<W> backwardSolveUnderScope(BackwardQuery backwardQuery, ForwardQuery forwardQuery, Node<Statement, Val> node) {
        this.scopedQueries.add(backwardQuery);
        boolean timedout = false;
        try {
            this.backwardSolve(backwardQuery);
            final AbstractBoomerangSolver bwSolver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)backwardQuery));
            AbstractBoomerangSolver fwSolver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)forwardQuery));
            fwSolver.registerReachableMethodListener(new ReachableMethodListener<W>(){

                @Override
                public void reachable(SootMethod m) {
                    bwSolver.addReachable(m);
                }
            });
            fwSolver.getCallAutomaton().registerListener((WPAStateListener)new StackListener<Statement, INode<Val>, W>(fwSolver.getCallAutomaton(), (INode)new SingleNode(node.fact()), (Statement)node.stmt()){

                public void stackElement(Statement callSite) {
                    WeightedBoomerang.this.triggerUnbalancedPop(new Node((Object)callSite, (Object)bwSolver));
                }

                public void anyContext(Statement end) {
                    for (Unit sP : WeightedBoomerang.this.icfg().getStartPointsOf(end.getMethod())) {
                        bwSolver.registerStatementCallTransitionListener(new CanUnbalancedReturn(end.getMethod(), new Statement((Stmt)sP, end.getMethod()), bwSolver));
                    }
                }
            });
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            this.cleanup();
        }
        return new BackwardBoomerangResults<W>(backwardQuery, timedout, this.queryToSolvers, this.getStats(), this.analysisWatch);
    }

    private void cleanup() {
        for (AbstractBoomerangSolver solver : this.queryToSolvers.values()) {
            solver.cleanup();
        }
        this.poiListeners.clear();
        this.unbalancedListeners.clear();
    }

    public BackwardBoomerangResults<W> backwardSolveUnderScope(BackwardQuery backwardQuery, IContextRequester requester) {
        this.scopedQueries.add(backwardQuery);
        boolean timedout = false;
        try {
            if (this.analysisWatch.isRunning()) {
                this.analysisWatch.stop();
            }
            this.analysisWatch = Stopwatch.createStarted();
            this.backwardSolve(backwardQuery);
            AbstractBoomerangSolver bwSolver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)backwardQuery));
            Collection<Context> callSiteOf = requester.getCallSiteOf(requester.initialContext(backwardQuery.stmt()));
            for (Context c : callSiteOf) {
                bwSolver.registerListener(new CanUnbalancedReturnToCallSite(backwardQuery.stmt().getMethod(), c, bwSolver, requester));
            }
            if (this.analysisWatch.isRunning()) {
                this.analysisWatch.stop();
            }
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            this.cleanup();
        }
        return new BackwardBoomerangResults<W>(backwardQuery, timedout, this.queryToSolvers, this.getStats(), this.analysisWatch);
    }

    private void forwardHandleFieldLoad(Node<Statement, Val> node, FieldReadPOI fieldReadPoi, ForwardQuery sourceQuery) {
        if (((Val)node.fact()).equals(fieldReadPoi.getBaseVar())) {
            ((AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)sourceQuery))).getFieldAutomaton().registerListener((WPAStateListener)new TriggerBaseAllocationAtFieldWrite((INode<Node<Statement, Val>>)new SingleNode(node), fieldReadPoi, sourceQuery));
        }
    }

    private boolean isAllocationNode(Val fact, ForwardQuery sourceQuery) {
        return fact.equals(sourceQuery.var());
    }

    private ObservableICFG<Unit, SootMethod> bwicfg() {
        if (this.bwicfg == null) {
            this.bwicfg = new BackwardsObservableICFG(this.icfg());
        }
        return this.bwicfg;
    }

    public ForwardBoomerangResults<W> solve(ForwardQuery query) {
        if (!this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            logger.debug("Starting forward analysis of: {}", (Object)query);
            this.forwardSolve(query);
            logger.debug("Terminated forward analysis of: {}", (Object)query);
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            this.cleanup();
            logger.debug("Timeout of query: {}", (Object)query);
        }
        if (this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new ForwardBoomerangResults<W>(query, this.icfg(), timedout, this.queryToSolvers, this.getStats(), this.analysisWatch);
    }

    public BackwardBoomerangResults<W> solve(BackwardQuery query) {
        this.icfg().addUnbalancedMethod(query.stmt().getMethod());
        return this.solve(query, true);
    }

    public BackwardBoomerangResults<W> solve(BackwardQuery query, boolean timing) {
        if (timing && !this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            logger.debug("Starting backward analysis of: {}", (Object)query);
            this.backwardSolve(query);
            logger.debug("Terminated backward analysis of: {}", (Object)query);
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            this.cleanup();
            logger.debug("Timeout of query: {}", (Object)query);
        }
        if (timing && this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new BackwardBoomerangResults<W>(query, timedout, this.queryToSolvers, this.getStats(), this.analysisWatch);
    }

    protected void backwardSolve(BackwardQuery query) {
        if (!this.options.aliasing()) {
            return;
        }
        Optional<Stmt> unit = ((Statement)query.asNode().stmt()).getUnit();
        AbstractBoomerangSolver solver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)query));
        if (unit.isPresent()) {
            solver.solve(query.asNode());
        }
    }

    private AbstractBoomerangSolver<W> forwardSolve(ForwardQuery query) {
        Optional<Stmt> unit = ((Statement)query.asNode().stmt()).getUnit();
        AbstractBoomerangSolver solver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)query));
        if (unit.isPresent()) {
            SootClass stringClass;
            if (this.isMultiArrayAllocation((Stmt)unit.get()) && this.options.arrayFlows()) {
                SingleNode sourveVal = new SingleNode(query.asNode());
                GeneratedState genState = new GeneratedState((INode)sourveVal, (Object)Field.array());
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<Statement, Val>>>)new Transition((State)sourveVal, (Location)Field.array(), (State)genState));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<Statement, Val>>>)new Transition((State)genState, (Location)Field.empty(), solver.getFieldAutomaton().getInitialState()));
            }
            if (this.isStringAllocation((Stmt)unit.get()) && (stringClass = Scene.v().getSootClass("java.lang.String")).declaresField("char[] value")) {
                SootField valueField = stringClass.getFieldByName("value");
                SingleNode s = new SingleNode(query.asNode());
                INode irState = (INode)solver.getFieldAutomaton().createState((State)s, (Location)new Field(valueField));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<Statement, Val>>>)new Transition((State)new SingleNode(query.asNode()), (Location)new Field(valueField), (State)irState));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<Statement, Val>>>)new Transition((State)irState, (Location)Field.empty(), solver.getFieldAutomaton().getInitialState()));
            }
            if (query instanceof WeightedForwardQuery) {
                WeightedForwardQuery q = (WeightedForwardQuery)query;
                solver.solve((Node)q.asNode(), (Weight)q.weight());
            } else {
                solver.solve(query.asNode());
            }
        }
        return solver;
    }

    private boolean isStringAllocation(Stmt stmt) {
        return stmt instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof StringConstant;
    }

    private boolean insertTransition(WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut, Transition<Field, INode<Node<Statement, Val>>> transition) {
        if (!aut.nested()) {
            return aut.addTransition(transition);
        }
        INode target = (INode)transition.getTarget();
        if (!(target instanceof GeneratedState)) {
            this.forwardFieldSummaries.putSummaryAutomaton((State)target, aut);
            aut.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

                public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                    if (t.getStart() instanceof GeneratedState) {
                        WeightedPAutomaton n = WeightedBoomerang.this.forwardFieldSummaries.getSummaryAutomaton(t.getStart());
                        aut.addNestedAutomaton(n);
                    }
                }
            });
            return aut.addTransition(transition);
        }
        WeightedPAutomaton nested = this.forwardFieldSummaries.getSummaryAutomaton((State)target);
        nested.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (t.getStart() instanceof GeneratedState) {
                    WeightedPAutomaton n = WeightedBoomerang.this.forwardFieldSummaries.getSummaryAutomaton(t.getStart());
                    aut.addNestedAutomaton(n);
                }
            }
        });
        return nested.addTransition(transition);
    }

    private boolean isMultiArrayAllocation(Stmt stmt) {
        return stmt instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof NewMultiArrayExpr;
    }

    protected void activateAllPois(SolverPair pair, INode<Node<Statement, Val>> start) {
        if (this.activatedPoi.put((Object)pair, start)) {
            Collection listeners = this.poiListeners.get((Object)pair);
            for (ExecuteImportFieldStmtPOI l : Lists.newArrayList((Iterable)listeners)) {
                l.trigger(start);
            }
        }
    }

    public void registerActivationListener(SolverPair solverPair, ExecuteImportFieldStmtPOI<W> exec) {
        Collection listeners = this.activatedPoi.get((Object)solverPair);
        for (INode node : Lists.newArrayList((Iterable)listeners)) {
            exec.trigger((INode<Node<Statement, Val>>)node);
        }
        this.poiListeners.put((Object)solverPair, exec);
    }

    public void createPOI(BiDiInterproceduralCFG<Unit, SootMethod> icfg, AbstractBoomerangSolver<W> baseSolver, AbstractBoomerangSolver<W> flowSolver, FieldReadPOI fieldReadPOI, Statement succ) {
    }

    public abstract ObservableICFG<Unit, SootMethod> icfg();

    protected abstract WeightFunctions<Statement, Val, Field, W> getForwardFieldWeights();

    protected abstract WeightFunctions<Statement, Val, Field, W> getBackwardFieldWeights();

    protected abstract WeightFunctions<Statement, Val, Statement, W> getBackwardCallWeights();

    protected abstract WeightFunctions<Statement, Val, Statement, W> getForwardCallWeights(ForwardQuery var1);

    public DefaultValueMap<Query, AbstractBoomerangSolver<W>> getSolvers() {
        return this.queryToSolvers;
    }

    public abstract Debugger<W> createDebugger();

    public void debugOutput() {
        Debugger<W> debugger = this.getOrCreateDebugger();
        debugger.done((Map<Query, AbstractBoomerangSolver<W>>)this.queryToSolvers);
    }

    public Debugger<W> getOrCreateDebugger() {
        if (this.debugger == null) {
            this.debugger = this.createDebugger();
        }
        return this.debugger;
    }

    public SeedFactory<W> getSeedFactory() {
        return null;
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public void onCreateSubSolver(Query key, AbstractBoomerangSolver<W> solver) {
        for (SolverCreationListener<W> l : this.solverCreationListeners) {
            l.onCreatedSolver(key, solver);
        }
    }

    public void registerSolverCreationListener(SolverCreationListener<W> l) {
        if (this.solverCreationListeners.add(l)) {
            for (Map.Entry e : Lists.newArrayList((Iterable)this.queryToSolvers.entrySet())) {
                l.onCreatedSolver((Query)e.getKey(), (AbstractBoomerangSolver)((Object)e.getValue()));
            }
        }
    }

    public Table<Statement, Val, W> getResults(Query seed) {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton fieldAut = ((AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)seed))).getCallAutomaton();
        for (Map.Entry e : fieldAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            Weight w = (Weight)e.getValue();
            if (((Statement)t.getLabel()).equals(Statement.epsilon()) || ((Val)((INode)t.getStart()).fact()).value() instanceof Local && !((Statement)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m()) || !((Statement)t.getLabel()).getUnit().isPresent()) continue;
            results.put((Object)t.getLabel(), ((INode)t.getStart()).fact(), (Object)w);
        }
        return results;
    }

    public BoomerangOptions getOptions() {
        return this.options;
    }

    private class SolverPair {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;

        public SolverPair(AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver) {
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : ((Object)((Object)this.baseSolver)).hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SolverPair other = (SolverPair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.baseSolver == null ? other.baseSolver != null : !((Object)((Object)this.baseSolver)).equals((Object)other.baseSolver)) {
                return false;
            }
            return !(this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    public class FieldReadPOI
    extends AbstractPOI<Statement, Val, Field> {
        public FieldReadPOI(Statement statement, Val base, Field field, Val stored) {
            super(statement, base, field, stored);
        }

        @Override
        public void execute(ForwardQuery baseAllocation, Query flowAllocation) {
            if (WeightedBoomerang.this instanceof WholeProgramBoomerang) {
                throw new RuntimeException("should not be invoked!");
            }
            if (!(flowAllocation instanceof ForwardQuery) && flowAllocation instanceof BackwardQuery) {
                AbstractBoomerangSolver baseSolver = (AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get((Object)baseAllocation));
                AbstractBoomerangSolver flowSolver = (AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get((Object)flowAllocation));
                for (Statement succ : flowSolver.getSuccsOf((Statement)this.getStmt())) {
                    ExecuteImportFieldStmtPOI exec = new ExecuteImportFieldStmtPOI<W>(WeightedBoomerang.this, baseSolver, flowSolver, this, succ){

                        @Override
                        public void activate(INode<Node<Statement, Val>> start) {
                            WeightedBoomerang.this.activateAllPois(new SolverPair(this.flowSolver, this.baseSolver), start);
                        }
                    };
                    WeightedBoomerang.this.registerActivationListener(new SolverPair(flowSolver, baseSolver), exec);
                    exec.solve();
                }
            }
        }
    }

    public class FieldWritePOI
    extends AbstractPOI<Statement, Val, Field> {
        public FieldWritePOI(Statement statement, Val base, Field field, Val stored) {
            super(statement, base, field, stored);
        }

        @Override
        public void execute(ForwardQuery baseAllocation, Query flowAllocation) {
            if (!(flowAllocation instanceof BackwardQuery) && flowAllocation instanceof ForwardQuery) {
                AbstractBoomerangSolver baseSolver = (AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get((Object)baseAllocation));
                AbstractBoomerangSolver flowSolver = (AbstractBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get((Object)flowAllocation));
                ExecuteImportFieldStmtPOI exec = new ExecuteImportFieldStmtPOI<W>(WeightedBoomerang.this, baseSolver, flowSolver, this, (Statement)this.getStmt()){

                    @Override
                    public void activate(INode<Node<Statement, Val>> start) {
                        WeightedBoomerang.this.activateAllPois(new SolverPair(this.flowSolver, this.baseSolver), start);
                    }
                };
                WeightedBoomerang.this.registerActivationListener(new SolverPair(flowSolver, baseSolver), exec);
                exec.solve();
            }
        }
    }

    private class TriggerBaseAllocationAtFieldWrite
    extends WPAStateListener<Field, INode<Node<Statement, Val>>, W> {
        private final PointOfIndirection<Statement, Val, Field> fieldWritePoi;
        private final ForwardQuery sourceQuery;

        public TriggerBaseAllocationAtFieldWrite(INode<Node<Statement, Val>> state, PointOfIndirection<Statement, Val, Field> fieldWritePoi, ForwardQuery sourceQuery) {
            super(state);
            this.fieldWritePoi = fieldWritePoi;
            this.sourceQuery = sourceQuery;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
            if (WeightedBoomerang.this.isAllocationNode((Val)((Node)((INode)t.getTarget()).fact()).fact(), this.sourceQuery)) {
                this.fieldWritePoi.addBaseAllocation(this.sourceQuery);
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.fieldWritePoi == null ? 0 : this.fieldWritePoi.hashCode());
            result = 31 * result + (this.sourceQuery == null ? 0 : this.sourceQuery.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TriggerBaseAllocationAtFieldWrite other = (TriggerBaseAllocationAtFieldWrite)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.fieldWritePoi == null ? other.fieldWritePoi != null : !this.fieldWritePoi.equals(other.fieldWritePoi)) {
                return false;
            }
            return !(this.sourceQuery == null ? other.sourceQuery != null : !this.sourceQuery.equals(other.sourceQuery));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private final class ForwardHandleFieldWrite
    implements WPAUpdateListener<Field, INode<Node<Statement, Val>>, W> {
        private final Query sourceQuery;
        private final AbstractPOI<Statement, Val, Field> fieldWritePoi;
        private final Statement stmt;

        private ForwardHandleFieldWrite(Query sourceQuery, AbstractPOI<Statement, Val, Field> fieldWritePoi, Statement statement) {
            this.sourceQuery = sourceQuery;
            this.fieldWritePoi = fieldWritePoi;
            this.stmt = statement;
        }

        public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((Statement)((Node)((INode)t.getStart()).fact()).stmt()).equals(this.stmt) && ((Field)t.getLabel()).equals(Field.empty())) {
                this.fieldWritePoi.addFlowAllocation(this.sourceQuery);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.sourceQuery == null ? 0 : this.sourceQuery.hashCode());
            result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForwardHandleFieldWrite other = (ForwardHandleFieldWrite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.sourceQuery == null ? other.sourceQuery != null : !this.sourceQuery.equals(other.sourceQuery)) {
                return false;
            }
            return !(this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private class CanUnbalancedReturn
    extends StatementBasedCallTransitionListener<W> {
        private AbstractBoomerangSolver<W> bwSolver;
        private Statement startPoint;
        private SootMethod method;

        public CanUnbalancedReturn(SootMethod method, Statement startPoint, AbstractBoomerangSolver<W> bwSolver) {
            super(startPoint);
            this.method = method;
            this.bwSolver = bwSolver;
            this.startPoint = startPoint;
        }

        @Override
        public void onAddedTransition(Transition<Statement, INode<Val>> t, W w) {
            if (((Statement)t.getLabel()).equals(this.startPoint)) {
                WeightedBoomerang.this.icfg().addCallerListener(new UnbalancedReturnCallerListener(this.bwSolver, this.method));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.bwSolver == null ? 0 : ((Object)((Object)this.bwSolver)).hashCode());
            result = 31 * result + (this.startPoint == null ? 0 : this.startPoint.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CanUnbalancedReturn other = (CanUnbalancedReturn)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.bwSolver == null ? other.bwSolver != null : !((Object)((Object)this.bwSolver)).equals((Object)other.bwSolver)) {
                return false;
            }
            return !(this.startPoint == null ? other.startPoint != null : !this.startPoint.equals(other.startPoint));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private final class UnbalancedReturnCallerListener
    implements CallerListener<Unit, SootMethod> {
        private final AbstractBoomerangSolver<W> bwSolver;
        private final SootMethod method;

        public UnbalancedReturnCallerListener(AbstractBoomerangSolver<W> bwSolver, SootMethod method) {
            this.bwSolver = bwSolver;
            this.method = method;
        }

        @Override
        public SootMethod getObservedCallee() {
            return this.method;
        }

        @Override
        public void onCallerAdded(Unit callSite, SootMethod m) {
            if (!((Stmt)callSite).containsInvokeExpr()) {
                return;
            }
            Statement callStatement = new Statement((Stmt)callSite, WeightedBoomerang.this.icfg().getMethodOf(callSite));
            Node solverPair = new Node((Object)callStatement, this.bwSolver);
            WeightedBoomerang.this.triggerUnbalancedPop(solverPair);
            for (Unit sP : WeightedBoomerang.this.icfg().getStartPointsOf(callStatement.getMethod())) {
                this.bwSolver.registerStatementCallTransitionListener(new CanUnbalancedReturn(callStatement.getMethod(), new Statement((Stmt)sP, callStatement.getMethod()), this.bwSolver));
            }
        }
    }

    private class CanUnbalancedReturnToCallSite
    implements SyncPDSUpdateListener<Statement, Val> {
        private AbstractBoomerangSolver<W> bwSolver;
        private SootMethod method;
        private Collection<Unit> startPointsOf;
        private Context callSite;
        private IContextRequester req;

        public CanUnbalancedReturnToCallSite(SootMethod method, Context callSite, AbstractBoomerangSolver<W> bwSolver, IContextRequester req) {
            this.method = method;
            this.callSite = callSite;
            this.bwSolver = bwSolver;
            this.req = req;
            this.startPointsOf = WeightedBoomerang.this.icfg().getStartPointsOf(method);
        }

        public void onReachableNodeAdded(Node<Statement, Val> reachableNode) {
            if (this.startPointsOf.contains(((Statement)reachableNode.stmt()).getUnit().get())) {
                Node solverPair = new Node((Object)this.callSite.getStmt(), this.bwSolver);
                this.bwSolver.addReachable(this.callSite.getStmt().getMethod());
                WeightedBoomerang.this.triggerUnbalancedPop(solverPair);
                for (Context parent : this.req.getCallSiteOf(this.callSite)) {
                    this.bwSolver.registerListener(new CanUnbalancedReturnToCallSite(this.callSite.getStmt().getMethod(), parent, this.bwSolver, this.req));
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.bwSolver == null ? 0 : ((Object)((Object)this.bwSolver)).hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CanUnbalancedReturnToCallSite other = (CanUnbalancedReturnToCallSite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.bwSolver == null ? other.bwSolver != null : !((Object)((Object)this.bwSolver)).equals((Object)other.bwSolver)) {
                return false;
            }
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private final class UnbalancedPopCallerListener
    implements CallerListener<Unit, SootMethod> {
        private final SootMethod callee;
        private final UnbalancedPopHandler<W> info;
        private final Query key;
        private final AbstractBoomerangSolver<W> solver;

        private UnbalancedPopCallerListener(SootMethod callee, UnbalancedPopHandler<W> info, Query key, AbstractBoomerangSolver<W> solver) {
            this.callee = callee;
            this.info = info;
            this.key = key;
            this.solver = solver;
        }

        @Override
        public SootMethod getObservedCallee() {
            return this.callee;
        }

        @Override
        public void onCallerAdded(Unit callSite, SootMethod m) {
            if (!((Stmt)callSite).containsInvokeExpr()) {
                return;
            }
            Statement callStatement = new Statement((Stmt)callSite, WeightedBoomerang.this.icfg().getMethodOf(callSite));
            Node solverPair = new Node((Object)callStatement, this.solver);
            WeightedBoomerang.this.registerUnbalancedPopListener(solverPair, this.info);
            if (this.callee.isStatic() || !WeightedBoomerang.this.scopedQueries.contains(this.key)) {
                WeightedBoomerang.this.triggerUnbalancedPop(solverPair);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
            result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.solver == null ? 0 : ((Object)((Object)this.solver)).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedPopCallerListener other = (UnbalancedPopCallerListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callee == null ? other.callee != null : !this.callee.equals(other.callee)) {
                return false;
            }
            if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.solver == null ? other.solver != null : !((Object)((Object)this.solver)).equals((Object)other.solver));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }
}

