/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BackwardQuery;
import boomerang.BoomerangOptions;
import boomerang.DefaultBoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.callgraph.BoomerangICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.callgraph.ObservableStaticICFG;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import java.util.Collection;
import java.util.Collections;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;

public abstract class WholeProgramBoomerang<W extends Weight>
extends WeightedBoomerang<W> {
    private int reachableMethodCount;
    private int allocationSites;
    private SeedFactory<W> seedFactory;

    public WholeProgramBoomerang(BoomerangOptions opts) {
        super(opts);
    }

    public WholeProgramBoomerang() {
        this(new DefaultBoomerangOptions());
    }

    @Override
    public SeedFactory<W> getSeedFactory() {
        if (this.seedFactory == null) {
            this.seedFactory = new SeedFactory<W>(){

                @Override
                protected Collection<? extends Query> generate(SootMethod method, Stmt u) {
                    AssignStmt assignStmt;
                    if (u instanceof AssignStmt && WholeProgramBoomerang.this.options.isAllocationVal((assignStmt = (AssignStmt)u).getRightOp())) {
                        return Collections.singleton(new ForwardQuery(new Statement(u, method), new AllocVal(assignStmt.getLeftOp(), method, assignStmt.getRightOp(), new Statement(u, method))));
                    }
                    return Collections.emptySet();
                }

                @Override
                public ObservableICFG<Unit, SootMethod> icfg() {
                    return new ObservableStaticICFG(new BoomerangICFG(false));
                }
            };
        }
        return this.seedFactory;
    }

    public void wholeProgramAnalysis() {
        long before = System.currentTimeMillis();
        for (Query s : this.getSeedFactory().computeSeeds()) {
            this.solve((ForwardQuery)s);
        }
        long after = System.currentTimeMillis();
        System.out.println("Analysis Time (in ms):\t" + (after - before));
        System.out.println("Analyzed methods:\t" + this.reachableMethodCount);
        System.out.println("Total solvers:\t" + this.getSolvers().size());
        System.out.println("Allocation Sites:\t" + this.allocationSites);
        System.out.println(this.options.statsFactory());
    }

    @Override
    protected void backwardSolve(BackwardQuery query) {
    }

    @Override
    public BackwardBoomerangResults<W> backwardSolveUnderScope(BackwardQuery backwardQuery, ForwardQuery forwardQuery, Node<Statement, Val> node) {
        return null;
    }
}

