/*
 * Decompiled with CFR 0.152.
 */
package boomerang.callgraph;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.SolverCreationListener;
import boomerang.WeightedBoomerang;
import boomerang.callgraph.CallGraphOptions;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ExtractAllocationSiteStateListener;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.Kind;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.queue.QueueReader;
import sync.pds.solver.nodes.INode;
import wpds.impl.Weight;
import wpds.interfaces.WPAStateListener;

public class ObservableDynamicICFG
implements ObservableICFG<Unit, SootMethod> {
    private static final String THREAD_CLASS = "java.lang.Thread";
    private static final String THREAD_START_SIGNATURE = "<java.lang.Thread: void start()>";
    private static final String THREAD_RUN_SUB_SIGNATURE = "void run()";
    private static final Logger logger = LoggerFactory.getLogger(ObservableDynamicICFG.class);
    private int numberOfEdgesTakenFromPrecomputedCallGraph = 0;
    private CallGraphOptions options = new CallGraphOptions();
    private CallGraph demandDrivenCallGraph = new CallGraph();
    private CallGraph precomputedCallGraph;
    private WeightedBoomerang<? extends Weight> solver;
    private Set<SootMethod> unbalancedMethods = Sets.newHashSet();
    private Multimap<Unit, CalleeListener<Unit, SootMethod>> calleeListeners = HashMultimap.create();
    private Multimap<SootMethod, CallerListener<Unit, SootMethod>> callerListeners = HashMultimap.create();
    private final boolean enableExceptions;
    @DontSynchronize(value="written by single thread; read afterwards")
    private final Map<Unit, Body> unitToOwner = new HashMap<Unit, Body>();
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    private final LoadingCache<Body, DirectedGraph<Unit>> bodyToUnitGraph = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<Body, DirectedGraph<Unit>>(){

        public DirectedGraph<Unit> load(Body body) {
            return this.makeGraph(body);
        }

        private DirectedGraph<Unit> makeGraph(Body body) {
            return ObservableDynamicICFG.this.enableExceptions ? new ExceptionalUnitGraph(body, (ThrowAnalysis)UnitThrowAnalysis.v(), true) : new BriefUnitGraph(body);
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    private final LoadingCache<SootMethod, List<Value>> methodToParameterRefs = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, List<Value>>(){

        public List<Value> load(SootMethod m) {
            return m.getActiveBody().getParameterRefs();
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    private final LoadingCache<SootMethod, Set<Unit>> methodToCallsFromWithin = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, Set<Unit>>(){

        public Set<Unit> load(SootMethod m) {
            LinkedHashSet<Unit> res = null;
            for (Unit u : m.getActiveBody().getUnits()) {
                if (!ObservableDynamicICFG.this.isCallStmt(u)) continue;
                if (res == null) {
                    res = new LinkedHashSet<Unit>();
                }
                res.add(u);
            }
            return res == null ? Collections.emptySet() : res;
        }
    });

    public ObservableDynamicICFG(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
        this.solver = new Boomerang(){

            @Override
            public ObservableICFG<Unit, SootMethod> icfg() {
                return ObservableDynamicICFG.this;
            }
        };
        this.precomputedCallGraph = Scene.v().getCallGraph();
        this.initializeUnitToOwner();
    }

    public ObservableDynamicICFG(WeightedBoomerang<? extends Weight> solver) {
        this(solver, true);
    }

    public ObservableDynamicICFG(WeightedBoomerang<? extends Weight> solver, boolean enableExceptions) {
        this.solver = solver;
        this.enableExceptions = enableExceptions;
        this.precomputedCallGraph = Scene.v().getCallGraph();
        this.initializeUnitToOwner();
    }

    @Override
    public SootMethod getMethodOf(Unit unit) {
        assert (this.unitToOwner.containsKey(unit)) : "Statement " + unit + " not in unit-to-owner mapping";
        Body b = this.unitToOwner.get(unit);
        return b == null ? null : b.getMethod();
    }

    @Override
    public List<Unit> getPredsOf(Unit unit) {
        assert (unit != null);
        Body body = this.unitToOwner.get(unit);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getPredsOf((Object)unit);
    }

    @Override
    public List<Unit> getSuccsOf(Unit unit) {
        Body body = this.unitToOwner.get(unit);
        if (body == null) {
            return Collections.emptyList();
        }
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getSuccsOf((Object)unit);
    }

    private DirectedGraph<Unit> getOrCreateUnitGraph(Body body) {
        return (DirectedGraph)this.bodyToUnitGraph.getUnchecked((Object)body);
    }

    @Override
    public void addCalleeListener(CalleeListener<Unit, SootMethod> listener) {
        if (!this.calleeListeners.put((Object)listener.getObservedCaller(), listener)) {
            return;
        }
        Unit unit = listener.getObservedCaller();
        Stmt stmt = (Stmt)unit;
        Iterator edgeIterator = this.demandDrivenCallGraph.edgesOutOf(unit);
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            listener.onCalleeAdded(unit, edge.tgt());
        }
        InvokeExpr ie = stmt.getInvokeExpr();
        if (ie instanceof InstanceInvokeExpr) {
            if (ie instanceof SpecialInvokeExpr) {
                this.addCallIfNotInGraph(unit, ie.getMethod(), Kind.SPECIAL);
            } else if (this.precomputedCallGraph != null && this.potentiallyHasMoreEdges(this.precomputedCallGraph.edgesOutOf(unit), this.demandDrivenCallGraph.edgesOutOf(unit))) {
                this.queryForCallees(unit);
            }
        } else {
            this.addCallIfNotInGraph(unit, ie.getMethod(), Kind.STATIC);
        }
    }

    private void queryForCallees(Unit unit) {
        logger.debug("Queried for callees of '{}'.", (Object)unit);
        Stmt stmt = (Stmt)unit;
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        Value value = ((InstanceInvokeExpr)invokeExpr).getBase();
        Val val = new Val(value, this.getMethodOf((Unit)stmt));
        for (Unit pred : this.getPredsOf((Unit)stmt)) {
            Statement statement = new Statement((Stmt)pred, this.getMethodOf(unit));
            BackwardQuery query = new BackwardQuery(statement, val);
            this.solver.solve(query, false);
            this.forAnyAllocationSiteOfQuery(query, invokeExpr, stmt);
        }
    }

    private void forAnyAllocationSiteOfQuery(BackwardQuery query, InvokeExpr invokeExpr, Stmt unit) {
        this.solver.registerSolverCreationListener(new IterateSolvers(query, unit, invokeExpr));
    }

    private Collection<SootMethod> getMethodFromClassOrFromSuperclass(SootMethod method, SootClass sootClass) {
        HashSet res = Sets.newHashSet();
        SootClass originalClass = sootClass;
        while (sootClass != null) {
            for (SootMethod candidate : sootClass.getMethods()) {
                if (!candidate.getSubSignature().equals(method.getSubSignature())) continue;
                res.add(candidate);
            }
            this.handlingForThreading(method, sootClass, res);
            if (!res.isEmpty()) {
                return res;
            }
            if (sootClass.hasSuperclass()) {
                sootClass = sootClass.getSuperclass();
                continue;
            }
            logger.error("Did not find method {} for class {}", (Object)method, (Object)originalClass);
            return res;
        }
        logger.error("Did not find method {} for class {}", (Object)method, (Object)originalClass);
        return res;
    }

    private void handlingForThreading(SootMethod method, SootClass sootClass, Set<SootMethod> res) {
        if (Scene.v().getFastHierarchy().isSubclass(sootClass, Scene.v().getSootClass(THREAD_CLASS)) && method.getSignature().equals(THREAD_START_SIGNATURE)) {
            for (SootMethod candidate : sootClass.getMethods()) {
                if (!candidate.getSubSignature().equals(THREAD_RUN_SUB_SIGNATURE)) continue;
                res.add(candidate);
            }
        }
    }

    @Override
    public void addCallerListener(CallerListener<Unit, SootMethod> listener) {
        if (!this.callerListeners.put((Object)listener.getObservedCallee(), listener)) {
            return;
        }
        SootMethod method = listener.getObservedCallee();
        logger.debug("Queried for callers of {}.", (Object)method);
        Iterator edgeIterator = this.demandDrivenCallGraph.edgesInto((MethodOrMethodContext)method);
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            listener.onCallerAdded(edge.srcUnit(), method);
        }
    }

    private boolean potentiallyHasMoreEdges(Iterator<Edge> chaEdgeIterator, Iterator<Edge> knownEdgeIterator) {
        HashMap<Edge, Boolean> wasEdgeCovered = new HashMap<Edge, Boolean>();
        while (chaEdgeIterator.hasNext()) {
            wasEdgeCovered.put(chaEdgeIterator.next(), false);
        }
        while (knownEdgeIterator.hasNext()) {
            wasEdgeCovered.put(knownEdgeIterator.next(), true);
        }
        for (Boolean edgeWasCovered : wasEdgeCovered.values()) {
            if (edgeWasCovered.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Unit> getAllPrecomputedCallers(SootMethod sootMethod) {
        if (this.precomputedCallGraph == null) {
            return Collections.emptySet();
        }
        if (!this.options.fallbackOnPrecomputedForUnbalanced()) {
            return Collections.emptySet();
        }
        assert (this.unbalancedMethods.contains(sootMethod));
        logger.debug("Getting precomputed callers of {}", (Object)sootMethod);
        HashSet<Unit> callers = new HashSet<Unit>();
        Iterator precomputedCallers = this.precomputedCallGraph.edgesInto((MethodOrMethodContext)sootMethod);
        while (precomputedCallers.hasNext()) {
            Edge methodCall = (Edge)precomputedCallers.next();
            if (methodCall.srcUnit() == null) continue;
            callers.add(methodCall.srcUnit());
            this.unbalancedMethods.add(methodCall.src());
            boolean wasPrecomputedAdded = this.addCallIfNotInGraph(methodCall.srcUnit(), methodCall.tgt(), methodCall.kind());
            if (!wasPrecomputedAdded) continue;
            ++this.numberOfEdgesTakenFromPrecomputedCallGraph;
        }
        return callers;
    }

    private boolean addCallIfNotInGraph(Unit caller, SootMethod callee, Kind kind) {
        Edge edge = new Edge((MethodOrMethodContext)this.getMethodOf(caller), caller, (MethodOrMethodContext)callee, kind);
        if (!this.demandDrivenCallGraph.addEdge(edge)) {
            return false;
        }
        logger.debug("Added call from unit '{}' to method '{}'", (Object)caller, (Object)callee);
        for (Object listener : Lists.newArrayList((Iterable)this.calleeListeners.get((Object)caller))) {
            listener.onCalleeAdded(caller, callee);
        }
        for (Object listener : Lists.newArrayList((Iterable)this.callerListeners.get((Object)callee))) {
            listener.onCallerAdded(caller, callee);
        }
        return true;
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod sootMethod) {
        return (Set)this.methodToCallsFromWithin.getUnchecked((Object)sootMethod);
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod sootMethod) {
        if (sootMethod.hasActiveBody()) {
            Body body = sootMethod.getActiveBody();
            DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
            return unitGraph.getHeads();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isCallStmt(Unit unit) {
        return ((Stmt)unit).containsInvokeExpr();
    }

    @Override
    public boolean isExitStmt(Unit unit) {
        Body body = this.unitToOwner.get(unit);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getTails().contains(unit);
    }

    @Override
    public boolean isStartPoint(Unit unit) {
        Body body = this.unitToOwner.get(unit);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getHeads().contains(unit);
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        LinkedHashSet<Unit> res = new LinkedHashSet<Unit>(this.unitToOwner.keySet());
        res.removeIf(u -> this.isStartPoint((Unit)u) || this.isCallStmt((Unit)u));
        return res;
    }

    @Override
    public Collection<Unit> getEndPointsOf(SootMethod sootMethod) {
        if (sootMethod.hasActiveBody()) {
            Body body = sootMethod.getActiveBody();
            DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
            return unitGraph.getTails();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Unit> allNonCallEndNodes() {
        LinkedHashSet<Unit> res = new LinkedHashSet<Unit>(this.unitToOwner.keySet());
        res.removeIf(u -> this.isExitStmt((Unit)u) || this.isCallStmt((Unit)u));
        return res;
    }

    @Override
    public List<Value> getParameterRefs(SootMethod sootMethod) {
        return (List)this.methodToParameterRefs.getUnchecked((Object)sootMethod);
    }

    @Override
    public boolean isReachable(Unit u) {
        return this.unitToOwner.containsKey(u);
    }

    private void initializeUnitToOwner() {
        QueueReader iter = Scene.v().getReachableMethods().listener();
        while (iter.hasNext()) {
            SootMethod m = ((MethodOrMethodContext)iter.next()).method();
            if (!m.hasActiveBody()) continue;
            Body b = m.getActiveBody();
            UnitPatchingChain units = b.getUnits();
            for (Unit unit : units) {
                this.unitToOwner.put(unit, b);
            }
        }
    }

    @Override
    public CallGraph getCallGraphCopy() {
        CallGraph copy = new CallGraph();
        for (Edge edge : this.demandDrivenCallGraph) {
            Edge edgeCopy = new Edge((MethodOrMethodContext)edge.src(), edge.srcUnit(), (MethodOrMethodContext)edge.tgt(), edge.kind());
            copy.addEdge(edgeCopy);
        }
        return copy;
    }

    @Override
    public boolean isUnbalancedMethod(SootMethod method) {
        return this.unbalancedMethods.contains(method);
    }

    @Override
    public void addUnbalancedMethod(SootMethod method) {
        this.unbalancedMethods.add(method);
    }

    @Override
    public int getNumberOfEdgesTakenFromPrecomputedGraph() {
        return this.numberOfEdgesTakenFromPrecomputedCallGraph;
    }

    @Override
    public void resetCallGraph() {
        this.demandDrivenCallGraph = new CallGraph();
        this.numberOfEdgesTakenFromPrecomputedCallGraph = 0;
        this.unbalancedMethods.clear();
        this.calleeListeners.clear();
        this.callerListeners.clear();
    }

    private final class IterateSolvers
    implements SolverCreationListener {
        private final BackwardQuery query;
        private final Stmt unit;
        private final InvokeExpr invokeExpr;

        private IterateSolvers(BackwardQuery query, Stmt unit, InvokeExpr invokeExpr) {
            this.query = query;
            this.unit = unit;
            this.invokeExpr = invokeExpr;
        }

        public void onCreatedSolver(Query q, AbstractBoomerangSolver solver) {
            if (solver instanceof ForwardBoomerangSolver) {
                final ForwardQuery forwardQuery = (ForwardQuery)q;
                ForwardBoomerangSolver forwardBoomerangSolver = (ForwardBoomerangSolver)solver;
                INode initialState = (INode)forwardBoomerangSolver.getFieldAutomaton().getInitialState();
                forwardBoomerangSolver.getFieldAutomaton().registerListener((WPAStateListener)new ExtractAllocationSiteStateListener(initialState, this.query, (ForwardQuery)q){

                    @Override
                    protected void allocationSiteFound(ForwardQuery allocationSite, BackwardQuery query) {
                        block3: {
                            Type base;
                            Type type;
                            block2: {
                                logger.debug("Found AllocationSite '{}'.", (Object)forwardQuery);
                                type = forwardQuery.getType();
                                if (!(type instanceof RefType)) break block2;
                                for (SootMethod calleeMethod : ObservableDynamicICFG.this.getMethodFromClassOrFromSuperclass(IterateSolvers.this.invokeExpr.getMethod(), ((RefType)type).getSootClass())) {
                                    ObservableDynamicICFG.this.addCallIfNotInGraph((Unit)IterateSolvers.this.unit, calleeMethod, Kind.VIRTUAL);
                                }
                                break block3;
                            }
                            if (!(type instanceof ArrayType) || !((base = ((ArrayType)type).baseType) instanceof RefType)) break block3;
                            for (SootMethod calleeMethod : ObservableDynamicICFG.this.getMethodFromClassOrFromSuperclass(IterateSolvers.this.invokeExpr.getMethod(), ((RefType)base).getSootClass())) {
                                ObservableDynamicICFG.this.addCallIfNotInGraph((Unit)IterateSolvers.this.unit, calleeMethod, Kind.VIRTUAL);
                            }
                        }
                    }
                });
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IterateSolvers other = (IterateSolvers)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }

        private ObservableDynamicICFG getOuterType() {
            return ObservableDynamicICFG.this;
        }
    }
}

