/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.Query;
import boomerang.callgraph.ObservableICFG;
import boomerang.callgraph.ObservableStaticICFG;
import boomerang.debugger.Debugger;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Kind;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import wpds.impl.Weight;

public class CallGraphDebugger<W extends Weight>
extends Debugger<W> {
    private static final Logger logger = LoggerFactory.getLogger(CallGraphDebugger.class);
    private File dotFile;
    private ObservableICFG<Unit, SootMethod> icfg;
    private CallGraph callGraph;
    private HashSet<Unit> totalCallSites = new HashSet();
    private Multimap<Unit, SootMethod> virtualCallSites = HashMultimap.create();
    private int numVirtualCallSites;
    private int numVirtualCallSitesSingleTarget;
    private int numVirtualCallSitesMultipleTarget;
    private float avgNumTargetsVirtualCallSites;
    private float avgNumTargetMultiTargetCallSites;
    private Multimap<SootMethod, Unit> predecessors = HashMultimap.create();
    private float avgNumOfPredecessors;
    private int numOfEdgesInCallGraph;
    private int numEdgesFromPrecomputed;
    private static int seedNumber = 0;

    public CallGraphDebugger(File dotFile, ObservableICFG<Unit, SootMethod> icfg) {
        this.dotFile = dotFile;
        this.icfg = icfg;
    }

    @Override
    public void done(Map<Query, AbstractBoomerangSolver<W>> queryToSolvers) {
        this.callGraph = this.icfg.getCallGraphCopy();
        if (this.icfg instanceof ObservableStaticICFG) {
            if (this.dotFile.exists()) {
                return;
            }
        } else {
            if (++seedNumber % 2 == 0) {
                return;
            }
            int actualSeedNumber = seedNumber / 2 + 1;
            String dotFileName = this.dotFile.getAbsolutePath();
            dotFileName = dotFileName.substring(0, dotFileName.lastIndexOf(46)) + actualSeedNumber + ".dot";
            this.dotFile = new File(dotFileName);
        }
        logger.info("Starting to compute visualization.");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph callgraph { \n");
        stringBuilder.append("node [margin=0, shape=box]; \n");
        this.addMethodsToDotfile(stringBuilder);
        stringBuilder.append("}");
        try (FileWriter file = new FileWriter(this.dotFile);){
            logger.trace("Writing visualization to file {}", (Object)this.dotFile.getAbsolutePath());
            file.write(stringBuilder.toString());
            logger.info("Visualization available in file {}", (Object)this.dotFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.info("Exception in writing to visualization file {} : {}", (Object)this.dotFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    private void addMethodsToDotfile(StringBuilder stringBuilder) {
        for (Edge edge : this.callGraph) {
            this.addMethodToDotFile(stringBuilder, edge.src());
            stringBuilder.append(" -> ");
            this.addMethodToDotFile(stringBuilder, edge.tgt());
            stringBuilder.append("; \n");
        }
    }

    private void addMethodToDotFile(StringBuilder stringBuilder, SootMethod method) {
        stringBuilder.append('\"');
        stringBuilder.append(method);
        stringBuilder.append('\"');
    }

    private void computeCallGraphStatistics() {
        this.numOfEdgesInCallGraph = this.callGraph.size();
        for (Edge edge : this.callGraph) {
            Unit srcUnit = edge.srcUnit();
            this.totalCallSites.add(srcUnit);
            if (!edge.kind().equals(Kind.VIRTUAL)) continue;
            this.virtualCallSites.put((Object)srcUnit, (Object)edge.tgt());
            this.predecessors.put((Object)edge.tgt(), (Object)srcUnit);
        }
        this.computeVirtualCallSiteMetrics();
        this.computePredecessorMetrics();
        if (this.icfg != null) {
            this.numEdgesFromPrecomputed = this.icfg.getNumberOfEdgesTakenFromPrecomputedGraph();
        }
        if (this.numEdgesFromPrecomputed < 0) {
            this.numEdgesFromPrecomputed = this.numOfEdgesInCallGraph;
        }
    }

    private void computeVirtualCallSiteMetrics() {
        this.numVirtualCallSites = this.virtualCallSites.keySet().size();
        int totalTargetsVirtualCallSites = 0;
        for (Map.Entry entry : this.virtualCallSites.asMap().entrySet()) {
            int targets = ((Collection)entry.getValue()).size();
            if (targets > 1) {
                ++this.numVirtualCallSitesMultipleTarget;
            } else if (targets == 1) {
                ++this.numVirtualCallSitesSingleTarget;
            }
            totalTargetsVirtualCallSites += targets;
        }
        this.avgNumTargetsVirtualCallSites = (float)totalTargetsVirtualCallSites / (float)this.numVirtualCallSites;
        this.avgNumTargetMultiTargetCallSites = (float)totalTargetsVirtualCallSites / (float)this.numVirtualCallSitesMultipleTarget;
    }

    private void computePredecessorMetrics() {
        int numMethods = this.predecessors.keySet().size();
        int totalPredecessors = 0;
        for (Map.Entry entry : this.predecessors.asMap().entrySet()) {
            totalPredecessors += ((Collection)entry.getValue()).size();
        }
        this.avgNumOfPredecessors = (float)totalPredecessors / (float)numMethods;
    }

    public String getCsvHeader() {
        return "numOfEdgesInCallGraph; totalCallSites; virtualCallSites; virtualCallSitesSingleTarget; virtualCallSitesMultipleTarget; avgNumTargetsVirtualCallSites; avgNumTargetMultiTargetCallSites;avgNumOfPredecessors; edgesFromPrecomputed;";
    }

    public String getCallGraphStatisticsAsCsv() {
        this.computeCallGraphStatistics();
        return String.valueOf(this.numOfEdgesInCallGraph) + ';' + this.totalCallSites.size() + ';' + this.numVirtualCallSites + ';' + this.numVirtualCallSitesSingleTarget + ';' + this.numVirtualCallSitesMultipleTarget + ';' + this.avgNumTargetsVirtualCallSites + ';' + this.avgNumTargetMultiTargetCallSites + ';' + this.avgNumOfPredecessors + ';' + this.numEdgesFromPrecomputed + ';';
    }
}

