/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.BackwardQuery;
import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.util.RegExAccessPath;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.NormalRule;
import wpds.impl.Rule;
import wpds.impl.Weight;

public class IDEVizDebugger<W extends Weight>
extends Debugger<W> {
    private static boolean ONLY_CFG = false;
    private static final Logger logger = LoggerFactory.getLogger(IDEVizDebugger.class);
    private File ideVizFile;
    private ObservableICFG<Unit, SootMethod> icfg;
    private Table<Query, SootMethod, Set<Rule<Statement, INode<Val>, W>>> rules = HashBasedTable.create();
    private Map<Object, Integer> objectToInteger = new HashMap<Object, Integer>();
    private int charSize;

    public IDEVizDebugger(File ideVizFile, ObservableICFG<Unit, SootMethod> icfg) {
        this.ideVizFile = ideVizFile;
        this.icfg = icfg;
    }

    private void callRules(Query q, Set<Rule<Statement, INode<Val>, W>> allRules) {
        for (Rule<Statement, INode<Val>, W> e : allRules) {
            Statement stmt = (Statement)e.getL1();
            if (stmt.getMethod() == null) continue;
            Set<Rule<Statement, INode<Val>, W>> transInMethod = this.getOrCreateRuleSet(q, stmt.getMethod());
            transInMethod.add(e);
        }
    }

    private Set<Rule<Statement, INode<Val>, W>> getOrCreateRuleSet(Query q, SootMethod method) {
        Set map = (Set)this.rules.get((Object)q, (Object)method);
        if (map != null) {
            return map;
        }
        this.rules.put((Object)q, (Object)method, (Object)Sets.newHashSet());
        return (Set)this.rules.get((Object)q, (Object)method);
    }

    @Override
    public void done(Map<Query, AbstractBoomerangSolver<W>> solvers) {
        logger.warn("Starting to compute visualization, this requires a large amount of memory, please ensure the VM has enough memory.");
        Stopwatch watch = Stopwatch.createStarted();
        JSONArray eventualData = new JSONArray();
        if (!ONLY_CFG) {
            for (Query q : solvers.keySet()) {
                this.callRules(q, solvers.get(q).getCallPDS().getAllRules());
            }
        }
        for (Map.Entry e : Lists.newArrayList(solvers.entrySet())) {
            logger.debug("Computing results for {}", e.getKey());
            Query query = (Query)e.getKey();
            JSONQuery queryJSON = new JSONQuery(query);
            JSONArray data = new JSONArray();
            for (SootMethod m : Lists.newArrayList(((AbstractBoomerangSolver)((Object)e.getValue())).getReachableMethods())) {
                Table results = ((AbstractBoomerangSolver)((Object)e.getValue())).getResults(m);
                if (results.isEmpty()) continue;
                int labelYOffset = ONLY_CFG ? 0 : this.computeLabelYOffset(results.columnKeySet());
                JSONMethod jsonMethod = new JSONMethod(m);
                logger.debug("Creating control-flow graph for {}", (Object)m);
                JSONControlFlowGraph cfg = this.createControlFlowGraph(m, labelYOffset);
                jsonMethod.put("cfg", (Object)cfg);
                if (!ONLY_CFG) {
                    Set<Rule<Statement, INode<Val>, W>> rulesInMethod = this.getOrCreateRuleSet(query, m);
                    logger.debug("Creating data-flow graph for {}", (Object)m);
                    DataFlowGraph dfg = this.createDataFlowGraph(query, results, rulesInMethod, cfg, m, labelYOffset);
                    jsonMethod.put("dfg", (Object)dfg);
                }
                data.add((Object)jsonMethod);
            }
            queryJSON.put("methods", data);
            eventualData.add((Object)queryJSON);
        }
        logger.info("Computing visualization took: {}", (Object)watch.elapsed());
        try (FileWriter file = new FileWriter(this.ideVizFile);){
            logger.info("Writing visualization to file {}", (Object)this.ideVizFile.getAbsolutePath());
            file.write(eventualData.toJSONString());
            logger.info("Visualization available in file {}", (Object)this.ideVizFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info("Exception in writing to visualization file {}", (Object)this.ideVizFile.getAbsolutePath());
        }
    }

    private int computeLabelYOffset(Set<RegExAccessPath> facts) {
        int labelYOffset = 0;
        for (RegExAccessPath g : facts) {
            labelYOffset = Math.max(labelYOffset, this.charSize * g.toString().length());
        }
        return labelYOffset;
    }

    private DataFlowGraph createDataFlowGraph(Query q, Table<Statement, RegExAccessPath, W> table, Set<Rule<Statement, INode<Val>, W>> rulesInMethod, JSONControlFlowGraph cfg, SootMethod m, int labelYOffset) {
        LinkedList<RegExAccessPath> factsList = new LinkedList<RegExAccessPath>();
        DataFlowGraph dataFlowGraph = new DataFlowGraph();
        Set facts = table.columnKeySet();
        JSONArray data = new JSONArray();
        int offset = 0;
        int charSize = 8;
        for (RegExAccessPath u : facts) {
            JSONObject jSONObject = new JSONObject();
            JSONObject pos = new JSONObject();
            factsList.add(u);
            pos.put((Object)"x", (Object)(factsList.size() * 30 + offset * charSize));
            pos.put((Object)"y", (Object)labelYOffset);
            jSONObject.put((Object)"position", (Object)pos);
            JSONObject label = new JSONObject();
            label.put((Object)"label", (Object)u.toString());
            label.put((Object)"factId", (Object)this.id(u));
            jSONObject.put((Object)"classes", (Object)("fact label method" + this.id(m)));
            jSONObject.put((Object)"data", (Object)label);
            data.add((Object)jSONObject);
        }
        HashMultimap esgNodes = HashMultimap.create();
        for (Table.Cell cell : table.cellSet()) {
            Statement statement = (Statement)cell.getRowKey();
            Stmt stmt = (Stmt)statement.getUnit().get();
            RegExAccessPath val = (RegExAccessPath)cell.getColumnKey();
            if (!((Statement)cell.getRowKey()).getMethod().equals(val.getVal().m())) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            pos.put((Object)"x", (Object)((factsList.indexOf(val) + 1) * 30));
            pos.put((Object)"y", (Object)(cfg.stmtsList.indexOf(stmt) * 30 + (q instanceof BackwardQuery ? 30 : 0)));
            nodeObj.put((Object)"position", (Object)pos);
            String classes = "esgNode method" + this.id(m) + " ";
            JSONObject additionalData = new JSONObject();
            additionalData.put((Object)"id", (Object)("q" + this.id(q) + "n" + this.id(new Node((Object)statement, (Object)val))));
            additionalData.put((Object)"stmtId", (Object)this.id(stmt));
            additionalData.put((Object)"factId", (Object)this.id(val));
            if (cell.getValue() != null) {
                additionalData.put((Object)"ideValue", (Object)((Weight)cell.getValue()).toString());
            }
            nodeObj.put((Object)"classes", (Object)classes);
            nodeObj.put((Object)"group", (Object)"nodes");
            nodeObj.put((Object)"data", (Object)additionalData);
            data.add((Object)nodeObj);
            esgNodes.put((Object)new Node((Object)statement, (Object)val.getVal()), (Object)val);
        }
        for (Rule rule : rulesInMethod) {
            if (!(rule instanceof NormalRule)) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject dataEntry = new JSONObject();
            dataEntry.put((Object)"id", (Object)("e" + this.id(rule)));
            Node<Statement, Val> start = this.getStartNode(rule);
            Node<Statement, Val> target = this.getTargetNode(rule);
            for (RegExAccessPath startField : esgNodes.get(start)) {
                for (RegExAccessPath targetField : esgNodes.get(target)) {
                    dataEntry.put((Object)"source", (Object)("q" + this.id(q) + "n" + this.id(new Node(start.stmt(), (Object)startField))));
                    dataEntry.put((Object)"target", (Object)("q" + this.id(q) + "n" + this.id(new Node(target.stmt(), (Object)targetField))));
                    dataEntry.put((Object)"directed", (Object)"true");
                    dataEntry.put((Object)"direction", (Object)(q instanceof BackwardQuery ? "Backward" : "Forward"));
                    nodeObj.put((Object)"data", (Object)dataEntry);
                    nodeObj.put((Object)"classes", (Object)("esgEdge  method" + this.id(m)));
                    nodeObj.put((Object)"group", (Object)"edges");
                    data.add((Object)nodeObj);
                }
            }
        }
        dataFlowGraph.put("dataFlowNode", data);
        return dataFlowGraph;
    }

    private Node<Statement, Val> getTargetNode(Rule<Statement, INode<Val>, W> rule) {
        return new Node((Object)rule.getL2(), ((INode)rule.getS2()).fact());
    }

    private Node<Statement, Val> getStartNode(Rule<Statement, INode<Val>, W> rule) {
        return new Node((Object)rule.getL1(), ((INode)rule.getS1()).fact());
    }

    private JSONControlFlowGraph createControlFlowGraph(SootMethod m, int labelYOffset) {
        JSONControlFlowGraph cfg = new JSONControlFlowGraph();
        int index = 0;
        int offset = 0;
        JSONArray data = new JSONArray();
        for (Unit u : m.getActiveBody().getUnits()) {
            JSONArray callees;
            if (this.icfg.getMethodOf(u) == null) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            cfg.stmtsList.add(u);
            pos.put((Object)"x", (Object)10);
            pos.put((Object)"y", (Object)(cfg.stmtsList.size() * 30 + labelYOffset));
            nodeObj.put((Object)"position", (Object)pos);
            JSONObject label = new JSONObject();
            label.put((Object)"label", (Object)u.toString());
            label.put((Object)"shortLabel", (Object)this.getShortLabel(u));
            if (this.icfg.isCallStmt(u)) {
                label.put((Object)"callSite", (Object)this.icfg.isCallStmt(u));
                callees = new JSONArray();
                this.icfg.addCalleeListener(new JsonCalleeListener(u, callees));
                label.put((Object)"callees", (Object)callees);
            }
            if (this.icfg.isExitStmt(u)) {
                label.put((Object)"returnSite", (Object)this.icfg.isExitStmt(u));
                callees = new JSONArray();
                HashSet<SootMethod> callers = new HashSet<SootMethod>();
                this.icfg.addCallerListener(new JsonCallerListener(u, callers));
                for (SootMethod caller : callers) {
                    callees.add((Object)new JSONMethod(caller));
                }
                label.put((Object)"callers", (Object)callees);
            }
            label.put((Object)"stmtId", (Object)this.id(u));
            label.put((Object)"id", (Object)("stmt" + this.id(u)));
            label.put((Object)"stmtIndex", (Object)index);
            ++index;
            nodeObj.put((Object)"data", (Object)label);
            nodeObj.put((Object)"classes", (Object)("stmt label " + (this.icfg.isExitStmt(u) ? " returnSite " : " ") + (this.icfg.isCallStmt(u) ? " callSite " : " ") + " method" + this.id(m)));
            data.add((Object)nodeObj);
            offset = Math.max(offset, this.getShortLabel(u).toString().length());
            for (Unit succ : this.icfg.getSuccsOf(u)) {
                JSONObject cfgEdgeObj = new JSONObject();
                JSONObject dataEntry = new JSONObject();
                dataEntry.put((Object)"source", (Object)("stmt" + this.id(u)));
                dataEntry.put((Object)"target", (Object)("stmt" + this.id(succ)));
                dataEntry.put((Object)"directed", (Object)"true");
                cfgEdgeObj.put((Object)"data", (Object)dataEntry);
                cfgEdgeObj.put((Object)"classes", (Object)("cfgEdge label method" + this.id(m)));
                data.add((Object)cfgEdgeObj);
            }
        }
        cfg.put("controlFlowNode", data);
        return cfg;
    }

    private String getShortLabel(Unit u) {
        if (u instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)u;
            if (assignStmt.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = " + fr.getBase() + "." + fr.getField().getName();
            }
            if (assignStmt.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getLeftOp();
                return fr.getBase() + "." + fr.getField().getName() + " = " + assignStmt.getRightOp();
            }
        }
        if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr()) {
            InvokeExpr invokeExpr = ((Stmt)u).getInvokeExpr();
            if (invokeExpr instanceof StaticInvokeExpr) {
                return (u instanceof AssignStmt ? ((AssignStmt)u).getLeftOp() + " = " : "") + invokeExpr.getMethod().getName() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
            if (invokeExpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)invokeExpr;
                return (u instanceof AssignStmt ? ((AssignStmt)u).getLeftOp() + " = " : "") + iie.getBase() + "." + invokeExpr.getMethod().getName() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
        }
        return u.toString();
    }

    public Integer id(Object u) {
        if (this.objectToInteger.get(u) != null) {
            return this.objectToInteger.get(u);
        }
        int size = this.objectToInteger.size() + 1;
        this.objectToInteger.put(u, size);
        return size;
    }

    private class DataFlowGraph
    extends JSONObject {
        private DataFlowGraph() {
        }
    }

    private class JSONControlFlowGraph
    extends JSONObject {
        public List<Unit> stmtsList = Lists.newLinkedList();

        private JSONControlFlowGraph() {
        }
    }

    private class JSONQuery
    extends JSONObject {
        JSONQuery(Query m) {
            this.put("query", StringEscapeUtils.escapeHtml4((String)this.prettyPrintQuery(m)));
            this.put("id", IDEVizDebugger.this.id(m));
        }

        private String prettyPrintQuery(Query m) {
            return (m instanceof BackwardQuery ? "B " : "F ") + ((Val)m.asNode().fact()).value() + " @ " + ((Statement)m.asNode().stmt()).getMethod().getName();
        }
    }

    private class JSONMethod
    extends JSONObject {
        JSONMethod(SootMethod m) {
            this.put("methodName", StringEscapeUtils.escapeHtml4((String)m.toString()));
            this.put("id", IDEVizDebugger.this.id(m));
        }
    }

    private class JsonCallerListener
    implements CallerListener<Unit, SootMethod> {
        Unit u;
        Set<SootMethod> callers;

        JsonCallerListener(Unit u, Set<SootMethod> callers) {
            this.u = u;
            this.callers = callers;
        }

        @Override
        public SootMethod getObservedCallee() {
            return (SootMethod)IDEVizDebugger.this.icfg.getMethodOf(this.u);
        }

        @Override
        public void onCallerAdded(Unit unit, SootMethod sootMethod) {
            this.callers.add((SootMethod)IDEVizDebugger.this.icfg.getMethodOf(unit));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCallerListener that = (JsonCallerListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callers, that.callers);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callers);
        }
    }

    private class JsonCalleeListener
    implements CalleeListener<Unit, SootMethod> {
        Unit u;
        JSONArray callees;

        JsonCalleeListener(Unit u, JSONArray callees) {
            this.u = u;
            this.callees = callees;
        }

        @Override
        public Unit getObservedCaller() {
            return this.u;
        }

        @Override
        public void onCalleeAdded(Unit unit, SootMethod sootMethod) {
            if (sootMethod != null && sootMethod.toString() != null) {
                this.callees.add((Object)new JSONMethod(sootMethod));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCalleeListener that = (JsonCalleeListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callees, that.callees);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callees);
        }
    }
}

