/*
 * Decompiled with CFR 0.152.
 */
package boomerang.preanalysis;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;

public class BoomerangPretransformer
extends BodyTransformer {
    public static boolean TRANSFORM_CONSTANTS = true;
    private static BoomerangPretransformer instance;
    private int replaceCounter;
    private boolean applied;

    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        this.addNopStmtToMethods(b);
        if (TRANSFORM_CONSTANTS) {
            this.transformConstantAtFieldWrites(b);
        }
    }

    private void transformConstantAtFieldWrites(Body body) {
        Set<Unit> cwnc = this.getStmtsWithConstants(body);
        for (Unit u : cwnc) {
            JReturnStmt other;
            JAssignStmt newUnit;
            JimpleLocal paramVal;
            String label;
            AssignStmt assignStmt;
            if (u instanceof AssignStmt && this.isFieldRef((assignStmt = (AssignStmt)u).getLeftOp()) && assignStmt.getRightOp() instanceof Constant && !(assignStmt.getRightOp() instanceof ClassConstant)) {
                label = "varReplacer" + new Integer(this.replaceCounter++).toString();
                paramVal = new JimpleLocal(label, assignStmt.getRightOp().getType());
                newUnit = new JAssignStmt((Value)paramVal, assignStmt.getRightOp());
                body.getLocals().add((Object)paramVal);
                body.getUnits().insertBefore((Unit)newUnit, u);
                other = new JAssignStmt(assignStmt.getLeftOp(), (Value)paramVal);
                body.getUnits().insertBefore((Unit)other, u);
                body.getUnits().remove((Object)u);
            }
            if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr() && !u.toString().contains("test.assertions.Assertions:") && !u.toString().contains("intQueryFor")) {
                Stmt stmt = (Stmt)u;
                if (stmt.getInvokeExpr().getMethod().getSignature().equals("<java.math.BigInteger: java.math.BigInteger valueOf(long)>")) continue;
                List useBoxes = stmt.getInvokeExpr().getUseBoxes();
                for (Value v : stmt.getInvokeExpr().getArgs()) {
                    if (!(v instanceof Constant) || v instanceof ClassConstant) continue;
                    String label2 = "varReplacer" + new Integer(this.replaceCounter++).toString();
                    JimpleLocal paramVal2 = new JimpleLocal(label2, v.getType());
                    JAssignStmt newUnit2 = new JAssignStmt((Value)paramVal2, v);
                    body.getLocals().add((Object)paramVal2);
                    body.getUnits().insertBefore((Unit)newUnit2, u);
                    for (ValueBox b : useBoxes) {
                        if (!b.getValue().equals(v)) continue;
                        b.setValue((Value)paramVal2);
                    }
                }
            }
            if (!(u instanceof ReturnStmt)) continue;
            ReturnStmt returnStmt = (ReturnStmt)u;
            label = "varReplacer" + new Integer(this.replaceCounter++).toString();
            paramVal = new JimpleLocal(label, returnStmt.getOp().getType());
            newUnit = new JAssignStmt((Value)paramVal, returnStmt.getOp());
            body.getLocals().add((Object)paramVal);
            body.getUnits().insertBefore((Unit)newUnit, u);
            other = new JReturnStmt((Value)paramVal);
            body.getUnits().insertBefore((Unit)other, u);
            body.getUnits().remove((Object)u);
        }
    }

    private void addNopStmtToMethods(Body b) {
        b.getUnits().insertBefore((Unit)new JNopStmt(), b.getUnits().getFirst());
    }

    private Set<Unit> getStmtsWithConstants(Body methodBody) {
        HashSet retMap = Sets.newHashSet();
        for (Unit u : methodBody.getUnits()) {
            AssignStmt assignStmt;
            if (u instanceof AssignStmt && this.isFieldRef((assignStmt = (AssignStmt)u).getLeftOp()) && assignStmt.getRightOp() instanceof Constant) {
                retMap.add(u);
            }
            if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr()) {
                Stmt stmt = (Stmt)u;
                for (Value v : stmt.getInvokeExpr().getArgs()) {
                    if (!(v instanceof Constant)) continue;
                    retMap.add(u);
                }
            }
            if (!(u instanceof ReturnStmt) || !((assignStmt = (ReturnStmt)u).getOp() instanceof Constant)) continue;
            retMap.add(u);
        }
        return retMap;
    }

    private boolean isFieldRef(Value op) {
        return op instanceof InstanceFieldRef || op instanceof StaticFieldRef;
    }

    public void apply() {
        if (this.applied) {
            return;
        }
        ReachableMethods reachableMethods = Scene.v().getReachableMethods();
        QueueReader listener = reachableMethods.listener();
        while (listener.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)listener.next()).method();
            if (!method.hasActiveBody()) continue;
            this.internalTransform(method.getActiveBody(), "", new HashMap<String, String>());
        }
        this.applied = true;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public static BoomerangPretransformer v() {
        if (instance == null) {
            instance = new BoomerangPretransformer();
        }
        return instance;
    }

    public void reset() {
        instance = null;
    }
}

