/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.Util;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.AbstractBoomerangResults;
import boomerang.results.NullPointer;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import heros.utilities.DefaultValueMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAUpdateListener;

public class ForwardBoomerangResults<W extends Weight>
extends AbstractBoomerangResults<W> {
    private final ForwardQuery query;
    private final boolean timedout;
    private final IBoomerangStats<W> stats;
    private Stopwatch analysisWatch;
    private long maxMemory;
    private ObservableICFG<Unit, SootMethod> icfg;

    public ForwardBoomerangResults(ForwardQuery query, ObservableICFG<Unit, SootMethod> icfg, boolean timedout, DefaultValueMap<Query, AbstractBoomerangSolver<W>> queryToSolvers, IBoomerangStats<W> stats, Stopwatch analysisWatch) {
        super(queryToSolvers);
        this.query = query;
        this.icfg = icfg;
        this.timedout = timedout;
        this.stats = stats;
        this.analysisWatch = analysisWatch;
        stats.terminated(query, this);
        this.maxMemory = Util.getReallyUsedMemory();
    }

    public Stopwatch getAnalysisWatch() {
        return this.analysisWatch;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public Table<Statement, Val, W> getObjectDestructingStatements() {
        final AbstractBoomerangSolver solver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.get((Object)this.query));
        if (solver == null) {
            return HashBasedTable.create();
        }
        final Set<SootMethod> visitedMethods = solver.getVisitedMethods();
        final ForwardBoomerangSolver forwardSolver = (ForwardBoomerangSolver)((Object)this.queryToSolvers.get((Object)this.query));
        HashBasedTable destructingStatement = HashBasedTable.create();
        Table<Statement, Val, W> res = this.asStatementValWeightTable();
        for (final SootMethod flowReaches : visitedMethods) {
            for (final Unit ep : this.icfg.getEndPointsOf(flowReaches)) {
                final Statement exitStmt = new Statement((Stmt)ep, flowReaches);
                final HashSet escapes = Sets.newHashSet();
                this.icfg.addCallerListener(new CallerListener<Unit, SootMethod>(){

                    @Override
                    public SootMethod getObservedCallee() {
                        return flowReaches;
                    }

                    @Override
                    public void onCallerAdded(Unit callSite, SootMethod m) {
                        SootMethod callee = (SootMethod)ForwardBoomerangResults.this.icfg.getMethodOf(callSite);
                        if (visitedMethods.contains(callee)) {
                            for (Val v : solver.getValsAtStatement(exitStmt)) {
                                for (Unit retSite : ForwardBoomerangResults.this.icfg.getSuccsOf(callSite)) {
                                    escapes.addAll(forwardSolver.computeReturnFlow(flowReaches, (Stmt)ep, v, (Stmt)callSite, (Stmt)retSite));
                                }
                            }
                        }
                    }
                });
                if (!escapes.isEmpty()) continue;
                Map row = res.row((Object)exitStmt);
                this.findLastUsage(exitStmt, row, (Table<Statement, Val, W>)destructingStatement, forwardSolver);
            }
        }
        return destructingStatement;
    }

    public Table<Statement, Val, W> asStatementValWeightTable() {
        return this.asStatementValWeightTable(this.query);
    }

    private void findLastUsage(Statement exitStmt, Map<Val, W> row, Table<Statement, Val, W> destructingStatement, ForwardBoomerangSolver<W> forwardSolver) {
        LinkedList worklist = Lists.newLinkedList();
        worklist.add(exitStmt);
        HashSet visited = Sets.newHashSet();
        while (!worklist.isEmpty()) {
            Statement curr = (Statement)worklist.poll();
            if (!visited.add(curr)) continue;
            boolean valueUsedInStmt = false;
            for (Map.Entry<Val, W> e : row.entrySet()) {
                if (!forwardSolver.valueUsedInStatement((Stmt)curr.getUnit().get(), e.getKey())) continue;
                destructingStatement.put((Object)curr, (Object)e.getKey(), e.getValue());
                valueUsedInStmt = true;
            }
            Stmt stmt = (Stmt)curr.getUnit().get();
            if (valueUsedInStmt || stmt instanceof IdentityStmt) continue;
            for (Unit succ : this.icfg.getPredsOf((Unit)curr.getUnit().get())) {
                worklist.add(new Statement((Stmt)succ, curr.getMethod()));
            }
        }
    }

    public Set<Node<Statement, Val>> getDataFlowPath() {
        HashSet dataFlowPath = Sets.newHashSet();
        WeightedPAutomaton callAut = ((AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)this.query))).getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            if (((Statement)t.getLabel()).equals(Statement.epsilon()) || ((Val)((INode)t.getStart()).fact()).value() instanceof Local && !((Statement)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m()) || !((AbstractBoomerangSolver)((Object)this.queryToSolvers.getOrCreate((Object)this.query))).valueUsedInStatement((Stmt)((Statement)t.getLabel()).getUnit().get(), (Val)((INode)t.getStart()).fact())) continue;
            dataFlowPath.add(new Node((Object)t.getLabel(), ((INode)t.getStart()).fact()));
        }
        return dataFlowPath;
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public Map<Statement, SootMethod> getInvokedMethodOnInstance() {
        Stmt queryUnit;
        final HashMap invokedMethodsOnInstance = Maps.newHashMap();
        if (this.query.stmt().isCallsite() && (queryUnit = (Stmt)this.query.stmt().getUnit().get()).containsInvokeExpr()) {
            invokedMethodsOnInstance.put(this.query.stmt(), queryUnit.getInvokeExpr().getMethod());
        }
        ((AbstractBoomerangSolver)((Object)this.queryToSolvers.get((Object)this.query))).getFieldAutomaton().registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                InstanceInvokeExpr e;
                Stmt callSite;
                if (!((Field)t.getLabel()).equals(Field.empty()) || t.getStart() instanceof GeneratedState) {
                    return;
                }
                Node node = (Node)((INode)t.getStart()).fact();
                Val fact = (Val)node.fact();
                Statement curr = (Statement)node.stmt();
                if (curr.isCallsite() && (callSite = (Stmt)curr.getUnit().get()).getInvokeExpr() instanceof InstanceInvokeExpr && (e = (InstanceInvokeExpr)callSite.getInvokeExpr()).getBase().equals(fact.value())) {
                    invokedMethodsOnInstance.put(curr, e.getMethod());
                }
            }
        });
        return invokedMethodsOnInstance;
    }

    public Set<NullPointer> getPotentialNullPointerDereferences() {
        final HashSet res = Sets.newHashSet();
        ((AbstractBoomerangSolver)((Object)this.queryToSolvers.get((Object)this.query))).getFieldAutomaton().registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (!((Field)t.getLabel()).equals(Field.empty()) || t.getStart() instanceof GeneratedState) {
                    return;
                }
                Node node = (Node)((INode)t.getStart()).fact();
                Val fact = (Val)node.fact();
                SootMethod m = fact.m();
                if (m.hasActiveBody() && Util.isThisLocal(fact, m)) {
                    return;
                }
                Statement curr = (Statement)node.stmt();
                for (Unit unit : ForwardBoomerangResults.this.icfg.getPredsOf(curr.getUnit().get())) {
                    LengthExpr lengthExpr;
                    InstanceFieldRef ifr;
                    InstanceInvokeExpr e;
                    Stmt callSite;
                    Node nullPointerNode = new Node((Object)new Statement((Stmt)unit, curr.getMethod()), (Object)fact);
                    if (unit instanceof Stmt && ((Stmt)unit).containsInvokeExpr() && (callSite = (Stmt)unit).getInvokeExpr() instanceof InstanceInvokeExpr && (e = (InstanceInvokeExpr)callSite.getInvokeExpr()).getBase().equals(fact.value())) {
                        res.add(nullPointerNode);
                    }
                    if (!(unit instanceof AssignStmt)) continue;
                    AssignStmt assignStmt = (AssignStmt)unit;
                    if (assignStmt.getRightOp() instanceof InstanceFieldRef && (ifr = (InstanceFieldRef)assignStmt.getRightOp()).getBase().equals(fact.value())) {
                        res.add(nullPointerNode);
                    }
                    if (!(assignStmt.getRightOp() instanceof LengthExpr) || !(lengthExpr = (LengthExpr)assignStmt.getRightOp()).getOp().equals(fact.value())) continue;
                    res.add(nullPointerNode);
                }
            }
        });
        HashSet resWithContext = Sets.newHashSet();
        for (Node r : res) {
            AbstractBoomerangResults.Context context = this.constructContextGraph(this.query, (Node<Statement, Val>)r);
            resWithContext.add(new NullPointer(this.query.stmt(), this.query.var(), (Statement)r.stmt(), (Val)r.fact(), context.getOpeningContext(), context.getClosingContext()));
        }
        return resWithContext;
    }

    public AbstractBoomerangResults.Context getContext(Node<Statement, Val> node) {
        return this.constructContextGraph(this.query, node);
    }

    public boolean containsCallRecursion() {
        for (Map.Entry e : this.queryToSolvers.entrySet()) {
            if (!((AbstractBoomerangSolver)((Object)e.getValue())).getCallAutomaton().containsLoop()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFieldLoop() {
        for (Map.Entry e : this.queryToSolvers.entrySet()) {
            if (!((AbstractBoomerangSolver)((Object)e.getValue())).getFieldAutomaton().containsLoop()) continue;
            return true;
        }
        return false;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }
}

