/*
 * Decompiled with CFR 0.152.
 */
package boomerang.seedfactory;

import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.seedfactory.Method;
import boomerang.seedfactory.Reachable;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.impl.WeightedPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class SeedFactory<W extends Weight> {
    private final WeightedPushdownSystem<Method, INode<Reachable>, Weight.NoWeight> pds = new WeightedPushdownSystem();
    private final Multimap<Query, Transition<Method, INode<Reachable>>> seedToTransition = HashMultimap.create();
    private final Multimap<SootMethod, Query> seedsPerMethod = HashMultimap.create();
    private final Map<Method, INode<Reachable>> reachableMethods = new HashMap<Method, INode<Reachable>>();
    private final WeightedPAutomaton<Method, INode<Reachable>, Weight.NoWeight> automaton = new WeightedPAutomaton<Method, INode<Reachable>, Weight.NoWeight>(this.wrap(Reachable.entry())){

        public INode<Reachable> createState(INode<Reachable> reachable, Method loc) {
            if (!SeedFactory.this.reachableMethods.containsKey(loc)) {
                SeedFactory.this.reachableMethods.put(loc, new GeneratedState(reachable, (Object)loc));
            }
            return (INode)SeedFactory.this.reachableMethods.get(loc);
        }

        public boolean isGeneratedState(INode<Reachable> reachable) {
            return reachable instanceof GeneratedState;
        }

        public Method epsilon() {
            return Method.epsilon();
        }

        public Weight.NoWeight getZero() {
            return Weight.NO_WEIGHT_ZERO;
        }

        public Weight.NoWeight getOne() {
            return Weight.NO_WEIGHT_ONE;
        }
    };
    private Collection<SootMethod> processed = Sets.newHashSet();
    private Multimap<Query, SootMethod> queryToScope = HashMultimap.create();

    public Collection<Query> computeSeeds() {
        List entryPoints = Scene.v().getEntryPoints();
        System.out.print("Computing seeds starting at " + entryPoints.size() + " entry method(s).");
        Stopwatch watch = Stopwatch.createStarted();
        for (SootMethod m : entryPoints) {
            this.automaton.addTransition(new Transition(this.wrap(Reachable.v()), (Location)new Method(m), this.automaton.getInitialState()));
        }
        this.automaton.registerListener((WPAUpdateListener)new WPAUpdateListener<Method, INode<Reachable>, Weight.NoWeight>(){

            public void onWeightAdded(Transition<Method, INode<Reachable>> t, Weight.NoWeight noWeight, WeightedPAutomaton<Method, INode<Reachable>, Weight.NoWeight> aut) {
                SeedFactory.this.process((Transition<Method, INode<Reachable>>)t);
            }
        });
        if (this.analyseClassInitializers()) {
            HashSet sootClasses = Sets.newHashSet();
            for (SootMethod p : Sets.newHashSet(this.processed)) {
                if (!sootClasses.add(p.getDeclaringClass())) continue;
                this.addStaticInitializerFor(p.getDeclaringClass());
            }
        }
        System.out.print("Seed finding took " + watch.elapsed(TimeUnit.SECONDS) + " second(s) and analyzed " + this.processed.size() + " method(s).");
        return this.seedToTransition.keySet();
    }

    private void addStaticInitializerFor(SootClass declaringClass) {
        for (SootMethod m : declaringClass.getMethods()) {
            if (!m.isStaticInitializer()) continue;
            for (SootMethod ep : Scene.v().getEntryPoints()) {
                this.addPushRule(new Method(ep), new Method(m));
            }
        }
    }

    protected boolean analyseClassInitializers() {
        return false;
    }

    protected abstract Collection<? extends Query> generate(SootMethod var1, Stmt var2);

    private void process(Transition<Method, INode<Reachable>> t) {
        Method curr = (Method)t.getLabel();
        SootMethod m = curr.getMethod();
        if (!m.hasActiveBody()) {
            return;
        }
        this.computeQueriesPerMethod(m);
        for (Query q : this.seedsPerMethod.get((Object)m)) {
            this.seedToTransition.put((Object)q, t);
        }
    }

    private void computeQueriesPerMethod(final SootMethod m) {
        if (!this.processed.add(m)) {
            return;
        }
        HashSet seeds = Sets.newHashSet();
        for (final Unit u : m.getActiveBody().getUnits()) {
            if (this.icfg().isCallStmt(u)) {
                this.icfg().addCalleeListener(new CalleeListener<Unit, SootMethod>(){

                    @Override
                    public Unit getObservedCaller() {
                        return u;
                    }

                    @Override
                    public void onCalleeAdded(Unit n, SootMethod callee) {
                        if (!callee.hasActiveBody() || !callee.getDeclaringClass().isApplicationClass()) {
                            return;
                        }
                        SeedFactory.this.addPushRule(new Method(m), new Method(callee));
                    }
                });
            }
            seeds.addAll(this.generate(m, (Stmt)u));
        }
        this.seedsPerMethod.putAll((Object)m, (Iterable)seeds);
    }

    private void addPushRule(Method caller, Method callee) {
        this.automaton.addTransition(new Transition(this.automaton.createState(this.wrap(Reachable.v()), (Location)caller), (Location)callee, this.automaton.createState(this.wrap(Reachable.v()), (Location)callee)));
    }

    private INode<Reachable> wrap(Reachable r) {
        return new SingleNode((Object)r);
    }

    public abstract ObservableICFG<Unit, SootMethod> icfg();

    public Collection<SootMethod> getMethodScope(Query query) {
        HashSet scope = Sets.newHashSet();
        if (this.queryToScope.containsKey((Object)query)) {
            return this.queryToScope.get((Object)query);
        }
        for (Transition t : this.seedToTransition.get((Object)query)) {
            scope.add(((Method)t.getLabel()).getMethod());
            this.automaton.registerListener((WPAStateListener)new TransitiveClosure((INode<Reachable>)((INode)t.getTarget()), scope, query));
        }
        this.queryToScope.putAll((Object)query, (Iterable)scope);
        return scope;
    }

    public Collection<SootMethod> getAnyMethodScope() {
        HashSet out = Sets.newHashSet();
        for (Query q : this.seedToTransition.keySet()) {
            out.addAll(this.getMethodScope(q));
        }
        return out;
    }

    private class TransitiveClosure
    extends WPAStateListener<Method, INode<Reachable>, Weight.NoWeight> {
        private final Set<SootMethod> scope;
        private Query query;

        public TransitiveClosure(INode<Reachable> start, Set<SootMethod> scope, Query query) {
            super(start);
            this.scope = scope;
            this.query = query;
        }

        public void onOutTransitionAdded(Transition<Method, INode<Reachable>> t, Weight.NoWeight w, WeightedPAutomaton<Method, INode<Reachable>, Weight.NoWeight> weightedPAutomaton) {
            this.scope.add(((Method)t.getLabel()).getMethod());
            SeedFactory.this.automaton.registerListener((WPAStateListener)new TransitiveClosure((INode<Reachable>)((INode)t.getTarget()), this.scope, this.query));
        }

        public void onInTransitionAdded(Transition<Method, INode<Reachable>> t, Weight.NoWeight w, WeightedPAutomaton<Method, INode<Reachable>, Weight.NoWeight> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TransitiveClosure other = (TransitiveClosure)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }

        private SeedFactory getOuterType() {
            return SeedFactory.this;
        }
    }
}

