/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BackwardQuery;
import boomerang.BoomerangOptions;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.StaticFieldVal;
import boomerang.jimple.Val;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.CallPopNode;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Weight;
import wpds.interfaces.State;

public abstract class BackwardBoomerangSolver<W extends Weight>
extends AbstractBoomerangSolver<W> {
    public BackwardBoomerangSolver(ObservableICFG<Unit, SootMethod> icfg, BackwardQuery query, Map<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>> genField, BoomerangOptions options, NestedWeightedPAutomatons<Statement, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> fieldSummaries) {
        super(icfg, query, genField, options, callSummaries, fieldSummaries);
    }

    @Override
    protected boolean killFlow(SootMethod m, Stmt curr, Val value) {
        if (value.isStatic()) {
            return false;
        }
        return !m.getActiveBody().getLocals().contains((Object)value.value());
    }

    @Override
    public INode<Node<Statement, Val>> generateFieldState(INode<Node<Statement, Val>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState((INode)this.fieldAutomaton.getInitialState(), (Object)loc));
        }
        return (INode)this.generatedFieldState.get(e);
    }

    @Override
    protected Collection<? extends State> computeReturnFlow(SootMethod method, Stmt curr, Val value, Stmt callSite, Stmt returnSite) {
        Statement returnSiteStatement = new Statement(returnSite, (SootMethod)this.icfg.getMethodOf(returnSite));
        HashSet out = Sets.newHashSet();
        if (!method.isStatic() && method.getActiveBody().getThisLocal().equals(value.value()) && callSite.containsInvokeExpr() && callSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)callSite.getInvokeExpr();
            out.add(new CallPopNode((Object)new Val(iie.getBase(), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, (Object)returnSiteStatement));
        }
        int index = 0;
        for (Local param : method.getActiveBody().getParameterLocals()) {
            if (param.equals(value.value()) && callSite.containsInvokeExpr()) {
                InvokeExpr ie = callSite.getInvokeExpr();
                out.add(new CallPopNode((Object)new Val(ie.getArg(index), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, (Object)returnSiteStatement));
            }
            ++index;
        }
        if (value.isStatic()) {
            out.add(new CallPopNode((Object)new StaticFieldVal(value.value(), ((StaticFieldVal)value).field(), (SootMethod)this.icfg.getMethodOf(callSite)), SyncPDSSolver.PDSSystem.CALLS, (Object)returnSiteStatement));
        }
        return out;
    }

    protected void callFlow(SootMethod caller, Node<Statement, Val> curr) {
        Statement callSite = (Statement)curr.stmt();
        this.icfg.addCalleeListener(new CallSiteCalleeListener(curr, caller, callSite));
        InvokeExpr invokeExpr = ((Stmt)callSite.getUnit().get()).getInvokeExpr();
        if (invokeExpr.getMethod().getDeclaringClass().isPhantom() || invokeExpr.getMethod().isNative()) {
            this.normalFlow(caller, curr);
            for (Statement returnSite : this.getSuccsOf(callSite)) {
                for (State s : this.getEmptyCalleeFlow(caller, (Stmt)callSite.getUnit().get(), (Val)curr.fact(), (Stmt)returnSite.getUnit().get())) {
                    this.propagate(curr, s);
                }
            }
        }
    }

    public void computeSuccessor(Node<Statement, Val> node) {
        Statement stmt = (Statement)node.stmt();
        Optional<Stmt> unit = stmt.getUnit();
        logger.trace("Computing successor for {} with solver {}", node, (Object)this);
        if (unit.isPresent()) {
            Stmt curr = (Stmt)unit.get();
            Val value = (Val)node.fact();
            SootMethod method = (SootMethod)this.icfg.getMethodOf(curr);
            if (method == null) {
                return;
            }
            if (this.killFlow(method, curr, value)) {
                return;
            }
            if (this.options.isIgnoredMethod(method)) {
                return;
            }
            if (curr.containsInvokeExpr() && this.valueUsedInStatement(curr, value) && this.INTERPROCEDURAL) {
                this.callFlow(method, node);
            } else if (this.icfg.isExitStmt(curr)) {
                this.returnFlow(method, node);
            } else {
                this.normalFlow(method, node);
            }
        }
    }

    protected void normalFlow(SootMethod method, Node<Statement, Val> currNode) {
        HashSet out = Sets.newHashSet();
        Stmt curr = (Stmt)((Statement)currNode.stmt()).getUnit().get();
        Val value = (Val)currNode.fact();
        for (Unit unit : this.icfg.getSuccsOf(curr)) {
            Collection<State> flow = this.computeNormalFlow(method, curr, value, (Stmt)unit);
            out.addAll(flow);
        }
        for (State state : out) {
            this.propagate(currNode, state);
        }
    }

    protected Collection<? extends State> computeCallFlow(SootMethod caller, Statement returnSite, Statement callSite, InvokeExpr invokeExpr, Val fact, SootMethod callee, Stmt calleeSp) {
        InstanceInvokeExpr iie;
        if (!callee.hasActiveBody()) {
            return Collections.emptySet();
        }
        if (calleeSp instanceof ThrowStmt) {
            return Collections.emptySet();
        }
        Body calleeBody = callee.getActiveBody();
        HashSet out = Sets.newHashSet();
        if (invokeExpr instanceof InstanceInvokeExpr && (iie = (InstanceInvokeExpr)invokeExpr).getBase().equals(fact.value()) && !callee.isStatic()) {
            out.add(new PushNode((Object)new Statement(calleeSp, callee), (Object)new Val((Value)calleeBody.getThisLocal(), callee), (Object)returnSite, SyncPDSSolver.PDSSystem.CALLS));
        }
        List parameterLocals = calleeBody.getParameterLocals();
        int i = 0;
        for (Value arg : invokeExpr.getArgs()) {
            if (arg.equals(fact.value()) && parameterLocals.size() > i) {
                Local param = (Local)parameterLocals.get(i);
                out.add(new PushNode((Object)new Statement(calleeSp, callee), (Object)new Val((Value)param, callee), (Object)returnSite, SyncPDSSolver.PDSSystem.CALLS));
            }
            ++i;
        }
        if (callSite.getUnit().get() instanceof AssignStmt && calleeSp instanceof ReturnStmt) {
            AssignStmt as = (AssignStmt)callSite.getUnit().get();
            ReturnStmt retStmt = (ReturnStmt)calleeSp;
            if (as.getLeftOp().equals(fact.value())) {
                out.add(new PushNode((Object)new Statement(calleeSp, callee), (Object)new Val(retStmt.getOp(), callee), (Object)returnSite, SyncPDSSolver.PDSSystem.CALLS));
            }
        }
        if (fact.isStatic()) {
            out.add(new PushNode((Object)new Statement(calleeSp, callee), (Object)new StaticFieldVal(fact.value(), ((StaticFieldVal)fact).field(), callee), (Object)returnSite, SyncPDSSolver.PDSSystem.CALLS));
        }
        return out;
    }

    @Override
    protected Collection<State> computeNormalFlow(SootMethod method, Stmt curr, Val fact, Stmt succ) {
        if (this.options.isAllocationVal(fact.value())) {
            return Collections.emptySet();
        }
        HashSet out = Sets.newHashSet();
        boolean leftSideMatches = false;
        if (curr instanceof AssignStmt) {
            Value base;
            StaticFieldRef sfr;
            InstanceFieldRef ifr;
            AssignStmt assignStmt = (AssignStmt)curr;
            Value leftOp = assignStmt.getLeftOp();
            Value rightOp = assignStmt.getRightOp();
            if (leftOp.equals(fact.value())) {
                leftSideMatches = true;
                if (rightOp instanceof InstanceFieldRef) {
                    if (this.options.trackFields()) {
                        ifr = (InstanceFieldRef)rightOp;
                        out.add(new PushNode((Object)new Statement(succ, method), (Object)new Val(ifr.getBase(), method), (Object)new Field(ifr.getField()), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                } else if (rightOp instanceof StaticFieldRef) {
                    if (this.options.trackFields() && this.options.staticFlows()) {
                        sfr = (StaticFieldRef)rightOp;
                        out.add(new Node((Object)new Statement(succ, method), (Object)new StaticFieldVal(leftOp, sfr.getField(), method)));
                    }
                } else if (rightOp instanceof ArrayRef) {
                    ifr = (ArrayRef)rightOp;
                    if (this.options.trackFields() && this.options.arrayFlows()) {
                        out.add(new PushNode((Object)new Statement(succ, method), (Object)new Val(ifr.getBase(), method), (Object)Field.array(), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                } else if (rightOp instanceof CastExpr) {
                    CastExpr castExpr = (CastExpr)rightOp;
                    out.add(new Node((Object)new Statement(succ, method), (Object)new Val(castExpr.getOp(), method)));
                } else if (this.isFieldLoadWithBase(curr, fact)) {
                    out.add(new ExclusionNode((Object)new Statement(succ, method), (Object)fact, (Object)this.getLoadedField(curr)));
                } else {
                    out.add(new Node((Object)new Statement(succ, method), (Object)new Val(rightOp, method)));
                }
            }
            if (leftOp instanceof InstanceFieldRef) {
                ifr = (InstanceFieldRef)leftOp;
                Value base2 = ifr.getBase();
                if (base2.equals(fact.value())) {
                    NodeWithLocation succNode = new NodeWithLocation((Object)new Statement(succ, method), (Object)new Val(rightOp, method), (Object)new Field(ifr.getField()));
                    out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (leftOp instanceof StaticFieldRef) {
                sfr = (StaticFieldRef)leftOp;
                if (fact.isStatic() && fact.equals(new StaticFieldVal(leftOp, sfr.getField(), method))) {
                    out.add(new Node((Object)new Statement(succ, method), (Object)new Val(rightOp, method)));
                }
            } else if (leftOp instanceof ArrayRef && (base = (ifr = (ArrayRef)leftOp).getBase()).equals(fact.value())) {
                NodeWithLocation succNode = new NodeWithLocation((Object)new Statement(succ, method), (Object)new Val(rightOp, method), (Object)Field.array());
                out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
            }
        }
        if (!leftSideMatches) {
            out.add(new Node((Object)new Statement(succ, method), (Object)fact));
        }
        return out;
    }

    private final class CallSiteCalleeListener
    implements CalleeListener<Unit, SootMethod> {
        private final Node<Statement, Val> curr;
        private final SootMethod caller;
        private final Statement callSite;

        private CallSiteCalleeListener(Node<Statement, Val> curr, SootMethod caller, Statement callSite) {
            this.curr = curr;
            this.caller = caller;
            this.callSite = callSite;
        }

        @Override
        public Unit getObservedCaller() {
            return (Unit)this.callSite.getUnit().get();
        }

        @Override
        public void onCalleeAdded(Unit callSite, SootMethod callee) {
            if (callee.isStaticInitializer()) {
                return;
            }
            if (!callee.hasActiveBody()) {
                BackwardBoomerangSolver.this.normalFlow((SootMethod)BackwardBoomerangSolver.this.icfg.getMethodOf(callSite), this.curr);
                return;
            }
            HashSet out = Sets.newHashSet();
            InvokeExpr invokeExpr = ((Stmt)((Statement)this.curr.stmt()).getUnit().get()).getInvokeExpr();
            for (Unit calleeSp : BackwardBoomerangSolver.this.icfg.getStartPointsOf(callee)) {
                for (Unit returnSite : BackwardBoomerangSolver.this.icfg.getSuccsOf(callSite)) {
                    Collection<State> res = BackwardBoomerangSolver.this.computeCallFlow(this.caller, new Statement((Stmt)returnSite, this.caller), new Statement((Stmt)callSite, this.caller), invokeExpr, (Val)this.curr.fact(), callee, (Stmt)calleeSp);
                    out.addAll(res);
                }
            }
            for (State o : out) {
                BackwardBoomerangSolver.this.propagate(this.curr, o);
            }
            BackwardBoomerangSolver.this.addReachable(callee);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.caller == null ? 0 : this.caller.hashCode());
            result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteCalleeListener other = (CallSiteCalleeListener)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            if (this.caller == null ? other.caller != null : !this.caller.equals(other.caller)) {
                return false;
            }
            return !(this.curr == null ? other.curr != null : !this.curr.equals(other.curr));
        }

        private BackwardBoomerangSolver getOuterType() {
            return BackwardBoomerangSolver.this;
        }
    }
}

