/*
 * Decompiled with CFR 0.152.
 */
package boomerang.util;

import boomerang.jimple.Field;
import boomerang.jimple.Val;
import boomerang.util.AccessPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.util.Chain;

public class AccessPathParser {
    public static Collection<? extends AccessPath> parseAllFromString(String value, SootMethod m) {
        HashSet results = Sets.newHashSet();
        for (String v : value.split(";")) {
            results.add(AccessPathParser.parseAccessPathFromString(v, m));
        }
        return results;
    }

    private static AccessPath parseAccessPathFromString(String value, SootMethod m) {
        String baseName;
        ArrayList fieldNames = Lists.newArrayList();
        boolean overApproximated = value.endsWith("*");
        if (!value.contains("[")) {
            baseName = value;
        } else {
            int i = value.indexOf("[");
            baseName = value.substring(0, i);
            fieldNames = Lists.newArrayList((Object[])value.substring(i + 1, value.length() - (!overApproximated ? 1 : 2)).split(","));
        }
        ArrayList fields = Lists.newArrayList();
        Local base = AccessPathParser.getLocal(m, baseName);
        Type type = base.getType();
        for (String fieldName : fieldNames) {
            if (!(type instanceof RefType)) continue;
            RefType refType = (RefType)type;
            SootField fieldByName = refType.getSootClass().getFieldByName(fieldName);
            fields.add(new Field(fieldByName));
            type = fieldByName.getType();
        }
        return new AccessPath(new Val((Value)base, m), !overApproximated ? fields : Sets.newHashSet((Iterable)fields));
    }

    private static Local getLocal(SootMethod m, String baseName) {
        Chain locals = m.getActiveBody().getLocals();
        for (Local l : locals) {
            if (!l.getName().equals(baseName)) continue;
            return l;
        }
        throw new RuntimeException("Could not find local with name " + baseName + " in method " + m);
    }
}

