/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import boomerang.jimple.Statement;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import wpds.impl.Weight;

public class DataFlowPathWeight
extends Weight {
    private static DataFlowPathWeight one;
    private static DataFlowPathWeight zero;
    private Set<Statement> allStatements;
    private Set<Statement> lastStatements;
    private String rep;

    private DataFlowPathWeight(String rep) {
        this.rep = rep;
    }

    private DataFlowPathWeight(Set<Statement> allStatement, Set<Statement> lastStatements) {
        this.allStatements = allStatement;
        this.lastStatements = lastStatements;
    }

    public DataFlowPathWeight(Statement relevantStatement) {
        this.allStatements = Sets.newHashSet();
        this.lastStatements = Sets.newHashSet();
        this.allStatements.add(relevantStatement);
        this.lastStatements.add(relevantStatement);
    }

    public Weight extendWith(Weight o) {
        if (!(o instanceof DataFlowPathWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        DataFlowPathWeight other = (DataFlowPathWeight)o;
        if (other.equals((Object)DataFlowPathWeight.one())) {
            return this;
        }
        if (this.equals((Object)DataFlowPathWeight.one())) {
            return other;
        }
        if (other.equals((Object)DataFlowPathWeight.zero()) || this.equals((Object)DataFlowPathWeight.zero())) {
            return DataFlowPathWeight.zero();
        }
        HashSet newAllStatements = Sets.newHashSet();
        newAllStatements.addAll(this.allStatements);
        newAllStatements.addAll(other.allStatements);
        return new DataFlowPathWeight(newAllStatements, other.lastStatements);
    }

    public Weight combineWith(Weight other) {
        return this.extendWith(other);
    }

    public static DataFlowPathWeight one() {
        if (one == null) {
            one = new DataFlowPathWeight("ONE");
        }
        return one;
    }

    public static DataFlowPathWeight zero() {
        if (zero == null) {
            zero = new DataFlowPathWeight("ZERO");
        }
        return zero;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allStatements == null ? 0 : this.allStatements.hashCode());
        result = 31 * result + (this.lastStatements == null ? 0 : this.lastStatements.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataFlowPathWeight other = (DataFlowPathWeight)((Object)obj);
        if (this.allStatements == null ? other.allStatements != null : !this.allStatements.equals(other.allStatements)) {
            return false;
        }
        if (this.lastStatements == null ? other.lastStatements != null : !this.lastStatements.equals(other.lastStatements)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        return "\nLast relevant: " + this.lastStatements + "\nAll statements: " + this.allStatements;
    }
}

