/*
 * Decompiled with CFR 0.152.
 */
package boomerang.controlflowgraph;

import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.PredecessorListener;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.scene.Statement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;

public class DynamicCFG
implements ObservableControlFlowGraph {
    Multimap<Statement, PredecessorListener> statementToPredecessorListener = HashMultimap.create();
    Multimap<Statement, SuccessorListener> statementToSuccessorListener = HashMultimap.create();
    Multimap<Statement, Statement> succToPred = HashMultimap.create();
    Multimap<Statement, Statement> predToSucc = HashMultimap.create();

    @Override
    public void addPredsOfListener(PredecessorListener l) {
        if (this.statementToPredecessorListener.put((Object)l.getCurr(), (Object)l)) {
            ArrayList preds = Lists.newArrayList((Iterable)this.succToPred.get((Object)l.getCurr()));
            for (Statement pred : preds) {
                l.getPredecessor(pred);
            }
        }
    }

    @Override
    public void addSuccsOfListener(SuccessorListener l) {
        if (this.statementToSuccessorListener.put((Object)l.getCurr(), (Object)l)) {
            ArrayList succs = Lists.newArrayList((Iterable)this.predToSucc.get((Object)l.getCurr()));
            for (Statement succ : succs) {
                l.getSuccessor(succ);
            }
        }
    }

    @Override
    public void step(Statement curr, Statement succ) {
        this.predToSucc.put((Object)curr, (Object)succ);
        this.succToPred.put((Object)succ, (Object)curr);
        ArrayList lsnr = Lists.newArrayList((Iterable)this.statementToSuccessorListener.get((Object)curr));
        for (SuccessorListener l : lsnr) {
            l.getSuccessor(succ);
        }
        ArrayList lisnr = Lists.newArrayList((Iterable)this.statementToPredecessorListener.get((Object)succ));
        for (PredecessorListener l : lisnr) {
            l.getPredecessor(curr);
        }
    }

    @Override
    public void unregisterAllListeners() {
        this.statementToPredecessorListener.clear();
        this.statementToSuccessorListener.clear();
    }
}

