/*
 * Decompiled with CFR 0.152.
 */
package boomerang.controlflowgraph;

import boomerang.ForwardQuery;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.jimple.JimpleMethod;
import boomerang.scene.jimple.JimpleStatement;
import boomerang.scene.sparse.SparseAliasingCFG;
import boomerang.scene.sparse.SparseCFGCache;
import boomerang.solver.ForwardBoomerangSolver;
import java.util.Collection;
import org.slf4j.Logger;
import soot.SootMethod;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.Node;
import wpds.interfaces.State;

public class ForwardSolverSuccessorListener
extends SuccessorListener {
    private final ForwardQuery query;
    private final ControlFlowGraph.Edge curr;
    private final Val value;
    private final Method method;
    private final Node<ControlFlowGraph.Edge, Val> node;
    private final Logger LOGGER;
    private final ForwardBoomerangSolver owner;

    public ForwardSolverSuccessorListener(ControlFlowGraph.Edge curr, ForwardQuery query, Val value, Method method, Node<ControlFlowGraph.Edge, Val> node, Logger LOGGER, ForwardBoomerangSolver owner) {
        super(curr.getTarget());
        this.query = query;
        this.curr = curr;
        this.value = value;
        this.method = method;
        this.node = node;
        this.LOGGER = LOGGER;
        this.owner = owner;
    }

    public ControlFlowGraph.Edge getEdge() {
        return this.curr;
    }

    @Override
    public void getSuccessor(Statement succ) {
        if (this.query.getType().isNullType() && this.curr.getStart().isIfStmt() && this.curr.getStart().killAtIfStmt(this.value, succ)) {
            return;
        }
        if (!this.method.getLocals().contains(this.value) && !this.value.isStatic()) {
            return;
        }
        if (this.curr.getTarget().containsInvokeExpr() && (this.curr.getTarget().isParameter(this.value) || this.value.isStatic())) {
            this.owner.callFlow(this.method, this.node, new ControlFlowGraph.Edge(this.curr.getTarget(), succ), this.curr.getTarget().getInvokeExpr());
        } else {
            this.owner.checkForFieldOverwrite(this.curr, this.value);
            Collection<State> out = this.owner.computeNormalFlow(this.method, new ControlFlowGraph.Edge(this.curr.getTarget(), succ), this.value);
            for (State s : out) {
                this.LOGGER.trace("{}: {} -> {}", new Object[]{s, this.node, this.owner.getQuery()});
                this.owner.propagate(this.node, s);
            }
        }
    }

    private SparseAliasingCFG getSparseCFG(Method method, Statement stmt, Val currentVal) {
        SootMethod sootMethod = ((JimpleMethod)method).getDelegate();
        Stmt sootStmt = ((JimpleStatement)stmt).getDelegate();
        SparseCFGCache sparseCFGCache = SparseCFGCache.getInstance((SparseCFGCache.SparsificationStrategy)this.owner.getOptions().getSparsificationStrategy(), (boolean)true);
        SparseAliasingCFG sparseCFG = sparseCFGCache.getSparseCFGForForwardPropagation(sootMethod, sootStmt, currentVal);
        return sparseCFG;
    }
}

