/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.debugger.Debugger;
import boomerang.solver.ForwardBoomerangSolver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wpds.impl.Weight;

public class ConsoleDebugger<W extends Weight>
extends Debugger<W> {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleDebugger.class);

    public void done(Map<ForwardQuery, ForwardBoomerangSolver<W>> queryToSolvers) {
        int totalRules = 0;
        for (Query query : queryToSolvers.keySet()) {
            totalRules += queryToSolvers.get(query).getNumberOfRules();
        }
        logger.debug("Total number of rules: " + totalRules);
        for (Query query : queryToSolvers.keySet()) {
            logger.debug("========================");
            logger.debug(query.toString());
            logger.debug("========================");
            queryToSolvers.get(query).debugOutput();
            queryToSolvers.get(query).debugOutput();
        }
    }
}

